/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.util;

import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class PropertyModelHandlerHelper
extends ContextAwareBase {
    public static final String HANDLE_PROPERTY_MODEL_METHOD_NAME = "handlePropertyModel";

    public PropertyModelHandlerHelper(ContextAware contextAware) {
        super(contextAware);
    }

    public void handlePropertyModel(ContextAwarePropertyContainer contextAwarePropertyContainer, String string, String string2, String string3, String string4, String string5) {
        PropertyModel propertyModel = new PropertyModel();
        propertyModel.setName(string);
        propertyModel.setValue(string2);
        propertyModel.setFile(string3);
        propertyModel.setResource(string4);
        propertyModel.setScopeStr(string5);
        this.handlePropertyModel(contextAwarePropertyContainer, propertyModel);
    }

    public void handlePropertyModel(ContextAwarePropertyContainer contextAwarePropertyContainer, PropertyModel propertyModel) {
        ActionUtil.Scope scope = ActionUtil.stringToScope(propertyModel.getScopeStr());
        if (PropertyModelHandlerHelper.checkFileAttributeSanity(propertyModel)) {
            String string = propertyModel.getFile();
            string = contextAwarePropertyContainer.subst(string);
            try (FileInputStream fileInputStream = new FileInputStream(string);){
                PropertyModelHandlerHelper.loadAndSetProperties(contextAwarePropertyContainer, fileInputStream, scope);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.addError("Could not find properties file [" + string + "].");
            }
            catch (IOException | IllegalArgumentException exception) {
                this.addError("Could not read properties file [" + string + "].", exception);
            }
        } else if (PropertyModelHandlerHelper.checkResourceAttributeSanity(propertyModel)) {
            String string = propertyModel.getResource();
            URL uRL = Loader.getResourceBySelfClassLoader(string = contextAwarePropertyContainer.subst(string));
            if (uRL == null) {
                this.addError("Could not find resource [" + string + "].");
            } else {
                try (InputStream inputStream = uRL.openStream();){
                    PropertyModelHandlerHelper.loadAndSetProperties(contextAwarePropertyContainer, inputStream, scope);
                }
                catch (IOException iOException) {
                    this.addError("Could not read resource file [" + string + "].", iOException);
                }
            }
        } else if (PropertyModelHandlerHelper.checkValueNameAttributesSanity(propertyModel)) {
            String string = propertyModel.getValue();
            string = string.trim();
            string = contextAwarePropertyContainer.subst(string);
            ActionUtil.setProperty(contextAwarePropertyContainer, propertyModel.getName(), string, scope);
        } else {
            this.addError("In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.");
        }
    }

    public static boolean checkFileAttributeSanity(PropertyModel propertyModel) {
        String string = propertyModel.getFile();
        String string2 = propertyModel.getName();
        String string3 = propertyModel.getValue();
        String string4 = propertyModel.getResource();
        return !OptionHelper.isNullOrEmptyOrAllSpaces(string) && OptionHelper.isNullOrEmptyOrAllSpaces(string2) && OptionHelper.isNullOrEmptyOrAllSpaces(string3) && OptionHelper.isNullOrEmptyOrAllSpaces(string4);
    }

    public static boolean checkResourceAttributeSanity(PropertyModel propertyModel) {
        String string = propertyModel.getFile();
        String string2 = propertyModel.getName();
        String string3 = propertyModel.getValue();
        String string4 = propertyModel.getResource();
        return !OptionHelper.isNullOrEmptyOrAllSpaces(string4) && OptionHelper.isNullOrEmptyOrAllSpaces(string2) && OptionHelper.isNullOrEmptyOrAllSpaces(string3) && OptionHelper.isNullOrEmptyOrAllSpaces(string);
    }

    public static boolean checkValueNameAttributesSanity(PropertyModel propertyModel) {
        String string = propertyModel.getFile();
        String string2 = propertyModel.getName();
        String string3 = propertyModel.getValue();
        String string4 = propertyModel.getResource();
        return !OptionHelper.isNullOrEmptyOrAllSpaces(string2) && !OptionHelper.isNullOrEmptyOrAllSpaces(string3) && OptionHelper.isNullOrEmptyOrAllSpaces(string) && OptionHelper.isNullOrEmptyOrAllSpaces(string4);
    }

    public static void setProperty(ContextAwarePropertyContainer contextAwarePropertyContainer, String string, String string2, ActionUtil.Scope scope) {
        switch (scope) {
            case LOCAL: {
                contextAwarePropertyContainer.addSubstitutionProperty(string, string2);
                break;
            }
            case CONTEXT: {
                contextAwarePropertyContainer.getContext().putProperty(string, string2);
                break;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperty(contextAwarePropertyContainer, string, string2);
            }
        }
    }

    public static void setProperties(ContextAwarePropertyContainer contextAwarePropertyContainer, Properties properties, ActionUtil.Scope scope) {
        switch (scope) {
            case LOCAL: {
                contextAwarePropertyContainer.addSubstitutionProperties(properties);
                break;
            }
            case CONTEXT: {
                ContextUtil contextUtil = new ContextUtil(contextAwarePropertyContainer.getContext());
                contextUtil.addProperties(properties);
                break;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperties(contextAwarePropertyContainer, properties);
            }
        }
    }

    public static void loadAndSetProperties(ContextAwarePropertyContainer contextAwarePropertyContainer, InputStream inputStream, ActionUtil.Scope scope) {
        Properties properties = new Properties();
        properties.load(inputStream);
        PropertyModelHandlerHelper.setProperties(contextAwarePropertyContainer, properties, scope);
    }
}

