/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileFilterUtil {
    public static void sortFileArrayByName(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                String string = file.getName();
                String string2 = file2.getName();
                return string.compareTo(string2);
            }
        });
    }

    public static void reverseSortFileArrayByName(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                String string = file.getName();
                String string2 = file2.getName();
                return string2.compareTo(string);
            }
        });
    }

    public static String afterLastSlash(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static boolean isEmptyDirectory(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("[" + String.valueOf(file) + "] must be a directory");
        }
        String[] stringArray = file.list();
        return stringArray == null || stringArray.length == 0;
    }

    public static File[] filesInFolderMatchingStemRegex(File file2, String string2) {
        if (file2 == null) {
            return new File[0];
        }
        if (!file2.exists() || !file2.isDirectory()) {
            return new File[0];
        }
        Pattern pattern = Pattern.compile(string2);
        return file2.listFiles((file, string) -> pattern.matcher(string).matches());
    }

    public static int findHighestCounter(File[] fileArray, String string) {
        int n = Integer.MIN_VALUE;
        for (File file : fileArray) {
            int n2 = FileFilterUtil.extractCounter(file, string);
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public static int extractCounter(File file, String string) {
        String string2;
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(string2 = file.getName());
        if (!matcher.matches()) {
            throw new IllegalStateException("The regex [" + string + "] should match [" + string2 + "]");
        }
        String string3 = matcher.group(1);
        return Integer.parseInt(string3);
    }

    public static String slashify(String string) {
        return string.replace('\\', '/');
    }

    public static void removeEmptyParentDirectories(File file, int n) {
        if (n >= 3) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2.isDirectory() && FileFilterUtil.isEmptyDirectory(file2)) {
            file2.delete();
            FileFilterUtil.removeEmptyParentDirectories(file2, n + 1);
        }
    }
}

