/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusUtil {
    StatusManager sm;

    public StatusUtil(StatusManager statusManager) {
        this.sm = statusManager;
    }

    public StatusUtil(Context context) {
        this.sm = context.getStatusManager();
    }

    public static boolean contextHasStatusListener(Context context) {
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            return false;
        }
        List<StatusListener> list = statusManager.getCopyOfStatusListenerList();
        return list != null && list.size() != 0;
    }

    public static List<Status> filterStatusListByTimeThreshold(List<Status> list, long l) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        for (Status status : list) {
            if (status.getTimestamp() < l) continue;
            arrayList.add(status);
        }
        return arrayList;
    }

    public void addStatus(Status status) {
        if (this.sm != null) {
            this.sm.add(status);
        }
    }

    public void addInfo(Object object, String string) {
        this.addStatus(new InfoStatus(string, object));
    }

    public void addWarn(Object object, String string) {
        this.addStatus(new WarnStatus(string, object));
    }

    public void addError(Object object, String string, Throwable throwable) {
        this.addStatus(new ErrorStatus(string, object, throwable));
    }

    public boolean hasXMLParsingErrors(long l) {
        return this.containsMatch(l, 2, "XML_PARSING");
    }

    public boolean noXMLParsingErrorsOccurred(long l) {
        return !this.hasXMLParsingErrors(l);
    }

    public int getHighestLevel(long l) {
        List<Status> list = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l);
        int n = 0;
        for (Status status : list) {
            if (status.getLevel() <= n) continue;
            n = status.getLevel();
        }
        return n;
    }

    public boolean isErrorFree(long l) {
        return this.getHighestLevel(l) < 2;
    }

    public boolean isWarningOrErrorFree(long l) {
        return 1 > this.getHighestLevel(l);
    }

    public boolean containsMatch(long l, int n, String string) {
        List<Status> list = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l);
        Pattern pattern = Pattern.compile(string);
        for (Status status : list) {
            String string2;
            Matcher matcher;
            if (n != status.getLevel() || !(matcher = pattern.matcher(string2 = status.getMessage())).lookingAt()) continue;
            return true;
        }
        return false;
    }

    public boolean containsMatch(int n, String string) {
        return this.containsMatch(0L, n, string);
    }

    public boolean containsMatch(String string) {
        Pattern pattern = Pattern.compile(string);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string2 = status.getMessage();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.lookingAt()) continue;
            return true;
        }
        return false;
    }

    public int levelCount(int n, long l) {
        List<Status> list = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l);
        int n2 = 0;
        for (Status status : list) {
            if (status.getLevel() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int matchCount(String string) {
        int n = 0;
        Pattern pattern = Pattern.compile(string);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string2 = status.getMessage();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.lookingAt()) continue;
            ++n;
        }
        return n;
    }

    public boolean containsException(Class<?> clazz) {
        return this.containsException(clazz, null);
    }

    public boolean containsException(Class<?> clazz, String string) {
        for (Status status : this.sm.getCopyOfStatusList()) {
            for (Throwable throwable = status.getThrowable(); throwable != null; throwable = throwable.getCause()) {
                if (!throwable.getClass().getName().equals(clazz.getName())) continue;
                if (string == null) {
                    return true;
                }
                if (!this.checkRegexMatch(throwable.getMessage(), string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkRegexMatch(String string, String string2) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.lookingAt();
    }

    public long timeOfLastReset() {
        List<Status> list = this.sm.getCopyOfStatusList();
        if (list == null) {
            return -1L;
        }
        int n = list.size();
        for (int i = n - 1; i >= 0; --i) {
            Status status = list.get(i);
            if (!"Will reset and reconfigure context ".equals(status.getMessage())) continue;
            return status.getTimestamp();
        }
        return -1L;
    }

    public static String diff(Status status, Status status2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (status.getLevel() != status2.getLevel()) {
            stringBuilder.append(" left.level ").append(status.getLevel()).append(" != right.level ").append(status2.getLevel());
        }
        if (status.getTimestamp() != status2.getTimestamp()) {
            stringBuilder.append(" left.timestamp ").append(status.getTimestamp()).append(" != right.timestamp ").append(status2.getTimestamp());
        }
        if (!Objects.equals(status.getMessage(), status2.getMessage())) {
            stringBuilder.append(" left.message ").append(status.getMessage()).append(" != right.message ").append(status2.getMessage());
        }
        return stringBuilder.toString();
    }
}

