/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.testUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileToBufferUtil {
    public static void readIntoList(File file, List<String> list) {
        if (file.getName().endsWith(".gz")) {
            FileToBufferUtil.gzFileReadIntoList(file, list);
        } else if (file.getName().endsWith(".zip")) {
            FileToBufferUtil.zipFileReadIntoList(file, list);
        } else {
            FileToBufferUtil.regularReadIntoList(file, list);
        }
    }

    private static void zipFileReadIntoList(File file, List<String> list) {
        System.out.println("Reading zip file [" + String.valueOf(file) + "]");
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ZipEntry zipEntry = enumeration.nextElement();
            FileToBufferUtil.readInputStream(zipFile.getInputStream(zipEntry), list);
        }
    }

    static void readInputStream(InputStream inputStream, List<String> list) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            list.add(string);
        }
        bufferedReader.close();
    }

    public static void regularReadIntoList(File file, List<String> list) {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string = bufferedReader.readLine()) != null) {
            list.add(string);
        }
        bufferedReader.close();
    }

    public static void gzFileReadIntoList(File file, List<String> list) {
        FileInputStream fileInputStream = new FileInputStream(file);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
        FileToBufferUtil.readInputStream(gZIPInputStream, list);
    }
}

