/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.sound3d.Buffer;
import com.jogamp.openal.sound3d.Context;
import com.jogamp.openal.sound3d.Device;
import com.jogamp.openal.sound3d.Listener;
import com.jogamp.openal.sound3d.Source;
import com.jogamp.openal.util.WAVData;
import com.jogamp.openal.util.WAVLoader;
import java.io.BufferedInputStream;
import java.io.InputStream;
import jogamp.openal.Debug;

public class AudioSystem3D {
    static boolean DEBUG;
    static final AL al;
    static final ALC alc;
    static final ALExt alExt;
    static final boolean staticAvailable;
    static Listener listener;

    @Deprecated
    public static void init() {
    }

    public static boolean isAvailable() {
        return staticAvailable;
    }

    public static final AL getAL() {
        return al;
    }

    public static final ALC getALC() {
        return alc;
    }

    public static final ALExt getALExt() {
        return alExt;
    }

    public static int getALError() {
        return al.alGetError();
    }

    public static boolean checkError(Device device, String string, boolean bl, boolean bl2) {
        if (!AudioSystem3D.checkALCError(device, string, bl, bl2)) {
            return AudioSystem3D.checkALError(string, bl, bl2);
        }
        return false;
    }

    public static boolean checkALError(String string, boolean bl, boolean bl2) {
        int n = al.alGetError();
        if (0 != n) {
            String string2 = string + ": AL error 0x" + Integer.toHexString(n) + ", '" + al.alGetString(n) + "'";
            if (bl) {
                System.err.println(string2);
            }
            if (bl2) {
                throw new ALException(string2);
            }
            return true;
        }
        return false;
    }

    public static boolean checkALCError(Device device, String string, boolean bl, boolean bl2) {
        ALCdevice aLCdevice = null != device ? device.getALDevice() : null;
        int n = alc.alcGetError(aLCdevice);
        if (0 != n) {
            String string2 = string + ": ALC error 0x" + Integer.toHexString(n) + ", '" + alc.alcGetString(aLCdevice, n) + "'";
            if (bl) {
                System.err.println(string2);
            }
            if (bl2) {
                throw new ALException(string2);
            }
            return true;
        }
        return false;
    }

    public static Context createContext(Device device) {
        return new Context(device, null);
    }

    public static Context createContext(Device device, int[] nArray) {
        return new Context(device, nArray);
    }

    public static Context getCurrentContext() {
        return Context.getCurrentContext();
    }

    public static boolean makeContextCurrent(Context context, boolean bl) {
        return context.makeCurrent(bl);
    }

    public static boolean releaseContext(Context context, boolean bl) {
        return context.release(bl);
    }

    public static Device openDevice(String string) {
        return new Device(string);
    }

    public static Buffer[] generateBuffers(int n) {
        Buffer[] bufferArray = new Buffer[n];
        int[] nArray = new int[n];
        al.alGenBuffers(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            bufferArray[i] = new Buffer(nArray[i]);
        }
        return bufferArray;
    }

    public static Buffer loadBuffer(String string) {
        Buffer[] bufferArray = AudioSystem3D.generateBuffers(1);
        Buffer buffer = bufferArray[0];
        WAVData wAVData = WAVLoader.loadFromFile(string);
        buffer.configure(wAVData.data, wAVData.format, wAVData.freq);
        return buffer;
    }

    public static Buffer loadBuffer(InputStream inputStream) {
        Buffer[] bufferArray = AudioSystem3D.generateBuffers(1);
        Buffer buffer = bufferArray[0];
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        WAVData wAVData = WAVLoader.loadFromStream(inputStream);
        buffer.configure(wAVData.data, wAVData.format, wAVData.freq);
        return buffer;
    }

    public static Source loadSource(String string) {
        Buffer buffer = AudioSystem3D.loadBuffer(string);
        return AudioSystem3D.generateSource(buffer);
    }

    public static Source loadSource(InputStream inputStream) {
        Buffer buffer = AudioSystem3D.loadBuffer(inputStream);
        return AudioSystem3D.generateSource(buffer);
    }

    public static Source[] generateSources(int n) {
        Source[] sourceArray = new Source[n];
        int[] nArray = new int[n];
        al.alGenSources(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            sourceArray[i] = new Source(nArray[i]);
        }
        return sourceArray;
    }

    public static Source generateSource(Buffer buffer) {
        Source source = null;
        Source[] sourceArray = AudioSystem3D.generateSources(1);
        source = sourceArray[0];
        source.setBuffer(buffer);
        return source;
    }

    public static Listener getListener() {
        if (listener == null) {
            listener = new Listener();
        }
        return listener;
    }

    static {
        ALExt aLExt;
        AL aL;
        ALC aLC;
        block2: {
            DEBUG = Debug.debug("AudioSystem3D");
            aLC = null;
            aL = null;
            aLExt = null;
            try {
                aLC = ALFactory.getALC();
                aL = ALFactory.getAL();
                aLExt = ALFactory.getALExt();
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                System.err.println("AudioSystem3D: Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        alc = aLC;
        al = aL;
        alExt = aLExt;
        staticAvailable = null != alc && null != al && null != alExt;
    }
}

