/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.presets.javacpp;
import org.bytedeco.javacpp.tools.Logger;

@Properties(inherit={javacpp.class})
public class BooleanPointer
extends Pointer {
    private static final Logger logger;

    public BooleanPointer(boolean ... blArray) {
        this(blArray.length);
        this.put(blArray);
    }

    public BooleanPointer(ByteBuffer byteBuffer) {
        super(byteBuffer);
        if (byteBuffer != null && !byteBuffer.isDirect() && byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.allocateArray(byArray.length - byteBuffer.arrayOffset());
            for (int i = byteBuffer.arrayOffset(); i < byArray.length; ++i) {
                this.put(i - byteBuffer.arrayOffset(), byArray[i] != 0);
            }
            this.position(byteBuffer.position());
            this.limit(byteBuffer.limit());
        }
    }

    public BooleanPointer(long l) {
        try {
            this.allocateArray(l);
            if (l > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", unsatisfiedLinkError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Cannot allocate new BooleanPointer(" + l + "): totalBytes = " + BooleanPointer.formatBytes(BooleanPointer.totalBytes()) + ", physicalBytes = " + BooleanPointer.formatBytes(BooleanPointer.physicalBytes()));
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public BooleanPointer() {
    }

    public BooleanPointer(Pointer pointer) {
        super(pointer);
    }

    private native void allocateArray(long var1);

    public BooleanPointer position(long l) {
        return (BooleanPointer)super.position(l);
    }

    public BooleanPointer limit(long l) {
        return (BooleanPointer)super.limit(l);
    }

    public BooleanPointer capacity(long l) {
        return (BooleanPointer)super.capacity(l);
    }

    @Override
    public int sizeof() {
        return this.getClass() == BooleanPointer.class ? 1 : super.sizeof();
    }

    public BooleanPointer getPointer(long l) {
        return (BooleanPointer)new BooleanPointer(this).offsetAddress(l);
    }

    public boolean get() {
        return this.get(0L);
    }

    public native boolean get(long var1);

    public BooleanPointer put(boolean bl) {
        return this.put(0L, bl);
    }

    public native BooleanPointer put(long var1, boolean var3);

    public BooleanPointer get(boolean[] blArray) {
        return this.get(blArray, 0, blArray.length);
    }

    public BooleanPointer put(boolean ... blArray) {
        return this.put(blArray, 0, blArray.length);
    }

    public native BooleanPointer get(boolean[] var1, int var2, int var3);

    public native BooleanPointer put(boolean[] var1, int var2, int var3);

    static {
        block2: {
            logger = Logger.create(BooleanPointer.class);
            try {
                Loader.load();
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not load BooleanPointer: " + throwable);
            }
        }
    }
}

