/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.tools.Logger;

public class PointerScope
implements AutoCloseable {
    private static final Logger logger = Logger.create(PointerScope.class);
    static final ThreadLocal<Deque<PointerScope>> scopeStack = new ThreadLocal<Deque<PointerScope>>(){

        @Override
        protected Deque initialValue() {
            return new ArrayDeque();
        }
    };
    Deque<Pointer> pointerStack = new ArrayDeque<Pointer>();
    Class<? extends Pointer>[] forClasses = null;
    boolean extend = false;

    public static PointerScope getInnerScope() {
        return scopeStack.get().peek();
    }

    public static Iterator<PointerScope> getScopeIterator() {
        return scopeStack.get().iterator();
    }

    public PointerScope() {
        this(null);
    }

    public PointerScope(Class<? extends Pointer> ... classArray) {
        if (logger.isDebugEnabled()) {
            logger.debug("Opening " + this);
        }
        this.forClasses = classArray;
        scopeStack.get().push(this);
    }

    public Class<? extends Pointer>[] forClasses() {
        return this.forClasses;
    }

    public PointerScope attach(Pointer pointer) {
        if (logger.isDebugEnabled()) {
            logger.debug("Attaching " + pointer + " to " + this);
        }
        if (this.forClasses != null && this.forClasses.length > 0) {
            boolean bl = false;
            for (Class<? extends Pointer> clazz : this.forClasses) {
                if (clazz == null || !clazz.isInstance(pointer)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException(pointer + " is not an instance of a class in forClasses: " + Arrays.toString(this.forClasses));
            }
        }
        this.pointerStack.push(pointer);
        pointer.retainReference();
        return this;
    }

    public PointerScope detach(Pointer pointer) {
        if (logger.isDebugEnabled()) {
            logger.debug("Detaching " + pointer + " from " + this);
        }
        this.pointerStack.remove(pointer);
        pointer.releaseReference();
        return this;
    }

    public PointerScope extend() {
        if (logger.isDebugEnabled()) {
            logger.debug("Extending " + this);
        }
        this.extend = true;
        return this;
    }

    @Override
    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing " + this);
        }
        if (this.extend) {
            this.extend = false;
        } else {
            while (this.pointerStack.size() > 0) {
                this.pointerStack.pop().releaseReference();
            }
        }
        scopeStack.get().remove(this);
    }

    public void deallocate() {
        if (logger.isDebugEnabled()) {
            logger.debug("Deallocating " + this);
        }
        while (this.pointerStack.size() > 0) {
            this.pointerStack.pop().deallocate();
        }
    }
}

