/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.CharBuffer;
import org.bytedeco.javacpp.CharPointer;
import org.bytedeco.javacpp.indexer.CharArrayIndexer;
import org.bytedeco.javacpp.indexer.CharBufferIndexer;
import org.bytedeco.javacpp.indexer.CharRawIndexer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.Raw;

public abstract class CharIndexer
extends Indexer {
    public static final int VALUE_BYTES = 2;

    protected CharIndexer(Index index) {
        super(index);
    }

    protected CharIndexer(long[] lArray, long[] lArray2) {
        super(lArray, lArray2);
    }

    public static CharIndexer create(char[] cArray) {
        return new CharArrayIndexer(cArray);
    }

    public static CharIndexer create(CharBuffer charBuffer) {
        return new CharBufferIndexer(charBuffer);
    }

    public static CharIndexer create(CharPointer charPointer) {
        return new CharRawIndexer(charPointer);
    }

    public static CharIndexer create(char[] cArray, Index index) {
        return new CharArrayIndexer(cArray, index);
    }

    public static CharIndexer create(CharBuffer charBuffer, Index index) {
        return new CharBufferIndexer(charBuffer, index);
    }

    public static CharIndexer create(CharPointer charPointer, Index index) {
        return new CharRawIndexer(charPointer, index);
    }

    public static CharIndexer create(char[] cArray, long ... lArray) {
        return new CharArrayIndexer(cArray, lArray);
    }

    public static CharIndexer create(CharBuffer charBuffer, long ... lArray) {
        return new CharBufferIndexer(charBuffer, lArray);
    }

    public static CharIndexer create(CharPointer charPointer, long ... lArray) {
        return new CharRawIndexer(charPointer, lArray);
    }

    public static CharIndexer create(char[] cArray, long[] lArray, long[] lArray2) {
        return new CharArrayIndexer(cArray, lArray, lArray2);
    }

    public static CharIndexer create(CharBuffer charBuffer, long[] lArray, long[] lArray2) {
        return new CharBufferIndexer(charBuffer, lArray, lArray2);
    }

    public static CharIndexer create(CharPointer charPointer, long[] lArray, long[] lArray2) {
        return new CharRawIndexer(charPointer, lArray, lArray2);
    }

    public static CharIndexer create(CharPointer charPointer, long[] lArray, long[] lArray2, boolean bl) {
        return CharIndexer.create(charPointer, Index.create(lArray, lArray2), bl);
    }

    public static CharIndexer create(final CharPointer charPointer, Index index, boolean bl) {
        if (bl) {
            return Raw.getInstance() != null ? new CharRawIndexer(charPointer, index) : new CharBufferIndexer(charPointer.asBuffer(), index);
        }
        final long l = charPointer.position();
        char[] cArray = new char[(int)Math.min(charPointer.limit() - l, Integer.MAX_VALUE)];
        charPointer.get(cArray);
        return new CharArrayIndexer(cArray, index){

            @Override
            public void release() {
                charPointer.position(l).put(this.array);
                super.release();
            }
        };
    }

    public abstract char get(long var1);

    public CharIndexer get(long l, char[] cArray) {
        return this.get(l, cArray, 0, cArray.length);
    }

    public abstract CharIndexer get(long var1, char[] var3, int var4, int var5);

    public abstract char get(long var1, long var3);

    public CharIndexer get(long l, long l2, char[] cArray) {
        return this.get(l, l2, cArray, 0, cArray.length);
    }

    public abstract CharIndexer get(long var1, long var3, char[] var5, int var6, int var7);

    public abstract char get(long var1, long var3, long var5);

    public abstract char get(long ... var1);

    public CharIndexer get(long[] lArray, char[] cArray) {
        return this.get(lArray, cArray, 0, cArray.length);
    }

    public abstract CharIndexer get(long[] var1, char[] var2, int var3, int var4);

    public abstract CharIndexer put(long var1, char var3);

    public CharIndexer put(long l, char ... cArray) {
        return this.put(l, cArray, 0, cArray.length);
    }

    public abstract CharIndexer put(long var1, char[] var3, int var4, int var5);

    public abstract CharIndexer put(long var1, long var3, char var5);

    public CharIndexer put(long l, long l2, char ... cArray) {
        return this.put(l, l2, cArray, 0, cArray.length);
    }

    public abstract CharIndexer put(long var1, long var3, char[] var5, int var6, int var7);

    public abstract CharIndexer put(long var1, long var3, long var5, char var7);

    public abstract CharIndexer put(long[] var1, char var2);

    public CharIndexer put(long[] lArray, char ... cArray) {
        return this.put(lArray, cArray, 0, cArray.length);
    }

    public abstract CharIndexer put(long[] var1, char[] var2, int var3, int var4);

    @Override
    public double getDouble(long ... lArray) {
        return this.get(lArray);
    }

    @Override
    public CharIndexer putDouble(long[] lArray, double d) {
        return this.put(lArray, (char)d);
    }
}

