/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.StrideIndex;

public abstract class Indexer
implements AutoCloseable {
    @Deprecated
    protected long[] sizes;
    @Deprecated
    protected long[] strides;
    protected final Index index;
    protected Indexable indexable;

    @Override
    public void close() {
        this.release();
    }

    protected Indexer(Index index) {
        this.index = index;
        this.sizes = index.sizes();
        if (index instanceof StrideIndex) {
            this.strides = ((StrideIndex)index).strides();
        }
    }

    protected Indexer(long[] lArray, long[] lArray2) {
        this(Index.create(lArray, lArray2));
    }

    public int rank() {
        return this.index.rank();
    }

    public long[] sizes() {
        return this.index.sizes();
    }

    @Deprecated
    public long[] strides() {
        return this.strides;
    }

    public long size(int n) {
        return this.index.size(n);
    }

    @Deprecated
    public long stride(int n) {
        return this.strides != null ? this.strides[n] : -1L;
    }

    @Deprecated
    public long rows() {
        return this.sizes.length > 0 && this.sizes.length < 4 ? this.sizes[0] : -1L;
    }

    @Deprecated
    public long cols() {
        return this.sizes.length > 1 && this.sizes.length < 4 ? this.sizes[1] : -1L;
    }

    @Deprecated
    public long width() {
        return this.sizes.length > 1 && this.sizes.length < 4 ? this.sizes[1] : -1L;
    }

    @Deprecated
    public long height() {
        return this.sizes.length > 0 && this.sizes.length < 4 ? this.sizes[0] : -1L;
    }

    @Deprecated
    public long channels() {
        return this.sizes.length > 2 && this.sizes.length < 4 ? this.sizes[2] : -1L;
    }

    protected static final long checkIndex(long l, long l2) {
        if (l < 0L || l >= l2) {
            throw new IndexOutOfBoundsException(Long.toString(l));
        }
        return l;
    }

    @Deprecated
    public static long[] strides(long ... lArray) {
        return StrideIndex.defaultStrides(lArray);
    }

    public long index(long l) {
        return this.index.index(l);
    }

    public long index(long l, long l2) {
        return this.index.index(l, l2);
    }

    public long index(long l, long l2, long l3) {
        return this.index.index(l, l2, l3);
    }

    public long index(long ... lArray) {
        return this.index.index(lArray);
    }

    public Indexable indexable() {
        return this.indexable;
    }

    public Indexer indexable(Indexable indexable) {
        this.indexable = indexable;
        return this;
    }

    public Object array() {
        return null;
    }

    public Buffer buffer() {
        return null;
    }

    public Pointer pointer() {
        return null;
    }

    public abstract void release();

    public abstract double getDouble(long ... var1);

    public abstract Indexer putDouble(long[] var1, double var2);

    public abstract <I extends Indexer> I reindex(Index var1);

    public String toString() {
        long l = this.sizes.length > 0 ? this.sizes[0] : 1L;
        long l2 = this.sizes.length > 1 ? this.sizes[1] : 1L;
        long l3 = this.sizes.length > 2 ? this.sizes[2] : 1L;
        StringBuilder stringBuilder = new StringBuilder(l > 1L ? "\n[ " : "[ ");
        int n = 0;
        while ((long)n < l) {
            int n2 = 0;
            while ((long)n2 < l2) {
                if (l3 > 1L) {
                    stringBuilder.append("(");
                }
                int n3 = 0;
                while ((long)n3 < l3) {
                    double d = this.getDouble(n, n2, n3);
                    stringBuilder.append((float)d);
                    if ((long)n3 < l3 - 1L) {
                        stringBuilder.append(", ");
                    }
                    ++n3;
                }
                if (l3 > 1L) {
                    stringBuilder.append(")");
                }
                if ((long)n2 < l2 - 1L) {
                    stringBuilder.append(", ");
                }
                ++n2;
            }
            if ((long)n < l - 1L) {
                stringBuilder.append("\n  ");
            }
            ++n;
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

