/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Index;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.ShortIndexer;

public class ShortRawIndexer
extends ShortIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected ShortPointer pointer;
    final long base;
    final long size;

    public ShortRawIndexer(ShortPointer shortPointer) {
        this(shortPointer, Index.create(shortPointer.limit() - shortPointer.position()));
    }

    public ShortRawIndexer(ShortPointer shortPointer, long ... lArray) {
        this(shortPointer, Index.create(lArray));
    }

    public ShortRawIndexer(ShortPointer shortPointer, long[] lArray, long[] lArray2) {
        this(shortPointer, Index.create(lArray, lArray2));
    }

    public ShortRawIndexer(ShortPointer shortPointer, Index index) {
        super(index);
        this.pointer = shortPointer;
        this.base = shortPointer.address() + shortPointer.position() * 2L;
        this.size = shortPointer.limit() - shortPointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    public ShortIndexer reindex(Index index) {
        return new ShortRawIndexer(this.pointer, index);
    }

    public short getRaw(long l) {
        return RAW.getShort(this.base + ShortRawIndexer.checkIndex(l, this.size) * 2L);
    }

    @Override
    public short get(long l) {
        return this.getRaw(this.index(l));
    }

    @Override
    public ShortIndexer get(long l, short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            sArray[n + i] = this.getRaw(this.index(l) + (long)i);
        }
        return this;
    }

    @Override
    public short get(long l, long l2) {
        return this.getRaw(this.index(l, l2));
    }

    @Override
    public ShortIndexer get(long l, long l2, short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            sArray[n + i] = this.getRaw(this.index(l, l2) + (long)i);
        }
        return this;
    }

    @Override
    public short get(long l, long l2, long l3) {
        return this.getRaw(this.index(l, l2, l3));
    }

    @Override
    public short get(long ... lArray) {
        return this.getRaw(this.index(lArray));
    }

    @Override
    public ShortIndexer get(long[] lArray, short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            sArray[n + i] = this.getRaw(this.index(lArray) + (long)i);
        }
        return this;
    }

    public ShortIndexer putRaw(long l, short s) {
        RAW.putShort(this.base + ShortRawIndexer.checkIndex(l, this.size) * 2L, s);
        return this;
    }

    @Override
    public ShortIndexer put(long l, short s) {
        return this.putRaw(this.index(l), s);
    }

    @Override
    public ShortIndexer put(long l, short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l) + (long)i, sArray[n + i]);
        }
        return this;
    }

    @Override
    public ShortIndexer put(long l, long l2, short s) {
        this.putRaw(this.index(l, l2), s);
        return this;
    }

    @Override
    public ShortIndexer put(long l, long l2, short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(l, l2) + (long)i, sArray[n + i]);
        }
        return this;
    }

    @Override
    public ShortIndexer put(long l, long l2, long l3, short s) {
        this.putRaw(this.index(l, l2, l3), s);
        return this;
    }

    @Override
    public ShortIndexer put(long[] lArray, short s) {
        this.putRaw(this.index(lArray), s);
        return this;
    }

    @Override
    public ShortIndexer put(long[] lArray, short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.putRaw(this.index(lArray) + (long)i, sArray[n + i]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

