/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bytedeco.javacpp.tools.ClassFilter;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.UserClassLoader;

class ClassScanner {
    final Logger logger;
    final Collection<Class> classes;
    final UserClassLoader loader;
    final ClassFilter classFilter;

    ClassScanner(Logger logger, Collection<Class> collection, UserClassLoader userClassLoader) {
        this(logger, collection, userClassLoader, null);
    }

    ClassScanner(Logger logger, Collection<Class> collection, UserClassLoader userClassLoader, ClassFilter classFilter) {
        this.logger = logger;
        this.classes = collection;
        this.loader = userClassLoader;
        this.classFilter = classFilter;
    }

    public Collection<Class> getClasses() {
        return this.classes;
    }

    public UserClassLoader getClassLoader() {
        return this.loader;
    }

    public void addClass(String string) {
        if (string == null) {
            return;
        }
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
        }
        Class<?> clazz = Class.forName(string, false, this.loader);
        this.addClass(clazz);
    }

    public void addClass(Class clazz) {
        if (!this.classes.contains(clazz)) {
            this.classes.add(clazz);
        }
    }

    public void addMatchingFile(String string, String string2, boolean bl, byte ... byArray) {
        if (string != null && string.endsWith(".class") && !string.contains("-") && (this.classFilter == null || this.classFilter.keep(string, byArray)) && (string2 == null || bl && string.startsWith(string2) || string.regionMatches(0, string2, 0, Math.max(string.lastIndexOf(47), string2.lastIndexOf(47))))) {
            this.addClass(string.replace('/', '.'));
        }
    }

    public void addMatchingDir(String string, File file, String string2, boolean bl) {
        Object[] objectArray = file.listFiles();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            String string3;
            String string4 = string3 = string == null ? ((File)object).getName() : string + ((File)object).getName();
            if (((File)object).isDirectory()) {
                this.addMatchingDir(string3 + "/", (File)object, string2, bl);
                continue;
            }
            byte[] byArray = Files.readAllBytes(((File)object).toPath());
            this.addMatchingFile(string3, string2, bl, byArray);
        }
    }

    public void addPackage(String string, boolean bl) {
        String[] stringArray = this.loader.getPaths();
        String string2 = string != null && string.length() > 0 ? string.replace('.', '/') + "/" : string;
        int n = this.classes.size();
        for (String string3 : stringArray) {
            File file = new File(string3);
            if (file.isDirectory()) {
                this.addMatchingDir(null, file, string2, bl);
                continue;
            }
            try (JarFile jarFile = new JarFile(file);){
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string4 = jarEntry.getName();
                    long l = jarEntry.getSize();
                    long l2 = jarEntry.getTime();
                    if (l <= 0L) continue;
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    Throwable throwable = null;
                    try {
                        int n2;
                        byte[] byArray = new byte[(int)l];
                        for (int i = 0; i < byArray.length && (n2 = inputStream.read(byArray, i, byArray.length - i)) >= 0; i += n2) {
                        }
                        this.addMatchingFile(string4, string2, bl, byArray);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
        }
        if (this.classes.size() == 0 && (string == null || string.length() == 0)) {
            this.logger.warn("No classes found in the unnamed package");
        } else if (n == this.classes.size() && string != null) {
            this.logger.warn("No classes found in package " + string);
        }
    }

    public void addClassOrPackage(String string) {
        if (string == null) {
            return;
        }
        if ((string = string.replace('/', '.')).endsWith(".**")) {
            this.addPackage(string.substring(0, string.length() - 3), true);
        } else if (string.endsWith(".*")) {
            this.addPackage(string.substring(0, string.length() - 2), false);
        } else {
            this.addClass(string);
        }
    }
}

