/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.bytedeco.javacpp.tools.Token;

class Tokenizer
implements Closeable {
    File file = null;
    String text = null;
    Reader reader = null;
    String lineSeparator = null;
    int lastChar = -1;
    int lineNumber = 1;
    StringBuilder buffer = new StringBuilder();

    Tokenizer(Reader reader, File file, int n) {
        this.reader = reader;
        this.file = file;
        this.lineNumber = n;
    }

    Tokenizer(String string, File file, int n) {
        this.text = string;
        this.reader = new StringReader(string);
        this.file = file;
        this.lineNumber = n;
    }

    Tokenizer(File file) {
        this(file, null);
    }

    Tokenizer(File file, String string) {
        this.file = file;
        FileInputStream fileInputStream = new FileInputStream(file);
        this.reader = new BufferedReader(string != null ? new InputStreamReader((InputStream)fileInputStream, string) : new InputStreamReader(fileInputStream));
    }

    public void filterLines(String[] stringArray, boolean bl) {
        String string;
        BufferedReader bufferedReader;
        if (stringArray == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader2 = bufferedReader = this.reader instanceof BufferedReader ? (BufferedReader)this.reader : new BufferedReader(this.reader);
        block0: while ((string = bufferedReader.readLine()) != null) {
            int n;
            for (n = 0; n < stringArray.length && !string.matches(stringArray[n]); n += 2) {
            }
            if (n < stringArray.length) {
                if (!bl) {
                    stringBuilder.append(string + "\n");
                }
                while (n + 1 < stringArray.length && (string = bufferedReader.readLine()) != null) {
                    if (!bl) {
                        stringBuilder.append(string + "\n");
                    }
                    if (!string.matches(stringArray[n + 1])) continue;
                    continue block0;
                }
                continue;
            }
            if (!bl) continue;
            stringBuilder.append(string + "\n");
        }
        this.reader.close();
        this.reader = new StringReader(stringBuilder.toString());
    }

    @Override
    public void close() {
        this.reader.close();
    }

    int readChar() {
        if (this.lastChar != -1) {
            int n = this.lastChar;
            this.lastChar = -1;
            return n;
        }
        int n = this.reader.read();
        if (n == 13 || n == 10) {
            int n2;
            if (this.text == null) {
                ++this.lineNumber;
            }
            int n3 = n2 = n == 13 ? this.reader.read() : -1;
            if (this.lineSeparator == null) {
                String string = n == 13 && n2 == 10 ? "\r\n" : (this.lineSeparator = n == 13 ? "\r" : "\n");
            }
            if (n2 != 10) {
                this.lastChar = n2;
            }
            n = 10;
        }
        return n;
    }

    public Token nextToken() {
        Token token = new Token();
        int n = this.readChar();
        this.buffer.setLength(0);
        if (Character.isWhitespace(n)) {
            this.buffer.append((char)n);
            while ((n = this.readChar()) != -1 && Character.isWhitespace(n)) {
                this.buffer.append((char)n);
            }
        }
        token.file = this.file;
        token.text = this.text;
        token.lineNumber = this.lineNumber;
        token.spacing = this.buffer.toString();
        this.buffer.setLength(0);
        if (Character.isLetter(n) || n == 95) {
            token.type = 5;
            this.buffer.append((char)n);
            while ((n = this.readChar()) != -1 && (Character.isDigit(n) || Character.isLetter(n) || n == 95)) {
                this.buffer.append((char)n);
            }
            token.value = this.buffer.toString();
            this.lastChar = n;
        } else if (Character.isDigit(n) || n == 46 || n == 45 || n == 43) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            block78: {
                int n2;
                int n3;
                if (n == 46) {
                    n3 = this.readChar();
                    if (n3 == 46) {
                        n2 = this.readChar();
                        if (n2 == 46) {
                            token.type = 6;
                            token.value = "...";
                            return token;
                        }
                        this.lastChar = n2;
                    } else {
                        this.lastChar = n3;
                    }
                } else if (n == 45) {
                    n3 = this.readChar();
                    if (n3 == 62) {
                        token.type = 6;
                        token.value = "->";
                        return token;
                    }
                    this.lastChar = n3;
                }
                token.type = n == 46 ? 2 : 1;
                this.buffer.append((char)n);
                n3 = 0;
                n2 = 0;
                bl4 = false;
                bl3 = false;
                bl2 = false;
                bl = false;
                while ((n = this.readChar()) != -1 && (Character.isDigit(n) || n == 46 || n == 45 || n == 43 || n >= 97 && n <= 102 || n == 105 || n == 108 || n == 117 || n == 120 || n >= 65 && n <= 70 || n == 73 || n == 76 || n == 85 || n == 88)) {
                    switch (n) {
                        case 46: {
                            token.type = 2;
                            break;
                        }
                        case 69: 
                        case 101: {
                            n2 = 1;
                            break;
                        }
                        case 76: 
                        case 108: {
                            bl4 = true;
                            break;
                        }
                        case 85: 
                        case 117: {
                            bl3 = true;
                            break;
                        }
                        case 88: 
                        case 120: {
                            bl2 = true;
                        }
                    }
                    if (n != 108 && n != 76 && n != 117 && n != 85) {
                        this.buffer.append((char)n);
                    }
                    n3 = n;
                }
                if (!(bl2 || n2 == 0 && n3 != 102 && n3 != 70)) {
                    token.type = 2;
                }
                if (token.type == 1 && !bl4) {
                    try {
                        long l = Long.decode(this.buffer.toString()) >> 16;
                        bl = l == 0L || l == -1L;
                        bl4 = (l >>= 16) != 0L && l != -1L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.buffer.length() < 16) break block78;
                        bl4 = true;
                    }
                }
            }
            if (this.buffer.toString().endsWith("i64")) {
                this.buffer.setLength(this.buffer.length() - 3);
                bl4 = true;
            }
            if (token.type == 1 && (bl4 || bl3 && !bl2 && !bl)) {
                this.buffer.append('L');
            }
            token.value = this.buffer.toString();
            this.lastChar = n;
        } else if (n == 39) {
            token.type = 1;
            n = this.readChar();
            boolean bl = true;
            if (n == 92) {
                n = this.readChar();
                if (n == 120) {
                    bl = false;
                    this.buffer.append('0');
                } else {
                    this.buffer.append('\'');
                    this.buffer.append('\\');
                }
            } else {
                this.buffer.append('\'');
            }
            this.buffer.append((char)n);
            while ((n = this.readChar()) != -1 && n != 39) {
                this.buffer.append((char)n);
                if (n != 92) continue;
                n = this.readChar();
                this.buffer.append((char)n);
            }
            if (bl) {
                this.buffer.append('\'');
            }
            token.value = this.buffer.toString();
        } else if (n == 34) {
            token.type = 3;
            this.buffer.append('\"');
            while ((n = this.readChar()) != -1 && n != 34) {
                this.buffer.append((char)n);
                if (n != 92) continue;
                n = this.readChar();
                this.buffer.append((char)n);
            }
            this.buffer.append('\"');
            token.value = this.buffer.toString();
        } else if (n == 47) {
            n = this.readChar();
            if (n == 47) {
                token.type = 4;
                this.buffer.append('/').append('/');
                int n4 = 0;
                while ((n = this.readChar()) != -1 && (n4 == 92 || n != 10)) {
                    this.buffer.append((char)n);
                    n4 = n;
                }
                token.value = this.buffer.toString();
                this.lastChar = n;
            } else if (n == 42) {
                token.type = 4;
                this.buffer.append('/').append('*');
                int n5 = 0;
                while ((n = this.readChar()) != -1 && (n5 != 42 || n != 47)) {
                    this.buffer.append((char)n);
                    n5 = n;
                }
                this.buffer.append('/');
                token.value = this.buffer.toString();
            } else {
                this.lastChar = n;
                token.type = 47;
            }
        } else if (n == 58) {
            int n6 = this.readChar();
            if (n6 == 58) {
                token.type = 6;
                token.value = "::";
            } else {
                token.type = n;
                this.lastChar = n6;
            }
        } else if (n == 38) {
            int n7 = this.readChar();
            if (n7 == 38) {
                token.type = 6;
                token.value = "&&";
            } else {
                token.type = n;
                this.lastChar = n7;
            }
        } else if (n == 35) {
            int n8 = this.readChar();
            if (n8 == 35) {
                token.type = 6;
                token.value = "##";
            } else {
                token.type = n;
                this.lastChar = n8;
            }
        } else if (n == 91) {
            int n9 = this.readChar();
            if (n9 == 91) {
                token.type = 6;
                token.value = "[[";
            } else {
                token.type = n;
                this.lastChar = n9;
            }
        } else if (n == 93) {
            int n10 = this.readChar();
            if (n10 == 93) {
                token.type = 6;
                token.value = "]]";
            } else {
                token.type = n;
                this.lastChar = n10;
            }
        } else if (n == 60) {
            int n11 = this.readChar();
            if (n11 == 61) {
                token.type = 6;
                token.value = "<=";
            } else {
                token.type = n;
                this.lastChar = n11;
            }
        } else if (n == 62) {
            int n12 = this.readChar();
            if (n12 == 61) {
                token.type = 6;
                token.value = ">=";
            } else {
                token.type = n;
                this.lastChar = n12;
            }
        } else {
            if (n == 92) {
                int n13 = this.readChar();
                if (n13 == 10) {
                    token.type = 4;
                    token.value = "\n";
                    return token;
                }
                this.lastChar = n13;
            }
            token.type = n;
        }
        return token;
    }

    Token[] tokenize() {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        try {
            Token token;
            while (!(token = this.nextToken()).isEmpty()) {
                arrayList.add(token);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }
}

