/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessibleKt;
import androidx.compose.ui.platform.a11y.ProgressBarAccessibleValue;
import androidx.compose.ui.platform.a11y.RadioButtonAccessibleValue;
import androidx.compose.ui.platform.a11y.ToggleableAccessibleValue;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Density_skikoKt;
import androidx.compose.ui.window.Geometry_desktopKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.accessibility.AccessibleValue;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skiko.HardwareLayerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002:\u0001!B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\t\u0010\u0013\u001a\u00020\u0014X\u0082\u0004R\u001f\u0010\u0015\u001a\u00060\u0016R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/Accessible;", "Ljava/awt/Component;", "semanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "controller", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "<init>", "(Landroidx/compose/ui/semantics/SemanticsNode;Landroidx/compose/ui/platform/a11y/AccessibilityController;)V", "value", "getSemanticsNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "setSemanticsNode", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "cachedSemanticsConfig", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "semanticsConfig", "getSemanticsConfig", "()Landroidx/compose/ui/semantics/SemanticsConfiguration;", "isNativelyInitialized", "Lkotlinx/atomicfu/AtomicBoolean;", "composeAccessibleContext", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "getComposeAccessibleContext", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "composeAccessibleContext$delegate", "Lkotlin/Lazy;", "disposed", "", "dispose", "", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "ComposeAccessibleComponent", "ui"})
public final class ComposeAccessible
extends Component
implements Accessible {
    private final AccessibilityController controller;
    private SemanticsNode semanticsNode;
    private SemanticsConfiguration cachedSemanticsConfig;
    private volatile /* synthetic */ int isNativelyInitialized$volatile;
    private final Lazy composeAccessibleContext$delegate;
    private boolean disposed;
    private static final /* synthetic */ AtomicIntegerFieldUpdater isNativelyInitialized$volatile$FU;
    public static final int $stable;

    public ComposeAccessible(SemanticsNode semanticsNode, AccessibilityController accessibilityController) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        Intrinsics.checkNotNullParameter((Object)accessibilityController, (String)"");
        this.controller = accessibilityController;
        this.semanticsNode = semanticsNode;
        this.composeAccessibleContext$delegate = LazyKt.lazy(() -> ComposeAccessible.composeAccessibleContext_delegate$lambda$0(this));
    }

    public final SemanticsNode getSemanticsNode() {
        return this.semanticsNode;
    }

    public final void setSemanticsNode(SemanticsNode semanticsNode) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        this.semanticsNode = semanticsNode;
        this.cachedSemanticsConfig = null;
    }

    private final SemanticsConfiguration getSemanticsConfig() {
        SemanticsConfiguration semanticsConfiguration = this.cachedSemanticsConfig;
        if (semanticsConfiguration == null) {
            SemanticsConfiguration semanticsConfiguration2;
            SemanticsConfiguration semanticsConfiguration3 = semanticsConfiguration2 = this.semanticsNode.getConfig();
            boolean bl = false;
            this.cachedSemanticsConfig = semanticsConfiguration3;
            semanticsConfiguration = semanticsConfiguration2;
        }
        return semanticsConfiguration;
    }

    private final /* synthetic */ int isNativelyInitialized$volatile() {
        return this.isNativelyInitialized$volatile;
    }

    private final /* synthetic */ void setNativelyInitialized$volatile(int n2) {
        this.isNativelyInitialized$volatile = n2;
    }

    public final ComposeAccessibleComponent getComposeAccessibleContext() {
        Lazy lazy = this.composeAccessibleContext$delegate;
        return (ComposeAccessibleComponent)lazy.getValue();
    }

    public final void dispose() {
        this.disposed = true;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.disposed) {
            return null;
        }
        if (ComposeAccessible.isNativelyInitialized$volatile$FU.compareAndSet(this, 0, 1)) {
            HardwareLayerKt.nativeInitializeAccessible((Accessible)this);
        }
        return this.getComposeAccessibleContext();
    }

    private static final ComposeAccessibleComponent composeAccessibleContext_delegate$lambda$0(ComposeAccessible composeAccessible) {
        return composeAccessible.new ComposeAccessibleComponent();
    }

    static {
        isNativelyInitialized$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(ComposeAccessible.class, "isNativelyInitialized$volatile");
        $stable = 8;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0006\u00a9\u0001\u00aa\u0001\u00ab\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010E\u001a\u00020<2\u0006\u0010F\u001a\u00020\u000eH\u0002J\u0013\u0010G\u001a\u00020H*\u00020IH\u0002\u00a2\u0006\u0004\bJ\u0010KJ\u0013\u0010L\u001a\u00020\u0013*\u00020MH\u0002\u00a2\u0006\u0004\bN\u0010OJ\f\u0010P\u001a\u00020Q*\u00020RH\u0002J\u0013\u0010S\u001a\u00020I*\u00020HH\u0002\u00a2\u0006\u0004\bT\u0010UJ\u0013\u0010V\u001a\u00020W*\u00020XH\u0002\u00a2\u0006\u0004\bY\u0010ZJ\n\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\n\u0010]\u001a\u0004\u0018\u00010\\H\u0016J\n\u0010^\u001a\u0004\u0018\u00010<H\u0016J\n\u0010_\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010a\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010b\u001a\u0004\u0018\u00010cH\u0016J\b\u0010d\u001a\u00020\u0013H\u0016J\b\u0010e\u001a\u00020\u0013H\u0016J\u0012\u0010f\u001a\u0004\u0018\u00010<2\u0006\u0010g\u001a\u00020\u0013H\u0016J\b\u0010h\u001a\u00020iH\u0016J\b\u0010j\u001a\u00020IH\u0016J\b\u0010k\u001a\u00020IH\u0016J\b\u0010l\u001a\u00020QH\u0016J\b\u0010m\u001a\u00020WH\u0016J\b\u0010n\u001a\u00020\u000eH\u0016J\b\u0010o\u001a\u00020\u000eH\u0016J\b\u0010p\u001a\u00020\u000eH\u0016J\u0011\u0010q\u001a\u00020\u000e2\u0006\u0010r\u001a\u00020IH\u0096\u0002J\u0012\u0010s\u001a\u0004\u0018\u00010<2\u0006\u0010r\u001a\u00020IH\u0016J\b\u0010t\u001a\u00020\u000eH\u0016J\b\u0010u\u001a\u00020vH\u0016J\u0012\u0010w\u001a\u00020v2\b\u0010x\u001a\u0004\u0018\u00010yH\u0016J\u0012\u0010z\u001a\u00020v2\b\u0010x\u001a\u0004\u0018\u00010yH\u0016J\b\u0010{\u001a\u00020|H\u0016J\b\u0010}\u001a\u00020~H\u0016J\f\u0010\u007f\u001a\u00020v*\u00020~H\u0002J\r\u0010\u0080\u0001\u001a\u00020v*\u00020~H\u0002J\r\u0010\u0081\u0001\u001a\u00020v*\u00020~H\u0002J\f\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0089\u0001H\u0016J\f\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0016J\u0014\u0010\u008c\u0001\u001a\u00020v2\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010QH\u0016J\u0014\u0010\u008e\u0001\u001a\u00020v2\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010WH\u0016J\u0013\u0010\u0090\u0001\u001a\u00020v2\b\u0010r\u001a\u0004\u0018\u00010IH\u0016J\n\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0016J\u0015\u0010\u0093\u0001\u001a\u00020v2\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0092\u0001H\u0016J\n\u0010\u0095\u0001\u001a\u00030\u0092\u0001H\u0016J\u0015\u0010\u0096\u0001\u001a\u00020v2\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0092\u0001H\u0016J\n\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0016J\u0015\u0010\u0099\u0001\u001a\u00020v2\n\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u0098\u0001H\u0016J\n\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0016J\u0015\u0010\u009d\u0001\u001a\u00020v2\n\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009c\u0001H\u0016J\u0016\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\n\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009c\u0001H\u0016J\u0012\u0010\u00a1\u0001\u001a\u00020v2\u0007\u0010\u00a2\u0001\u001a\u00020\u000eH\u0016J\u0012\u0010\u00a3\u0001\u001a\u00020v2\u0007\u0010\u00a2\u0001\u001a\u00020\u000eH\u0016J\t\u0010\u00a4\u0001\u001a\u00020\u0013H\u0016J\u0012\u0010\u00a5\u0001\u001a\u00020\\2\u0007\u0010\u00a6\u0001\u001a\u00020\u0013H\u0016J\u0012\u0010\u00a7\u0001\u001a\u00020\u000e2\u0007\u0010\u00a6\u0001\u001a\u00020\u0013H\u0016J\u0013\u0010\u00a8\u0001\u001a\u00020\\*\b\u0012\u0004\u0012\u00020\u00160;H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR%\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R1\u0010\u0011\u001a\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0013\u0010*\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)RI\u0010,\u001a:\u00124\u00122\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u000e0-\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0010R\u0011\u00104\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0013\u00106\u001a\u0004\u0018\u0001078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0013\u0010?\u001a\u0004\u0018\u00010@8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0013\u0010C\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u001fR\u0013\u0010D\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001fR\u0010\u0010`\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0082\u0001\u001a\u000e\u0018\u00010\u0083\u0001R\u00070\u0000R\u00030\u0084\u00018BX\u0082\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u0087\u0001\u0010\u0088\u0001\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\u00a8\u0006\u00ac\u0001"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/AccessibleComponent;", "Ljavax/accessibility/AccessibleAction;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible;)V", "textSelectionRange", "Landroidx/compose/ui/text/TextRange;", "getTextSelectionRange-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "setText", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function1;", "Landroidx/compose/ui/text/AnnotatedString;", "", "getSetText", "()Landroidx/compose/ui/semantics/AccessibilityAction;", "setSelection", "Lkotlin/Function3;", "", "getSetSelection", "text", "", "getText", "()Ljava/lang/CharSequence;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "getTextLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "focused", "getFocused", "()Ljava/lang/Boolean;", "selected", "getSelected", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "horizontalScroll", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "getHorizontalScroll", "()Landroidx/compose/ui/semantics/ScrollAxisRange;", "verticalScroll", "getVerticalScroll", "scrollBy", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "getScrollBy", "isPassword", "()Z", "toggleableState", "Landroidx/compose/ui/state/ToggleableState;", "getToggleableState", "()Landroidx/compose/ui/state/ToggleableState;", "auxiliaryChildren", "", "Ljavax/accessibility/Accessible;", "getAuxiliaryChildren", "()Ljava/util/List;", "progressBarRangeInfo", "Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "getProgressBarRangeInfo", "()Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "isContainer", "isTraversalGroup", "makeScrollbarChild", "vertical", "toComposeOffset", "Landroidx/compose/ui/geometry/Offset;", "Ljava/awt/Point;", "toComposeOffset-tuRUvjQ", "(Ljava/awt/Point;)J", "toAwtPx", "Landroidx/compose/ui/unit/Dp;", "toAwtPx-0680j_4", "(F)I", "toAwtRectangle", "Ljava/awt/Rectangle;", "Landroidx/compose/ui/geometry/Rect;", "toAwtPoint", "toAwtPoint-k-4lQ0M", "(J)Ljava/awt/Point;", "toAwtDimension", "Ljava/awt/Dimension;", "Landroidx/compose/ui/unit/IntSize;", "toAwtDimension-ozmzZPI", "(J)Ljava/awt/Dimension;", "getAccessibleName", "", "getAccessibleDescription", "getAccessibleParent", "getAccessibleComponent", "accessibleAction", "getAccessibleAction", "getAccessibleValue", "Ljavax/accessibility/AccessibleValue;", "getAccessibleIndexInParent", "getAccessibleChildrenCount", "getAccessibleChild", "index", "getLocale", "Ljava/util/Locale;", "getLocationOnScreen", "getLocation", "getBounds", "getSize", "isVisible", "isEnabled", "isShowing", "contains", "p", "getAccessibleAt", "isFocusTraversable", "requestFocus", "", "addFocusListener", "l", "Ljava/awt/event/FocusListener;", "removeFocusListener", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "addCheckedStateForCheckboxOrSwitch", "addCheckedStateForRadioButton", "addDefaultStateForToggleableState", "accessibleText", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "getAccessibleText", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "accessibleText$delegate", "Lkotlin/Lazy;", "Ljavax/accessibility/AccessibleText;", "getAccessibleEditableText", "Ljavax/accessibility/AccessibleEditableText;", "setBounds", "r", "setSize", "d", "setLocation", "getBackground", "Ljava/awt/Color;", "setBackground", "c", "getForeground", "setForeground", "getCursor", "Ljava/awt/Cursor;", "setCursor", "cursor", "getFont", "Ljava/awt/Font;", "setFont", "f", "getFontMetrics", "Ljava/awt/FontMetrics;", "setEnabled", "b", "setVisible", "getAccessibleActionCount", "getAccessibleActionDescription", "i", "doAccessibleAction", "mergeText", "ComposeAccessibleText", "ScrollBarAccessible", "ComposeAccessibleEditableText", "ui"})
    public class ComposeAccessibleComponent
    extends AccessibleContext
    implements AccessibleAction,
    AccessibleComponent {
        private AccessibleAction accessibleAction;
        private final Lazy accessibleText$delegate = LazyKt.lazy(() -> ComposeAccessibleComponent.accessibleText_delegate$lambda$0(this));

        public final TextRange getTextSelectionRange-MzsxiRA() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getTextSelectionRange());
        }

        public final AccessibilityAction<Function1<AnnotatedString, Boolean>> getSetText() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetText());
        }

        public final AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> getSetSelection() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetSelection());
        }

        public final CharSequence getText() {
            CharSequence charSequence;
            AnnotatedString annotatedString = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getEditableText());
            if (annotatedString != null) {
                charSequence = (CharSequence)annotatedString;
            } else {
                List<AnnotatedString> list = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getText());
                charSequence = list != null ? this.mergeText(list) : null;
            }
            return charSequence;
        }

        public final TextLayoutResult getTextLayoutResult() {
            Function1<List<TextLayoutResult>, Boolean> function1;
            List list = new ArrayList();
            AccessibilityAction<Function1<List<TextLayoutResult>, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getGetTextLayoutResult());
            Boolean bl = accessibilityAction != null && (function1 = accessibilityAction.getAction()) != null ? (Boolean)function1.invoke((Object)list) : null;
            return Intrinsics.areEqual(bl, (Object)true) ? (TextLayoutResult)list.get(0) : null;
        }

        public final Boolean getFocused() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getFocused());
        }

        public final Boolean getSelected() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getSelected());
        }

        private final Density getDensity() {
            return ComposeAccessible.this.controller.getDesktopComponent().getDensity();
        }

        public final ScrollAxisRange getHorizontalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        }

        public final ScrollAxisRange getVerticalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        }

        public final AccessibilityAction<Function2<Float, Float, Boolean>> getScrollBy() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getScrollBy());
        }

        public final boolean isPassword() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getPassword()) != null;
        }

        public final ToggleableState getToggleableState() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getToggleableState());
        }

        public final List<Accessible> getAuxiliaryChildren() {
            List list;
            block1: {
                boolean bl;
                ScrollAxisRange scrollAxisRange;
                List list2 = list = CollectionsKt.createListBuilder();
                boolean bl2 = false;
                ScrollAxisRange scrollAxisRange2 = this.getHorizontalScroll();
                if (scrollAxisRange2 != null) {
                    scrollAxisRange = scrollAxisRange2;
                    bl = false;
                    list2.add(this.makeScrollbarChild(false));
                }
                ScrollAxisRange scrollAxisRange3 = this.getVerticalScroll();
                if (scrollAxisRange3 == null) break block1;
                scrollAxisRange = scrollAxisRange3;
                bl = false;
                list2.add(this.makeScrollbarChild(true));
            }
            return CollectionsKt.build((List)list);
        }

        public final ProgressBarRangeInfo getProgressBarRangeInfo() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getProgressBarRangeInfo());
        }

        public final Boolean isContainer() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsContainer());
        }

        public final Boolean isTraversalGroup() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsTraversalGroup());
        }

        private final Accessible makeScrollbarChild(boolean bl) {
            ScrollBarAccessible scrollBarAccessible = new ScrollBarAccessible(bl);
            AccessibleRelation accessibleRelation = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, scrollBarAccessible);
            AccessibleRelation accessibleRelation2 = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, ComposeAccessible.this);
            scrollBarAccessible.getContext().getAccessibleRelationSet().add(accessibleRelation2);
            this.getAccessibleRelationSet().add(accessibleRelation);
            return scrollBarAccessible;
        }

        private final long toComposeOffset-tuRUvjQ(Point point) {
            return Density_skikoKt.toOffset-gVKV90s(Geometry_desktopKt.asDpOffset(point), this.getDensity());
        }

        private final int toAwtPx-0680j_4(float f2) {
            return Float.isInfinite(f2) ? Integer.MAX_VALUE : MathKt.roundToInt((float)f2);
        }

        private final Rectangle toAwtRectangle(Rect rect) {
            Density density = this.getDensity();
            boolean bl = false;
            Rect rect2 = rect;
            boolean bl2 = false;
            int n2 = this.toAwtPx-0680j_4(density.toDp-u2uoSUM(rect2.getRight() - rect2.getLeft()));
            rect2 = rect;
            bl2 = false;
            return new Rectangle(this.toAwtPx-0680j_4(density.toDp-u2uoSUM(rect.getLeft())), this.toAwtPx-0680j_4(density.toDp-u2uoSUM(rect.getTop())), n2, this.toAwtPx-0680j_4(density.toDp-u2uoSUM(rect2.getBottom() - rect2.getTop())));
        }

        private final Point toAwtPoint-k-4lQ0M(long l2) {
            Density density = this.getDensity();
            boolean bl = false;
            long l3 = l2;
            boolean bl2 = false;
            long l4 = l3;
            boolean bl3 = false;
            int n2 = (int)(l4 >> 32);
            boolean bl4 = false;
            int n3 = this.toAwtPx-0680j_4(density.toDp-u2uoSUM(Float.intBitsToFloat(n2)));
            l3 = l2;
            bl2 = false;
            l4 = l3;
            bl3 = false;
            n2 = (int)(l4 & 0xFFFFFFFFL);
            bl4 = false;
            return new Point(n3, this.toAwtPx-0680j_4(density.toDp-u2uoSUM(Float.intBitsToFloat(n2))));
        }

        private final Dimension toAwtDimension-ozmzZPI(long l2) {
            Density density = this.getDensity();
            boolean bl = false;
            long l3 = l2;
            boolean bl2 = false;
            long l4 = l3;
            boolean bl3 = false;
            int n2 = this.toAwtPx-0680j_4(density.toDp-u2uoSUM((int)(l4 >> 32)));
            l3 = l2;
            bl2 = false;
            l4 = l3;
            bl3 = false;
            return new Dimension(n2, this.toAwtPx-0680j_4(density.toDp-u2uoSUM((int)(l4 & 0xFFFFFFFFL))));
        }

        @Override
        public String getAccessibleName() {
            CharSequence charSequence = this.getText();
            return charSequence != null ? ((Object)charSequence).toString() : null;
        }

        @Override
        public String getAccessibleDescription() {
            List<String> list = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getContentDescription());
            return list != null ? this.mergeText(list) : null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Accessible getAccessibleParent() {
            Accessible accessible;
            Object object = ComposeAccessible.this.getSemanticsNode().getParent();
            if (object != null) {
                int n2 = ((SemanticsNode)object).getId();
                ComposeAccessible composeAccessible = ComposeAccessible.this;
                int n3 = n2;
                boolean bl = false;
                ComposeAccessible composeAccessible2 = composeAccessible.controller.accessibleByNodeId(n3);
                Intrinsics.checkNotNull((Object)composeAccessible2);
                object = composeAccessible2;
                if (composeAccessible2 != null) {
                    accessible = (Accessible)object;
                    return accessible;
                }
            }
            accessible = this.accessibleParent;
            return accessible;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            List list = new ArrayList();
            AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getOnClick());
            if (accessibilityAction != null) {
                AccessibilityAction<Function0<Boolean>> accessibilityAction2 = accessibilityAction;
                boolean bl = false;
                list.add(new Pair((Object)"click", SemanticsActions.INSTANCE.getOnClick()));
            }
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, list, SemanticsActions.INSTANCE.getOnLongClick());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, list, SemanticsActions.INSTANCE.getExpand());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, list, SemanticsActions.INSTANCE.getCollapse());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, list, SemanticsActions.INSTANCE.getDismiss());
            if (list.isEmpty()) {
                return null;
            }
            this.accessibleAction = new AccessibleAction(list, ComposeAccessible.this){
                final /* synthetic */ List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> $actions;
                final /* synthetic */ ComposeAccessible this$0;
                {
                    this.$actions = list;
                    this.this$0 = composeAccessible;
                }

                public int getAccessibleActionCount() {
                    return this.$actions.size();
                }

                public String getAccessibleActionDescription(int n2) {
                    String string = (String)this.$actions.get(n2).component1();
                    return string;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean doAccessibleAction(int n2) {
                    SemanticsPropertyKey semanticsPropertyKey = (SemanticsPropertyKey)this.$actions.get(n2).component2();
                    AccessibilityAction accessibilityAction = (AccessibilityAction)SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), semanticsPropertyKey);
                    Object object = accessibilityAction;
                    if (accessibilityAction == null) return false;
                    AccessibilityAction accessibilityAction2 = object;
                    boolean bl = false;
                    Function0 function0 = (Function0)accessibilityAction2.getAction();
                    if (function0 == null) return false;
                    Boolean bl2 = (Boolean)function0.invoke();
                    object = bl2;
                    if (bl2 == null) return false;
                    boolean bl3 = (Boolean)object;
                    return bl3;
                }
            };
            return this.accessibleAction;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            AccessibleValue accessibleValue;
            Role role = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            if (this.getToggleableState() != null) {
                accessibleValue = new ToggleableAccessibleValue(this);
            } else {
                int n2 = Role.Companion.getRadioButton-o7Vup1c();
                Role role2 = role;
                accessibleValue = (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n2)) ? (AccessibleValue)new RadioButtonAccessibleValue(this) : (this.getProgressBarRangeInfo() != null ? (AccessibleValue)new ProgressBarAccessibleValue(this) : null);
            }
            return accessibleValue;
        }

        @Override
        public int getAccessibleIndexInParent() {
            int n2;
            block4: {
                List list;
                SemanticsNode semanticsNode = ComposeAccessible.this.getSemanticsNode().getParent();
                List list2 = list = semanticsNode != null ? ComposeAccessibleKt.access$traversalOrderedChildren(semanticsNode) : null;
                if (list2 != null) {
                    List list3 = list2;
                    ComposeAccessible composeAccessible = ComposeAccessible.this;
                    boolean bl = false;
                    int n3 = 0;
                    for (Object e2 : list3) {
                        SemanticsNode semanticsNode2 = (SemanticsNode)e2;
                        boolean bl2 = false;
                        if (semanticsNode2.getId() == composeAccessible.getSemanticsNode().getId()) {
                            n2 = n3;
                            break block4;
                        }
                        ++n3;
                    }
                    n2 = -1;
                } else {
                    n2 = -1;
                }
            }
            return n2;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return ComposeAccessible.this.getSemanticsNode().getReplacedChildren$ui().size() + this.getAuxiliaryChildren().size();
        }

        @Override
        public Accessible getAccessibleChild(int n2) {
            List list = ComposeAccessibleKt.access$traversalOrderedChildren(ComposeAccessible.this.getSemanticsNode());
            int n3 = list.size();
            return n2 < n3 ? (Accessible)ComposeAccessible.this.controller.accessibleByNodeId(((SemanticsNode)list.get(n2)).getId()) : this.getAuxiliaryChildren().get(n2 - n3);
        }

        @Override
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
            return locale;
        }

        @Override
        public Point getLocationOnScreen() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionOnScreen-F1C5BW0());
        }

        @Override
        public Point getLocation() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionInRoot-F1C5BW0());
        }

        @Override
        public Rectangle getBounds() {
            return this.toAwtRectangle(ComposeAccessible.this.getSemanticsNode().getBoundsInRoot());
        }

        @Override
        public Dimension getSize() {
            return this.toAwtDimension-ozmzZPI(ComposeAccessible.this.getSemanticsNode().getSize-YbymL2g());
        }

        @Override
        public boolean isVisible() {
            boolean bl = false;
            return !DelegatableNodeKt.requireCoordinator-64DMado(ComposeAccessible.this.getSemanticsNode().getOuterSemanticsNode$ui(), NodeKind.constructor-impl(8)).isTransparent();
        }

        @Override
        public boolean isEnabled() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean contains(Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"");
            return this.getBounds().contains(point);
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Intrinsics.checkNotNullParameter((Object)point, (String)"");
            List list = ComposeAccessibleKt.access$traversalOrderedChildren(ComposeAccessible.this.getSemanticsNode());
            for (SemanticsNode object5 : list) {
                object4 = ComposeAccessible.this.controller.accessibleByNodeId(object5.getId());
                Accessible accessible = object4 instanceof Accessible ? (Accessible)object4 : null;
                if (accessible == null) continue;
                object3 = accessible;
                object2 = object3.getAccessibleContext();
                AccessibleComponent accessibleComponent = object2 instanceof AccessibleComponent ? (AccessibleComponent)object2 : null;
                if (accessibleComponent == null || (object4 = (object = accessibleComponent).getAccessibleAt(point)) == null) continue;
                Object object6 = object4;
                boolean bl = false;
                return object6;
            }
            for (Accessible accessible : this.getAuxiliaryChildren()) {
                object4 = accessible.getAccessibleContext();
                AccessibleComponent accessibleComponent = object4 instanceof AccessibleComponent ? (AccessibleComponent)object4 : null;
                if (accessibleComponent == null || (object = (object3 = accessibleComponent).getAccessibleAt(point)) == null) continue;
                object2 = object;
                boolean bl = false;
                return object2;
            }
            if (this.contains(point)) {
                return ComposeAccessible.this;
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return this.getFocused() != null;
        }

        @Override
        public void requestFocus() {
            Function0<Boolean> function0;
            AccessibilityAction<Function0<Boolean>> accessibilityAction;
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)false) && (accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsNode().getUnmergedConfig$ui(), SemanticsActions.INSTANCE.getRequestFocus())) != null && (function0 = accessibilityAction.getAction()) != null) {
                Boolean cfr_ignored_0 = (Boolean)function0.invoke();
            }
        }

        @Override
        public void addFocusListener(FocusListener focusListener2) {
            System.out.println((Object)"Not implemented: addFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void removeFocusListener(FocusListener focusListener2) {
            System.out.println((Object)"Not implemented: removeFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public AccessibleRole getAccessibleRole() {
            block22: {
                block21: {
                    AccessibilityController.AccessibilityUsage.INSTANCE.notifyInUse();
                    var2_1 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(ComposeAccessible.this), SemanticsProperties.INSTANCE.getRole());
                    var3_2 = Role.Companion.getButton-o7Vup1c();
                    v0 = var2_1;
                    if (!(v0 == null ? false : Role.equals-impl0(v0.unbox-impl(), var3_2))) break block21;
                    v1 = AccessibleRole.PUSH_BUTTON;
                    break block22;
                }
                var3_2 = Role.Companion.getCheckbox-o7Vup1c();
                v2 = var2_1;
                if (v2 == null ? false : Role.equals-impl0(v2.unbox-impl(), var3_2)) ** GOTO lbl-1000
                var3_2 = Role.Companion.getSwitch-o7Vup1c();
                v3 = var2_1;
                if (v3 == null ? false : Role.equals-impl0(v3.unbox-impl(), var3_2)) lbl-1000:
                // 2 sources

                {
                    v1 = AccessibleRole.CHECK_BOX;
                } else {
                    var3_2 = Role.Companion.getRadioButton-o7Vup1c();
                    v4 = var2_1;
                    if (v4 == null ? false : Role.equals-impl0(v4.unbox-impl(), var3_2)) {
                        v1 = AccessibleRole.RADIO_BUTTON;
                    } else {
                        var3_2 = Role.Companion.getTab-o7Vup1c();
                        v5 = var2_1;
                        if (v5 == null ? false : Role.equals-impl0(v5.unbox-impl(), var3_2)) {
                            v1 = AccessibleRole.PAGE_TAB;
                        } else {
                            var3_2 = Role.Companion.getDropdownList-o7Vup1c();
                            v6 = var2_1;
                            v1 = (v6 == null ? false : Role.equals-impl0(v6.unbox-impl(), var3_2)) != false ? AccessibleRole.COMBO_BOX : null;
                        }
                    }
                }
            }
            var1_3 = v1;
            v7 = var1_3;
            if (v7 == null) {
                if (this.isPassword()) {
                    v8 = AccessibleRole.PASSWORD_TEXT;
                    v7 = v8;
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"");
                } else if (this.getSetText() != null) {
                    v9 = AccessibleRole.TEXT;
                    v7 = v9;
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"");
                } else if (this.getScrollBy() != null) {
                    v10 = AccessibleRole.SCROLL_PANE;
                    v7 = v10;
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"");
                } else if (this.getText() != null) {
                    v11 = AccessibleRole.LABEL;
                    v7 = v11;
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"");
                } else if (this.getProgressBarRangeInfo() != null) {
                    var2_1 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(ComposeAccessible.this), SemanticsActions.INSTANCE.getSetProgress()) != null ? AccessibleRole.SLIDER : AccessibleRole.PROGRESS_BAR;
                    Intrinsics.checkNotNull((Object)var2_1);
                    v7 = var2_1;
                } else if (this.isContainer() != null) {
                    v12 = AccessibleRole.GROUP_BOX;
                    v7 = v12;
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"");
                } else if (this.isTraversalGroup() != null) {
                    v13 = AccessibleRole.GROUP_BOX;
                    v7 = v13;
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"");
                } else {
                    v14 = AccessibleRole.UNKNOWN;
                    v7 = v14;
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"");
                }
            }
            return v7;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            var1_1 = new AccessibleStateSet();
            var2_2 = ComposeAccessible.this;
            var3_3 = var1_1;
            var4_4 = false;
            if (this.isEnabled()) {
                var3_3.add(AccessibleState.ENABLED);
            }
            if (Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(var2_2), SemanticsProperties.INSTANCE.getIsEditable()), (Object)true)) {
                var3_3.add(AccessibleState.EDITABLE);
            }
            if (this.isShowing()) {
                var3_3.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                var3_3.add(AccessibleState.VISIBLE);
            }
            if (this.isFocusTraversable()) {
                var3_3.add(AccessibleState.FOCUSABLE);
            }
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)true)) {
                var3_3.add(AccessibleState.FOCUSED);
            }
            var5_5 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(var2_2), SemanticsActions.INSTANCE.getExpand()) != null;
            v0 = var6_6 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(var2_2), SemanticsActions.INSTANCE.getCollapse()) != null;
            if (var5_5 || var6_6) {
                var3_3.add(AccessibleState.EXPANDABLE);
            }
            if (var5_5) {
                var3_3.add(AccessibleState.COLLAPSED);
            }
            if (var6_6) {
                var3_3.add(AccessibleState.EXPANDED);
            }
            var7_7 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(var2_2), SemanticsProperties.INSTANCE.getRole());
            var8_8 = Role.Companion.getCheckbox-o7Vup1c();
            v1 = var7_7;
            if (v1 == null ? false : Role.equals-impl0(v1.unbox-impl(), var8_8)) ** GOTO lbl-1000
            var8_8 = Role.Companion.getSwitch-o7Vup1c();
            v2 = var7_7;
            if (v2 == null ? false : Role.equals-impl0(v2.unbox-impl(), var8_8)) lbl-1000:
            // 2 sources

            {
                this.addCheckedStateForCheckboxOrSwitch(var3_3);
            } else {
                var8_8 = Role.Companion.getRadioButton-o7Vup1c();
                v3 = var7_7;
                if (v3 == null ? false : Role.equals-impl0(v3.unbox-impl(), var8_8)) {
                    this.addCheckedStateForRadioButton(var3_3);
                } else {
                    this.addDefaultStateForToggleableState(var3_3);
                    if (this.getSelected() != null) {
                        var3_3.add(AccessibleState.SELECTABLE);
                    }
                    if (Intrinsics.areEqual((Object)this.getSelected(), (Object)true)) {
                        var3_3.add(AccessibleState.SELECTED);
                    }
                }
            }
            var8_9 = this.getAccessibleRole();
            var9_10 = false;
            v4 = Intrinsics.areEqual((Object)var8_9, (Object)AccessibleRole.SLIDER) || Intrinsics.areEqual((Object)var8_9, (Object)AccessibleRole.PROGRESS_BAR);
            if (v4) {
                var3_3.add(AccessibleState.HORIZONTAL);
            }
            return var1_1;
        }

        private final void addCheckedStateForCheckboxOrSwitch(AccessibleStateSet accessibleStateSet) {
            this.addDefaultStateForToggleableState(accessibleStateSet);
        }

        private final void addCheckedStateForRadioButton(AccessibleStateSet accessibleStateSet) {
            if (Intrinsics.areEqual((Object)this.getSelected(), (Object)true)) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
        }

        private final void addDefaultStateForToggleableState(AccessibleStateSet accessibleStateSet) {
            AccessibleState accessibleState;
            ToggleableState toggleableState = this.getToggleableState();
            switch (toggleableState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) {
                case 1: {
                    accessibleState = AccessibleState.CHECKED;
                    break;
                }
                case 2: {
                    accessibleState = AccessibleState.INDETERMINATE;
                    break;
                }
                case -1: 
                case 3: {
                    accessibleState = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            AccessibleState accessibleState2 = accessibleState;
            if (accessibleState2 != null) {
                accessibleStateSet.add(accessibleState2);
            }
        }

        @Override
        private final ComposeAccessibleText getAccessibleText() {
            Lazy lazy = this.accessibleText$delegate;
            return (ComposeAccessibleText)lazy.getValue();
        }

        @Override
        public AccessibleText getAccessibleText() {
            return this.getAccessibleText();
        }

        @Override
        public AccessibleEditableText getAccessibleEditableText() {
            ComposeAccessibleText composeAccessibleText = this.getAccessibleText();
            return composeAccessibleText instanceof AccessibleEditableText ? (AccessibleEditableText)((Object)composeAccessibleText) : null;
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            System.out.println((Object)"Not implemented: setBounds");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setSize(Dimension dimension) {
            System.out.println((Object)"Not implemented: setSize");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setLocation(Point point) {
            System.out.println((Object)"Not implemented: setLocation");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Color getBackground() {
            System.out.println((Object)"Not implemented: getBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setBackground(Color color) {
            System.out.println((Object)"Not implemented: setBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Color getForeground() {
            System.out.println((Object)"Not implemented: getForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setForeground(Color color) {
            System.out.println((Object)"Not implemented: setForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Cursor getCursor() {
            System.out.println((Object)"Not implemented: getCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setCursor(Cursor cursor) {
            System.out.println((Object)"Not implemented: setCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Font getFont() {
            System.out.println((Object)"Not implemented: getFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setFont(Font font) {
            System.out.println((Object)"Not implemented: setFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            System.out.println((Object)"Not implemented: getFontMetrics");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setEnabled(boolean bl) {
            System.out.println((Object)"Not implemented: setEnabled");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setVisible(boolean bl) {
            System.out.println((Object)"Not implemented: setVisible");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.getAccessibleActionCount() : 0;
        }

        @Override
        public String getAccessibleActionDescription(int n2) {
            Object object = this.accessibleAction;
            if (object == null || (object = object.getAccessibleActionDescription(n2)) == null) {
                object = "";
            }
            return object;
        }

        @Override
        public boolean doAccessibleAction(int n2) {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.doAccessibleAction(n2) : false;
        }

        private final String mergeText(List<? extends CharSequence> list) {
            return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }

        private static final void getAccessibleAction$addActionIfExist(ComposeAccessible composeAccessible, List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> list, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> semanticsPropertyKey) {
            block0: {
                AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), semanticsPropertyKey);
                if (accessibilityAction == null) break block0;
                AccessibilityAction<Function0<Boolean>> accessibilityAction2 = accessibilityAction;
                boolean bl = false;
                list.add((Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>)new Pair((Object)accessibilityAction2.getLabel(), semanticsPropertyKey));
            }
        }

        private static final ComposeAccessibleText accessibleText_delegate$lambda$0(ComposeAccessibleComponent composeAccessibleComponent) {
            return composeAccessibleComponent.getSetText() != null ? (ComposeAccessibleText)composeAccessibleComponent.new ComposeAccessibleEditableText() : (composeAccessibleComponent.getText() != null ? composeAccessibleComponent.new ComposeAccessibleText() : null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\"\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/AccessibleEditableText;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "setTextContents", "", "s", "", "insertTextAtIndex", "index", "", "getTextRange", "startIndex", "endIndex", "delete", "cut", "paste", "replaceText", "selectText", "setAttributes", "as", "Ljavax/swing/text/AttributeSet;", "ui"})
        public final class ComposeAccessibleEditableText
        extends ComposeAccessibleText
        implements AccessibleEditableText {
            @Override
            public void setTextContents(String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)new AnnotatedString(string, null, 2, null));
            }

            @Override
            public void insertTextAtIndex(int n2, String string) {
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                CharSequence charSequence2 = charSequence;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean bl = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl2 = false;
                builder2.append(charSequence2.subSequence(0, n2));
                builder2.append(string);
                builder2.append(charSequence2.subSequence(n2, charSequence2.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public String getTextRange(int n2, int n3) {
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence(n2, n3)).toString();
            }

            @Override
            public void delete(int n2, int n3) {
                AnnotatedString.Builder builder;
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                CharSequence charSequence2 = charSequence;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean bl = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl2 = false;
                builder2.append(charSequence2.subSequence(0, n2));
                builder2.append(charSequence2.subSequence(n3, charSequence2.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public void cut(int n2, int n3) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public void paste(int n2) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public void replaceText(int n2, int n3, String string) {
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                CharSequence charSequence2 = charSequence;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean bl = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl2 = false;
                builder2.append(charSequence2.subSequence(0, n2));
                builder2.append(string);
                builder2.append(charSequence2.subSequence(n3, charSequence2.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public void selectText(int n2, int n3) {
                AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetSelection();
                Intrinsics.checkNotNull(accessibilityAction);
                Function3<Integer, Integer, Boolean, Boolean> function3 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function3);
                function3.invoke((Object)n2, (Object)n3, (Object)false);
            }

            @Override
            public void setAttributes(int n2, int n3, AttributeSet attributeSet) {
                System.out.println((Object)"Not implemented: setAttributes");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016\u00a8\u0006#"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Ljavax/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleExtendedText;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "getIndexAtPoint", "", "p", "Ljava/awt/Point;", "getCharacterBounds", "Ljava/awt/Rectangle;", "i", "getCharCount", "getCaretPosition", "partToBreakIterator", "Lorg/jetbrains/skia/BreakIterator;", "part", "getAtIndex", "", "index", "getAfterIndex", "getBeforeIndex", "getCharacterAttribute", "Ljavax/swing/text/AttributeSet;", "getSelectionStart", "getSelectionEnd", "getSelectedText", "getTextRange", "startIndex", "endIndex", "getTextSequenceAt", "Ljavax/accessibility/AccessibleTextSequence;", "getTextSequenceAfter", "getTextSequenceBefore", "getTextBounds", "ui"})
        public class ComposeAccessibleText
        implements AccessibleExtendedText,
        AccessibleText {
            @Override
            public int getIndexAtPoint(Point point) {
                Intrinsics.checkNotNullParameter((Object)point, (String)"");
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return textLayoutResult.getOffsetForPosition-k-4lQ0M(ComposeAccessibleComponent.this.toComposeOffset-tuRUvjQ(point));
            }

            @Override
            public Rectangle getCharacterBounds(int n2) {
                block3: {
                    block2: {
                        if (n2 < 0) break block2;
                        CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                        Intrinsics.checkNotNull((Object)charSequence);
                        if (n2 < charSequence.length()) break block3;
                    }
                    return new Rectangle((int)((float)ComposeAccessibleComponent.this.getLocation().x / ComposeAccessibleComponent.this.getDensity().getDensity()), (int)((float)ComposeAccessibleComponent.this.getLocation().y / ComposeAccessibleComponent.this.getDensity().getDensity()), 0, 0);
                }
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return ComposeAccessibleComponent.this.toAwtRectangle(textLayoutResult.getBoundingBox(n2));
            }

            @Override
            public int getCharCount() {
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return charSequence.length();
            }

            @Override
            public int getCaretPosition() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getStart-impl((long)textRange.unbox-impl()) : -1;
            }

            private final BreakIterator partToBreakIterator(int n2) {
                BreakIterator breakIterator;
                switch (n2) {
                    case 3: {
                        breakIterator = BreakIterator.Companion.makeSentenceInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 2: {
                        breakIterator = BreakIterator.Companion.makeWordInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 1: {
                        breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                BreakIterator breakIterator2 = breakIterator;
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                breakIterator2.setText(((Object)charSequence).toString());
                return breakIterator2;
            }

            @Override
            public String getAtIndex(int n2, int n3) {
                String string;
                int n4 = this.partToBreakIterator(n2).following(n3);
                if (n4 == -1) {
                    string = "";
                } else {
                    CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)charSequence);
                    string = ((Object)charSequence.subSequence(n3, n4)).toString();
                }
                return string;
            }

            @Override
            public String getAfterIndex(int n2, int n3) {
                BreakIterator breakIterator = this.partToBreakIterator(n2);
                int n4 = n3;
                while (true) {
                    if ((n4 = breakIterator.following(n4)) == -1) {
                        return "";
                    }
                    CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)charSequence);
                    if (charSequence.charAt(n4) == ' ') continue;
                    CharSequence charSequence2 = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)charSequence2);
                    if (charSequence2.charAt(n4) != '\n') break;
                }
                int n5 = breakIterator.next();
                int n6 = n5 == -1 ? breakIterator.last() : n5;
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence(n4, n6)).toString();
            }

            @Override
            public String getBeforeIndex(int n2, int n3) {
                String string;
                int n4 = this.partToBreakIterator(n2).preceding(n3);
                if (n4 == -1) {
                    string = "";
                } else {
                    CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)charSequence);
                    string = ((Object)charSequence.subSequence(n4, n3)).toString();
                }
                return string;
            }

            @Override
            public AttributeSet getCharacterAttribute(int n2) {
                System.out.println((Object)"Not implemented: getCharacterAttribute");
                return new SimpleAttributeSet();
            }

            @Override
            public int getSelectionStart() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getMin-impl((long)textRange.unbox-impl()) : 0;
            }

            @Override
            public int getSelectionEnd() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getMax-impl((long)textRange.unbox-impl()) : 0;
            }

            @Override
            public String getSelectedText() {
                String string;
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                if (textRange == null) {
                    return null;
                }
                long l2 = textRange.unbox-impl();
                int n2 = TextRange.getMin-impl((long)l2);
                int n3 = TextRange.getMax-impl((long)l2);
                if (n2 == n3) {
                    string = null;
                } else {
                    CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)charSequence);
                    string = ((Object)charSequence.subSequence(n2, n3)).toString();
                }
                return string;
            }

            @Override
            public String getTextRange(int n2, int n3) {
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence(n2, n3)).toString();
            }

            @Override
            public AccessibleTextSequence getTextSequenceAt(int n2, int n3) {
                System.out.println((Object)"Not implemented: getBeforeIndex");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceAfter(int n2, int n3) {
                System.out.println((Object)"Not implemented: getTextSequenceAfter");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceBefore(int n2, int n3) {
                System.out.println((Object)"Not implemented: getTextSequenceBefore");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public Rectangle getTextBounds(int n2, int n3) {
                System.out.println((Object)"Not implemented: getTextBounds");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ScrollBarAccessible;", "Ljavax/accessibility/Accessible;", "vertical", "", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;Z)V", "getVertical", "()Z", "context", "Ljavax/accessibility/AccessibleContext;", "getContext", "()Ljavax/accessibility/AccessibleContext;", "getAccessibleContext", "ui"})
        public final class ScrollBarAccessible
        implements Accessible {
            private final boolean vertical;
            private final AccessibleContext context;

            public ScrollBarAccessible(boolean bl) {
                this.vertical = bl;
                this.context = (AccessibleContext)((Object)new AccessibleValue(this, ComposeAccessibleComponent.this, ComposeAccessible.this){
                    private final ScrollAxisRange range;
                    final /* synthetic */ ScrollBarAccessible this$0;
                    final /* synthetic */ ComposeAccessibleComponent this$1;
                    final /* synthetic */ ComposeAccessible this$2;
                    {
                        ScrollAxisRange scrollAxisRange;
                        this.this$0 = scrollBarAccessible;
                        this.this$1 = composeAccessibleComponent;
                        this.this$2 = composeAccessible;
                        if (scrollBarAccessible.getVertical()) {
                            ScrollAxisRange scrollAxisRange2 = composeAccessibleComponent.getVerticalScroll();
                            scrollAxisRange = scrollAxisRange2;
                            Intrinsics.checkNotNull((Object)scrollAxisRange2);
                        } else {
                            ScrollAxisRange scrollAxisRange3 = composeAccessibleComponent.getHorizontalScroll();
                            scrollAxisRange = scrollAxisRange3;
                            Intrinsics.checkNotNull((Object)scrollAxisRange3);
                        }
                        this.range = scrollAxisRange;
                    }

                    public AccessibleValue getAccessibleValue() {
                        return this;
                    }

                    public AccessibleRole getAccessibleRole() {
                        AccessibleRole accessibleRole = AccessibleRole.SCROLL_BAR;
                        Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"");
                        return accessibleRole;
                    }

                    public AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                        ScrollBarAccessible scrollBarAccessible = this.this$0;
                        AccessibleStateSet accessibleStateSet2 = accessibleStateSet;
                        boolean bl = false;
                        accessibleStateSet2.add(AccessibleState.ENABLED);
                        boolean bl2 = scrollBarAccessible.getVertical() ? accessibleStateSet2.add(AccessibleState.VERTICAL) : accessibleStateSet2.add(AccessibleState.HORIZONTAL);
                        return accessibleStateSet;
                    }

                    public Accessible getAccessibleParent() {
                        return this.this$2;
                    }

                    public int getAccessibleIndexInParent() {
                        return this.this$1.getAuxiliaryChildren().indexOf(this.this$0);
                    }

                    public int getAccessibleChildrenCount() {
                        return 0;
                    }

                    public Accessible getAccessibleChild(int n2) {
                        return null;
                    }

                    public Locale getLocale() {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                        return locale;
                    }

                    public Number getCurrentAccessibleValue() {
                        return (Number)this.range.getValue().invoke();
                    }

                    public boolean setCurrentAccessibleValue(Number number) {
                        boolean bl;
                        if (this.this$0.getVertical()) {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Float f2 = Float.valueOf(0.0f);
                            Number number2 = number;
                            Intrinsics.checkNotNull((Object)number2);
                            bl = (Boolean)function2.invoke((Object)f2, (Object)Float.valueOf(number2.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()));
                        } else {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Number number3 = number;
                            Intrinsics.checkNotNull((Object)number3);
                            bl = (Boolean)function2.invoke((Object)Float.valueOf(number3.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()), (Object)Float.valueOf(0.0f));
                        }
                        return bl;
                    }

                    public Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    public Number getMaximumAccessibleValue() {
                        return (Number)this.range.getMaxValue().invoke();
                    }
                });
            }

            public final boolean getVertical() {
                return this.vertical;
            }

            public final AccessibleContext getContext() {
                return this.context;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this.context;
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ToggleableState.values().length];
                try {
                    nArray[ToggleableState.On.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Indeterminate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Off.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

