/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.modules.SerializersModuleCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JQ\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102/\u0010\u0011\u001a+\u0012\u001d\u0012\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0012H\u0016JF\u0010\u0018\u001a\u00020\f\"\b\b\u0000\u0010\u0019*\u00020\u000e\"\b\b\u0001\u0010\u001a*\u0002H\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0014H\u0016J\u001c\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010!\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002JK\u0010\"\u001a\u00020\f\"\b\b\u0000\u0010\u0019*\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00102)\u0010#\u001a%\u0012\u0013\u0012\u0011H\u0019\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b($\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0019\u0018\u00010%0\u0012H\u0016JM\u0010&\u001a\u00020\f\"\b\b\u0000\u0010\u0019*\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00102+\u0010'\u001a'\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b((\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0019\u0018\u00010)0\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lkotlinx/serialization/json/internal/JsonSerializersModuleValidator;", "Lkotlinx/serialization/modules/SerializersModuleCollector;", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "<init>", "(Lkotlinx/serialization/json/JsonConfiguration;)V", "discriminator", "", "useArrayPolymorphism", "", "isDiscriminatorRequired", "contextual", "", "T", "", "kClass", "Lkotlin/reflect/KClass;", "provider", "Lkotlin/Function1;", "", "Lkotlinx/serialization/KSerializer;", "Lkotlin/ParameterName;", "name", "typeArgumentsSerializers", "polymorphic", "Base", "Sub", "baseClass", "actualClass", "actualSerializer", "checkKind", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "checkDiscriminatorCollisions", "polymorphicDefaultSerializer", "defaultSerializerProvider", "value", "Lkotlinx/serialization/SerializationStrategy;", "polymorphicDefaultDeserializer", "defaultDeserializerProvider", "className", "Lkotlinx/serialization/DeserializationStrategy;", "kotlinx-serialization-json"})
public final class JsonSerializersModuleValidator
implements SerializersModuleCollector {
    private final String discriminator;
    private final boolean useArrayPolymorphism;
    private final boolean isDiscriminatorRequired;

    public JsonSerializersModuleValidator(JsonConfiguration jsonConfiguration) {
        Intrinsics.checkNotNullParameter((Object)jsonConfiguration, (String)"");
        this.discriminator = jsonConfiguration.getClassDiscriminator();
        this.useArrayPolymorphism = jsonConfiguration.getUseArrayPolymorphism();
        this.isDiscriminatorRequired = jsonConfiguration.getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
    }

    public <T> void contextual(KClass<T> kClass, Function1<? super List<? extends KSerializer<?>>, ? extends KSerializer<?>> function1) {
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
    }

    public <Base, Sub extends Base> void polymorphic(KClass<Base> kClass, KClass<Sub> kClass2, KSerializer<Sub> kSerializer) {
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        Intrinsics.checkNotNullParameter(kClass2, (String)"");
        Intrinsics.checkNotNullParameter(kSerializer, (String)"");
        SerialDescriptor serialDescriptor = kSerializer.getDescriptor();
        this.checkKind(serialDescriptor, kClass2);
        if (!this.useArrayPolymorphism && this.isDiscriminatorRequired) {
            this.checkDiscriminatorCollisions(serialDescriptor, kClass2);
        }
    }

    private final void checkKind(SerialDescriptor serialDescriptor, KClass<?> kClass) {
        SerialKind serialKind = serialDescriptor.getKind();
        if (serialKind instanceof PolymorphicKind || Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.CONTEXTUAL.INSTANCE)) {
            throw new IllegalArgumentException("Serializer for " + kClass.getSimpleName() + " can't be registered as a subclass for polymorphic serialization because its kind " + serialKind + " is not concrete. To work with multiple hierarchies, register it as a base class.");
        }
        if (this.useArrayPolymorphism) {
            return;
        }
        if (!this.isDiscriminatorRequired) {
            return;
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) || serialKind instanceof PrimitiveKind || serialKind instanceof SerialKind.ENUM) {
            throw new IllegalArgumentException("Serializer for " + kClass.getSimpleName() + " of kind " + serialKind + " cannot be serialized polymorphically with class discriminator.");
        }
    }

    private final void checkDiscriminatorCollisions(SerialDescriptor serialDescriptor, KClass<?> kClass) {
        int n = serialDescriptor.getElementsCount();
        for (int i = 0; i < n; ++i) {
            String string = serialDescriptor.getElementName(i);
            if (!Intrinsics.areEqual((Object)string, (Object)this.discriminator)) continue;
            throw new IllegalArgumentException("Polymorphic serializer for " + kClass + " has property '" + string + "' that conflicts with JSON class discriminator. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism");
        }
    }

    public <Base> void polymorphicDefaultSerializer(KClass<Base> kClass, Function1<? super Base, ? extends SerializationStrategy<? super Base>> function1) {
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
    }

    public <Base> void polymorphicDefaultDeserializer(KClass<Base> kClass, Function1<? super String, ? extends DeserializationStrategy<? extends Base>> function1) {
        Intrinsics.checkNotNullParameter(kClass, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
    }

    public <T> void contextual(KClass<T> kClass, KSerializer<T> kSerializer) {
        super.contextual(kClass, kSerializer);
    }

    @Deprecated(message="Deprecated in favor of function with more precise name: polymorphicDefaultDeserializer", replaceWith=@ReplaceWith(expression="polymorphicDefaultDeserializer(baseClass, defaultDeserializerProvider)", imports={}), level=DeprecationLevel.WARNING)
    public <Base> void polymorphicDefault(KClass<Base> kClass, Function1<? super String, ? extends DeserializationStrategy<? extends Base>> function1) {
        super.polymorphicDefault(kClass, function1);
    }
}

