/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.ChunkedDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonElementMarker;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.JsonTreeReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u000e\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001UB1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010 \u001a\u00020!H\u0016J!\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020(2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010+\u001a\u00020*2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020\u0013H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020*H\u0002J;\u00100\u001a\u0002H#\"\u0004\b\u0000\u0010#2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\b\u00102\u001a\u0004\u0018\u0001H#H\u0016\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u00105\u001a\u00020\u001bH\u0002J\u0018\u00106\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u001bH\u0002J\u0010\u00107\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u00108\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u0015H\u0002J\b\u0010:\u001a\u00020\u001bH\u0002J\b\u0010;\u001a\u00020\u0013H\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\u001bH\u0016J\b\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020HH\u0016J\b\u0010I\u001a\u00020\u0015H\u0002J\b\u0010J\u001a\u00020\u0015H\u0016J+\u0010K\u001a\u00020*2!\u0010L\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\bN\u0012\b\bO\u0012\u0004\b\b(P\u0012\u0004\u0012\u00020*0MH\u0016J\u0010\u0010Q\u001a\u00020R2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010S\u001a\u00020\u001b2\u0006\u0010T\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/encoding/ChunkedDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "lexer", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "discriminatorHolder", "Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/AbstractJsonLexer;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;)V", "getJson", "()Lkotlinx/serialization/json/Json;", "trySkip", "", "unknownKey", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "currentIndex", "", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "elementMarker", "Lkotlinx/serialization/json/internal/JsonElementMarker;", "decodeJsonElement", "Lkotlinx/serialization/json/JsonElement;", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "", "skipLeftoverElements", "decodeNotNullMark", "decodeNull", "", "checkLeadingComma", "decodeSerializableElement", "index", "previousValue", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeElementIndex", "decodeMapIndex", "coerceInputValue", "decodeObjectIndex", "handleUnknown", "key", "decodeListIndex", "decodeBoolean", "decodeByte", "", "decodeShort", "", "decodeInt", "decodeLong", "", "decodeFloat", "", "decodeDouble", "", "decodeChar", "", "decodeStringKey", "decodeString", "decodeStringChunked", "consumeChunk", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "chunk", "decodeInline", "Lkotlinx/serialization/encoding/Decoder;", "decodeEnum", "enumDescriptor", "DiscriminatorHolder", "kotlinx-serialization-json"})
public class StreamingJsonDecoder
extends AbstractDecoder
implements ChunkedDecoder,
JsonDecoder {
    private final Json json;
    private final WriteMode mode;
    public final AbstractJsonLexer lexer;
    private final SerializersModule serializersModule;
    private int currentIndex;
    private DiscriminatorHolder discriminatorHolder;
    private final JsonConfiguration configuration;
    private final JsonElementMarker elementMarker;

    public StreamingJsonDecoder(Json json, WriteMode writeMode, AbstractJsonLexer abstractJsonLexer, SerialDescriptor serialDescriptor, DiscriminatorHolder discriminatorHolder) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)writeMode), (String)"");
        Intrinsics.checkNotNullParameter((Object)abstractJsonLexer, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        this.json = json;
        this.mode = writeMode;
        this.lexer = abstractJsonLexer;
        this.serializersModule = this.json.getSerializersModule();
        this.currentIndex = -1;
        this.discriminatorHolder = discriminatorHolder;
        this.configuration = this.json.getConfiguration();
        this.elementMarker = this.configuration.getExplicitNulls() ? null : new JsonElementMarker(serialDescriptor);
    }

    @Override
    public final Json getJson() {
        return this.json;
    }

    private final boolean trySkip(DiscriminatorHolder discriminatorHolder, String string) {
        if (discriminatorHolder == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)discriminatorHolder.discriminatorToSkip, (Object)string)) {
            discriminatorHolder.discriminatorToSkip = null;
            return true;
        }
        return false;
    }

    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public JsonElement decodeJsonElement() {
        return new JsonTreeReader(this.json.getConfiguration(), this.lexer).read();
    }

    public <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializationStrategy) {
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        try {
            DeserializationStrategy deserializationStrategy2;
            if (!(deserializationStrategy instanceof AbstractPolymorphicSerializer) || this.json.getConfiguration().getUseArrayPolymorphism()) {
                return (T)deserializationStrategy.deserialize((Decoder)this);
            }
            String string = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)deserializationStrategy).getDescriptor(), this.json);
            String string2 = this.lexer.peekLeadingMatchingValue(string, this.configuration.isLenient());
            if (string2 == null) {
                Object object;
                JsonDecoder jsonDecoder = this;
                DeserializationStrategy<? extends T> deserializationStrategy3 = deserializationStrategy;
                boolean bl = false;
                if (!(deserializationStrategy3 instanceof AbstractPolymorphicSerializer) || jsonDecoder.getJson().getConfiguration().getUseArrayPolymorphism()) {
                    object = deserializationStrategy3.deserialize((Decoder)jsonDecoder);
                } else {
                    DeserializationStrategy deserializationStrategy4;
                    String string3 = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)deserializationStrategy3).getDescriptor(), jsonDecoder.getJson());
                    JsonElement jsonElement = jsonDecoder.decodeJsonElement();
                    String string4 = ((AbstractPolymorphicSerializer)deserializationStrategy3).getDescriptor().getSerialName();
                    boolean bl2 = false;
                    if (!(jsonElement instanceof JsonObject)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(jsonElement.getClass()).getSimpleName()).append(" as the serialized body of ").append(string4).append(" at element: ");
                        int n = -1;
                        boolean bl3 = false;
                        String string5 = this.lexer.path.getPath();
                        throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string5).toString(), jsonElement.toString());
                    }
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    JsonElement jsonElement2 = (JsonElement)jsonObject.get((Object)string3);
                    jsonElement = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
                    try {
                        deserializationStrategy4 = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)((AbstractPolymorphicSerializer)deserializationStrategy3), (CompositeDecoder)jsonDecoder, (String)((Object)jsonElement));
                    }
                    catch (SerializationException serializationException) {
                        String string6 = serializationException.getMessage();
                        Intrinsics.checkNotNull((Object)string6);
                        throw JsonExceptionsKt.JsonDecodingException(-1, string6, jsonObject.toString());
                    }
                    DeserializationStrategy deserializationStrategy5 = deserializationStrategy4;
                    Intrinsics.checkNotNull((Object)deserializationStrategy5);
                    string4 = deserializationStrategy5;
                    object = TreeJsonDecoderKt.readPolymorphicJson(jsonDecoder.getJson(), string3, jsonObject, string4);
                }
                return (T)object;
            }
            String string7 = string2;
            try {
                deserializationStrategy2 = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)((AbstractPolymorphicSerializer)deserializationStrategy), (CompositeDecoder)this, (String)string7);
            }
            catch (SerializationException serializationException) {
                String string8 = serializationException.getMessage();
                Intrinsics.checkNotNull((Object)string8);
                String string9 = StringsKt.removeSuffix((String)StringsKt.substringBefore$default((String)string8, (char)'\n', null, (int)2, null), (CharSequence)".");
                String string10 = serializationException.getMessage();
                Intrinsics.checkNotNull((Object)string10);
                String string11 = StringsKt.substringAfter((String)string10, (char)'\n', (String)"");
                AbstractJsonLexer.fail$default(this.lexer, string9, 0, string11, 2, null);
                throw new KotlinNothingValueException();
            }
            DeserializationStrategy deserializationStrategy6 = deserializationStrategy2;
            Intrinsics.checkNotNull((Object)deserializationStrategy6);
            DeserializationStrategy deserializationStrategy7 = deserializationStrategy6;
            this.discriminatorHolder = new DiscriminatorHolder(string);
            return (T)deserializationStrategy7.deserialize((Decoder)this);
        }
        catch (MissingFieldException missingFieldException) {
            String string = missingFieldException.getMessage();
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"at path", (boolean)false, (int)2, null)) {
                throw missingFieldException;
            }
            throw new MissingFieldException(missingFieldException.getMissingFields(), missingFieldException.getMessage() + " at path: " + this.lexer.path.getPath(), (Throwable)missingFieldException);
        }
    }

    public CompositeDecoder beginStructure(SerialDescriptor serialDescriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        WriteMode writeMode = WriteModeKt.switchMode(this.json, serialDescriptor);
        this.lexer.path.pushDescriptor(serialDescriptor);
        this.lexer.consumeNextToken(writeMode.begin);
        this.checkLeadingComma();
        switch (WhenMappings.$EnumSwitchMapping$0[writeMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonDecoder(this.json, writeMode, this.lexer, serialDescriptor, this.discriminatorHolder);
                break;
            }
            default: {
                compositeDecoder = this.mode == writeMode && this.json.getConfiguration().getExplicitNulls() ? this : new StreamingJsonDecoder(this.json, writeMode, this.lexer, serialDescriptor, this.discriminatorHolder);
            }
        }
        return compositeDecoder;
    }

    public void endStructure(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        if (serialDescriptor.getElementsCount() == 0 && JsonNamesMapKt.ignoreUnknownKeys(serialDescriptor, this.json)) {
            this.skipLeftoverElements(serialDescriptor);
        }
        if (this.lexer.tryConsumeComma() && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma(this.lexer, "");
            throw new KotlinNothingValueException();
        }
        this.lexer.consumeNextToken(this.mode.end);
        this.lexer.path.popDescriptor();
    }

    private final void skipLeftoverElements(SerialDescriptor serialDescriptor) {
        while (this.decodeElementIndex(serialDescriptor) != -1) {
        }
    }

    public boolean decodeNotNullMark() {
        JsonElementMarker jsonElementMarker = this.elementMarker;
        return !(jsonElementMarker != null ? jsonElementMarker.isUnmarkedNull$kotlinx_serialization_json() : false) && !AbstractJsonLexer.tryConsumeNull$default(this.lexer, false, 1, null);
    }

    public Void decodeNull() {
        return null;
    }

    private final void checkLeadingComma() {
        if (this.lexer.peekNextToken() == 4) {
            AbstractJsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    public <T> T decodeSerializableElement(SerialDescriptor serialDescriptor, int n, DeserializationStrategy<? extends T> deserializationStrategy, T t) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        boolean bl2 = bl = this.mode == WriteMode.MAP && (n & 1) == 0;
        if (bl) {
            this.lexer.path.resetCurrentMapKey();
        }
        Object object = super.decodeSerializableElement(serialDescriptor, n, deserializationStrategy, t);
        if (bl) {
            this.lexer.path.updateCurrentMapKey(object);
        }
        return (T)object;
    }

    public int decodeElementIndex(SerialDescriptor serialDescriptor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 4: {
                int n2 = this.decodeObjectIndex(serialDescriptor);
                break;
            }
            case 2: {
                int n2 = this.decodeMapIndex();
                break;
            }
            default: {
                int n2 = n = this.decodeListIndex();
            }
        }
        if (this.mode != WriteMode.MAP) {
            this.lexer.path.updateDescriptorIndex(n);
        }
        return n;
    }

    private final int decodeMapIndex() {
        int n;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = this.currentIndex % 2 != 0;
        if (bl) {
            if (this.currentIndex != -1) {
                bl2 = this.lexer.tryConsumeComma();
            }
        } else {
            this.lexer.consumeNextToken(':');
        }
        if (this.lexer.canConsumeValue()) {
            if (bl) {
                if (this.currentIndex == -1) {
                    AbstractJsonLexer abstractJsonLexer = this.lexer;
                    boolean bl4 = !bl2;
                    int n2 = abstractJsonLexer.currentPosition;
                    boolean bl5 = false;
                    if (!bl4) {
                        AbstractJsonLexer abstractJsonLexer2 = abstractJsonLexer;
                        boolean bl6 = false;
                        AbstractJsonLexer.fail$default(abstractJsonLexer2, "Unexpected leading comma", n2, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                } else {
                    AbstractJsonLexer abstractJsonLexer = this.lexer;
                    boolean bl7 = bl2;
                    int n3 = abstractJsonLexer.currentPosition;
                    boolean bl8 = false;
                    if (!bl7) {
                        AbstractJsonLexer abstractJsonLexer3 = abstractJsonLexer;
                        boolean bl9 = false;
                        AbstractJsonLexer.fail$default(abstractJsonLexer3, "Expected comma after the key-value pair", n3, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                }
            }
            n = ++this.currentIndex;
        } else {
            if (bl2 && !this.json.getConfiguration().getAllowTrailingComma()) {
                JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor serialDescriptor, int n) {
        boolean bl;
        int n2;
        Json json = this.json;
        SerialDescriptor serialDescriptor2 = serialDescriptor;
        int n3 = n;
        boolean bl2 = false;
        boolean bl3 = serialDescriptor2.isElementOptional(n3);
        SerialDescriptor serialDescriptor3 = serialDescriptor2.getElementDescriptor(n3);
        if (bl3 && !serialDescriptor3.isNullable()) {
            n2 = 1;
            bl = false;
            if (this.lexer.tryConsumeNull(n2 != 0)) {
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)serialDescriptor3.getKind(), (Object)SerialKind.ENUM.INSTANCE)) return false;
        if (serialDescriptor3.isNullable()) {
            n2 = 0;
            bl = false;
            if (this.lexer.tryConsumeNull(n2 != 0)) {
                return false;
            }
        }
        n2 = 0;
        String string = this.lexer.peekString(this.configuration.isLenient());
        if (string == null) {
            return false;
        }
        String string2 = string;
        n2 = JsonNamesMapKt.getJsonNameIndex(serialDescriptor3, json, string2);
        bl = !json.getConfiguration().getExplicitNulls() && serialDescriptor3.isNullable();
        if (n2 != -3) return false;
        if (!bl3) {
            if (!bl) return false;
        }
        boolean bl4 = false;
        this.lexer.consumeString();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int decodeObjectIndex(SerialDescriptor serialDescriptor) {
        boolean bl = this.lexer.tryConsumeComma();
        while (this.lexer.canConsumeValue()) {
            boolean bl2;
            boolean bl3;
            String string;
            block5: {
                bl = false;
                string = this.decodeStringKey();
                this.lexer.consumeNextToken(':');
                int n = JsonNamesMapKt.getJsonNameIndex(serialDescriptor, this.json, string);
                if (n != -3) {
                    if (this.configuration.getCoerceInputValues() && this.coerceInputValue(serialDescriptor, n)) {
                        bl = this.lexer.tryConsumeComma();
                        bl3 = false;
                        break block5;
                    } else {
                        JsonElementMarker jsonElementMarker = this.elementMarker;
                        if (jsonElementMarker == null) return n;
                        jsonElementMarker.mark$kotlinx_serialization_json(n);
                        return n;
                    }
                }
                bl3 = true;
            }
            if (!(bl2 = bl3)) continue;
            bl = this.handleUnknown(serialDescriptor, string);
        }
        if (bl && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
            throw new KotlinNothingValueException();
        }
        JsonElementMarker jsonElementMarker = this.elementMarker;
        if (jsonElementMarker == null) return -1;
        int n = jsonElementMarker.nextUnmarkedIndex$kotlinx_serialization_json();
        return n;
    }

    private final boolean handleUnknown(SerialDescriptor serialDescriptor, String string) {
        if (JsonNamesMapKt.ignoreUnknownKeys(serialDescriptor, this.json) || this.trySkip(this.discriminatorHolder, string)) {
            this.lexer.skipElement(this.configuration.isLenient());
        } else {
            this.lexer.path.popDescriptor();
            this.lexer.failOnUnknownKey(string);
        }
        return this.lexer.tryConsumeComma();
    }

    private final int decodeListIndex() {
        int n;
        boolean bl = this.lexer.tryConsumeComma();
        if (this.lexer.canConsumeValue()) {
            if (this.currentIndex != -1 && !bl) {
                AbstractJsonLexer.fail$default(this.lexer, "Expected end of the array or comma", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            n = ++this.currentIndex;
        } else {
            if (bl && !this.json.getConfiguration().getAllowTrailingComma()) {
                JsonExceptionsKt.invalidTrailingComma(this.lexer, "array");
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    public boolean decodeBoolean() {
        return this.lexer.consumeBooleanLenient();
    }

    public byte decodeByte() {
        long l = this.lexer.consumeNumericLiteral();
        if (l != (long)((byte)l)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse byte for input '" + l + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (byte)l;
    }

    public short decodeShort() {
        long l = this.lexer.consumeNumericLiteral();
        if (l != (long)((short)l)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse short for input '" + l + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (short)l;
    }

    public int decodeInt() {
        long l = this.lexer.consumeNumericLiteral();
        if (l != (long)((int)l)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse int for input '" + l + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (int)l;
    }

    public long decodeLong() {
        return this.lexer.consumeNumericLiteral();
    }

    public float decodeFloat() {
        float f;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String string = "float";
        boolean bl = false;
        String string2 = abstractJsonLexer.consumeStringLenient();
        try {
            String string3 = string2;
            boolean bl2 = false;
            f = Float.parseFloat(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractJsonLexer.fail$default(abstractJsonLexer, "Failed to parse type '" + string + "' for input '" + string2 + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        float f2 = f;
        boolean bl3 = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (bl3 || Math.abs(f2) <= Float.MAX_VALUE) {
            return f2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, Float.valueOf(f2));
        throw new KotlinNothingValueException();
    }

    public double decodeDouble() {
        double d;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String string = "double";
        boolean bl = false;
        String string2 = abstractJsonLexer.consumeStringLenient();
        try {
            String string3 = string2;
            boolean bl2 = false;
            d = Double.parseDouble(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractJsonLexer.fail$default(abstractJsonLexer, "Failed to parse type '" + string + "' for input '" + string2 + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        double d2 = d;
        boolean bl3 = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (bl3 || Math.abs(d2) <= Double.MAX_VALUE) {
            return d2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, d2);
        throw new KotlinNothingValueException();
    }

    public char decodeChar() {
        String string = this.lexer.consumeStringLenient();
        if (string.length() != 1) {
            AbstractJsonLexer.fail$default(this.lexer, "Expected single char, but got '" + string + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return string.charAt(0);
    }

    private final String decodeStringKey() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeKeyString();
    }

    public String decodeString() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeString();
    }

    public void decodeStringChunked(Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.lexer.consumeStringChunked(this.configuration.isLenient(), function1);
    }

    public Decoder decodeInline(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        return StreamingJsonEncoderKt.isUnsignedNumber(serialDescriptor) ? (Decoder)new JsonDecoderForUnsignedTypes(this.lexer, this.json) : super.decodeInline(serialDescriptor);
    }

    public int decodeEnum(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        return JsonNamesMapKt.getJsonNameIndexOrThrow(serialDescriptor, this.json, this.decodeString(), " at path " + this.lexer.path.getPath());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "", "discriminatorToSkip", "", "<init>", "(Ljava/lang/String;)V", "kotlinx-serialization-json"})
    public static final class DiscriminatorHolder {
        public String discriminatorToSkip;

        public DiscriminatorHolder(String string) {
            this.discriminatorToSkip = string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.OBJ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

