/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J3\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000e2!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00100\u0017H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/json/internal/StringJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "source", "", "<init>", "(Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "prefetchOrEof", "", "position", "consumeNextToken", "", "canConsumeValue", "", "skipWhitespaces", "", "expected", "", "consumeKeyString", "consumeStringChunked", "isLenient", "consumeChunk", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "stringChunk", "peekLeadingMatchingValue", "keyToMatch", "kotlinx-serialization-json"})
public class StringJsonLexer
extends AbstractJsonLexer {
    private final String source;

    public StringJsonLexer(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.source = string;
    }

    @Override
    protected String getSource() {
        return this.source;
    }

    @Override
    public int prefetchOrEof(int n) {
        return n < this.getSource().length() ? n : -1;
    }

    @Override
    public byte consumeNextToken() {
        String string = this.getSource();
        int n = this.currentPosition;
        while (n != -1 && n < string.length()) {
            char c = string.charAt(n++);
            AbstractJsonLexer abstractJsonLexer = this;
            char c2 = c;
            boolean bl = false;
            if (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t') continue;
            this.currentPosition = n;
            return AbstractJsonLexerKt.charToTokenClass(c);
        }
        this.currentPosition = string.length();
        return 10;
    }

    @Override
    public boolean canConsumeValue() {
        int n = this.currentPosition;
        if (n == -1) {
            return false;
        }
        String string = this.getSource();
        while (n < string.length()) {
            char c = string.charAt(n);
            AbstractJsonLexer abstractJsonLexer = this;
            char c2 = c;
            boolean bl = false;
            if (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t') {
                ++n;
                continue;
            }
            this.currentPosition = n;
            return this.isValidValueStart(c);
        }
        this.currentPosition = n;
        return false;
    }

    @Override
    public int skipWhitespaces() {
        int n = this.currentPosition;
        if (n == -1) {
            return n;
        }
        String string = this.getSource();
        while (n < string.length()) {
            char c = string.charAt(n);
            AbstractJsonLexer abstractJsonLexer = this;
            char c2 = c;
            boolean bl = false;
            if (!(c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t')) break;
            ++n;
        }
        this.currentPosition = n;
        return n;
    }

    @Override
    public void consumeNextToken(char c) {
        if (this.currentPosition == -1) {
            this.unexpectedToken(c);
        }
        String string = this.getSource();
        int n = this.currentPosition;
        while (n < string.length()) {
            char c2 = string.charAt(n++);
            AbstractJsonLexer abstractJsonLexer = this;
            char c3 = c2;
            boolean bl = false;
            if (c3 == ' ' || c3 == '\n' || c3 == '\r' || c3 == '\t') continue;
            this.currentPosition = n;
            if (c2 == c) {
                return;
            }
            this.unexpectedToken(c);
        }
        this.currentPosition = -1;
        this.unexpectedToken(c);
    }

    @Override
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int n = this.currentPosition;
        int n2 = StringsKt.indexOf$default((CharSequence)this.getSource(), (char)'\"', (int)n, (boolean)false, (int)4, null);
        if (n2 == -1) {
            String string;
            this.consumeStringLenient();
            AbstractJsonLexer abstractJsonLexer = this;
            byte by = 1;
            boolean bl = false;
            boolean bl2 = false;
            String string2 = AbstractJsonLexerKt.tokenDescription(by);
            int n3 = abstractJsonLexer.currentPosition;
            String string3 = string = abstractJsonLexer.currentPosition == AbstractJsonLexer.access$getSource(abstractJsonLexer).length() || n3 < 0 ? "EOF" : String.valueOf(AbstractJsonLexer.access$getSource(abstractJsonLexer).charAt(n3));
            String string4 = string2;
            AbstractJsonLexer abstractJsonLexer2 = abstractJsonLexer;
            boolean bl3 = false;
            AbstractJsonLexer.fail$default(abstractJsonLexer2, "Expected " + string4 + ", but had '" + string3 + "' instead", n3, null, 4, null);
            throw new KotlinNothingValueException();
        }
        for (int i = n; i < n2; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = n2 + 1;
        String string = this.getSource().substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public void consumeStringChunked(boolean bl, Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Iterable iterable = StringsKt.chunked((CharSequence)(bl ? this.consumeStringLenient() : this.consumeString()), (int)16384);
        boolean bl2 = false;
        for (Object t : iterable) {
            function1.invoke(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String peekLeadingMatchingValue(String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = this.currentPosition;
        try {
            if (this.consumeNextToken() != 6) {
                String string2 = null;
                return string2;
            }
            String string3 = this.peekString(bl);
            if (!Intrinsics.areEqual((Object)string3, (Object)string)) {
                String string4 = null;
                return string4;
            }
            this.discardPeeked();
            if (this.consumeNextToken() != 5) {
                String string5 = null;
                return string5;
            }
            String string6 = this.peekString(bl);
            return string6;
        }
        finally {
            this.currentPosition = n;
            this.discardPeeked();
        }
    }
}

