/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.engine.ClassLoaderDelegate;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0005*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\u0007\u001a\u0019\u0010\u000b\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ljava/lang/ClassLoader;", "", "Ljava/net/URL;", "allURLs", "(Ljava/lang/ClassLoader;)Ljava/util/Set;", "", "urlClassPath", "(Ljava/lang/ClassLoader;)Ljava/util/List;", "urlClassPathByPackagesList", "Ljava/lang/Class;", "Ljava/lang/reflect/Field;", "findURLClassPathField", "(Ljava/lang/Class;)Ljava/lang/reflect/Field;", "ktor-server-core"})
public final class ClassLoadersKt {
    public static final Set<URL> allURLs(ClassLoader classLoader) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"");
        Object object2 = classLoader.getParent();
        if (object2 == null || (object2 = ClassLoadersKt.allURLs((ClassLoader)object2)) == null) {
            object2 = object = SetsKt.emptySet();
        }
        if (classLoader instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
            Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"");
            Set set = CollectionsKt.toSet((Iterable)ArraysKt.filterNotNull((Object[])uRLArray));
            return SetsKt.plus((Set)set, (Iterable)((Iterable)object));
        }
        List<URL> list = ClassLoadersKt.urlClassPath(classLoader);
        if (list == null) {
            return object;
        }
        List<URL> list2 = list;
        return SetsKt.plus((Set)object, (Iterable)list2);
    }

    private static final List<URL> urlClassPath(ClassLoader classLoader) {
        try {
            Field field = ClassLoadersKt.findURLClassPathField(classLoader.getClass());
            if (field == null) {
                return null;
            }
            Field field2 = field;
            field2.setAccessible(true);
            Object object = field2.get(classLoader);
            if (object == null) {
                return null;
            }
            Object object2 = object;
            Method method = object2.getClass().getMethod("getURLs", new Class[0]);
            if (method == null) {
                return null;
            }
            Method method2 = method;
            method2.setAccessible(true);
            Object[] objectArray = (URL[])method2.invoke(object2, new Object[0]);
            return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }
        catch (Throwable throwable) {
            List<URL> list;
            try {
                list = ClassLoadersKt.urlClassPathByPackagesList(classLoader);
            }
            catch (Throwable throwable2) {
                list = null;
            }
            return list;
        }
    }

    private static final List<URL> urlClassPathByPackagesList(ClassLoader classLoader) {
        Object object;
        HashSet<String> hashSet = (HashSet<String>)((Object)new ClassLoaderDelegate(classLoader).packagesList());
        boolean bl = false;
        HashSet<String> hashSet2 = hashSet;
        ArrayList<Object> arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)hashSet, (int)10));
        boolean bl2 = false;
        for (Object bl5 : hashSet2) {
            object = (String)bl5;
            Collection collection = arrayList;
            boolean bl10 = false;
            collection.add(StringsKt.replace$default((String)object, (char)'.', (char)'/', (boolean)false, (int)4, null));
        }
        hashSet = arrayList;
        Collection collection = new HashSet();
        boolean bl4 = false;
        for (Object e : hashSet) {
            Object object2 = (String)e;
            boolean t = false;
            object = new char[1];
            object[0] = 47;
            List list = StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])object, (boolean)false, (int)0, (int)6, null);
            object = (Iterable)new IntRange(1, list.size());
            boolean bl3 = false;
            Object object3 = object;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            boolean bl5 = false;
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                int n;
                int n2 = n = ((IntIterator)iterator).nextInt();
                Collection collection3 = collection2;
                boolean bl6 = false;
                collection3.add(CollectionsKt.joinToString$default((Iterable)list.subList(0, n2), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
            }
            object2 = CollectionsKt.plus((Collection)((List)collection2), object2);
            CollectionsKt.addAll((Collection)collection, (Iterable)object2);
        }
        hashSet = collection;
        boolean bl9 = false;
        List list = CollectionsKt.plus((Collection)CollectionsKt.sortedWith((Iterable)hashSet, (Comparator)new Comparator(){

            public final int compare(T t, T t2) {
                boolean bl;
                char c2;
                char c3;
                int n;
                String string = (String)t;
                boolean bl2 = false;
                CharSequence charSequence = string;
                boolean bl3 = false;
                int n2 = 0;
                for (n = 0; n < charSequence.length(); ++n) {
                    c2 = c3 = charSequence.charAt(n);
                    bl = false;
                    if (!(c2 == '/')) continue;
                    ++n2;
                }
                string = (String)t2;
                Comparable comparable = Integer.valueOf(n2);
                bl2 = false;
                charSequence = string;
                bl3 = false;
                n2 = 0;
                for (n = 0; n < charSequence.length(); ++n) {
                    c2 = c3 = charSequence.charAt(n);
                    bl = false;
                    if (!(c2 == '/')) continue;
                    ++n2;
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n2));
            }
        }), (Object)"");
        hashSet = list;
        bl9 = false;
        HashSet<String> hashSet3 = hashSet;
        arrayList = new ArrayList();
        boolean bl7 = false;
        for (Object object5 : hashSet3) {
            Object object4;
            block8: {
                block7: {
                    object = (String)object5;
                    boolean bl8 = false;
                    object4 = classLoader.getResources((String)object);
                    if (object4 == null) break block7;
                    ArrayList<URL> arrayList2 = Collections.list(object4);
                    Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"");
                    object4 = arrayList2;
                    if (object4 != null) break block8;
                }
                object4 = CollectionsKt.emptyList();
            }
            object = (Iterable)object4;
            CollectionsKt.addAll(arrayList, (Iterable)object);
        }
        hashSet = arrayList;
        bl9 = false;
        hashSet3 = new HashSet<String>();
        arrayList = new ArrayList<Object>();
        for (Object object2 : hashSet) {
            URL uRL = (URL)object2;
            boolean bl10 = false;
            String string = uRL.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            String string2 = StringsKt.substringBefore$default((String)string, (char)'!', null, (int)2, null);
            if (!hashSet3.add(string2)) continue;
            arrayList.add(object2);
        }
        return arrayList;
    }

    private static final Field findURLClassPathField(Class<?> clazz) {
        Object object;
        block3: {
            Field[] fieldArray = clazz.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"");
            Object[] objectArray = fieldArray;
            boolean bl = false;
            for (Object object2 : objectArray) {
                Field field = (Field)object2;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)field.getName(), (Object)"ucp") && Intrinsics.areEqual((Object)field.getType().getSimpleName(), (Object)"URLClassPath"))) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        Field field = (Field)object;
        if (field != null) {
            Field field2 = field;
            int n = 0;
            return field2;
        }
        AnnotatedElement annotatedElement = clazz.getSuperclass();
        if (annotatedElement == null || (annotatedElement = ClassLoadersKt.findURLClassPathField(annotatedElement)) == null) {
            return null;
        }
        return annotatedElement;
    }
}

