/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.EpollRecvByteAllocatorStreamingHandle;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.SocketWritableByteChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.Executor;

public abstract class AbstractEpollStreamChannel
extends AbstractEpollChannel
implements DuplexChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ')';
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractEpollStreamChannel.class);
    private final Runnable flushTask = new Runnable(){

        @Override
        public void run() {
            ((AbstractEpollChannel.AbstractEpollUnsafe)AbstractEpollStreamChannel.this.unsafe()).flush0();
        }
    };
    private volatile Queue<SpliceInTask> spliceQueue;
    private FileDescriptor pipeIn;
    private FileDescriptor pipeOut;
    private WritableByteChannel byteChannel;

    protected AbstractEpollStreamChannel(Channel channel, int n) {
        this(channel, new LinuxSocket(n));
    }

    protected AbstractEpollStreamChannel(int n) {
        this(new LinuxSocket(n));
    }

    AbstractEpollStreamChannel(LinuxSocket linuxSocket) {
        this(linuxSocket, AbstractEpollStreamChannel.isSoErrorZero(linuxSocket));
    }

    AbstractEpollStreamChannel(Channel channel, LinuxSocket linuxSocket) {
        super(channel, linuxSocket, true);
        this.flags |= Native.EPOLLRDHUP;
    }

    protected AbstractEpollStreamChannel(Channel channel, LinuxSocket linuxSocket, SocketAddress socketAddress) {
        super(channel, linuxSocket, socketAddress);
        this.flags |= Native.EPOLLRDHUP;
    }

    protected AbstractEpollStreamChannel(LinuxSocket linuxSocket, boolean bl) {
        super(null, linuxSocket, bl);
        this.flags |= Native.EPOLLRDHUP;
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollStreamUnsafe();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    public final ChannelFuture spliceTo(AbstractEpollStreamChannel abstractEpollStreamChannel, int n) {
        return this.spliceTo(abstractEpollStreamChannel, n, this.newPromise());
    }

    public final ChannelFuture spliceTo(AbstractEpollStreamChannel abstractEpollStreamChannel, int n, ChannelPromise channelPromise) {
        if (abstractEpollStreamChannel.eventLoop() != this.eventLoop()) {
            throw new IllegalArgumentException("EventLoops are not the same.");
        }
        ObjectUtil.checkPositiveOrZero((int)n, (String)"len");
        if (abstractEpollStreamChannel.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED || this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull((Object)channelPromise, (String)"promise");
        if (!this.isOpen()) {
            channelPromise.tryFailure((Throwable)new ClosedChannelException());
        } else {
            this.addToSpliceQueue(new SpliceInChannelTask(abstractEpollStreamChannel, n, channelPromise));
            this.failSpliceIfClosed(channelPromise);
        }
        return channelPromise;
    }

    public final ChannelFuture spliceTo(FileDescriptor fileDescriptor, int n, int n2) {
        return this.spliceTo(fileDescriptor, n, n2, this.newPromise());
    }

    public final ChannelFuture spliceTo(FileDescriptor fileDescriptor, int n, int n2, ChannelPromise channelPromise) {
        ObjectUtil.checkPositiveOrZero((int)n2, (String)"len");
        ObjectUtil.checkPositiveOrZero((int)n, (String)"offset");
        if (this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull((Object)channelPromise, (String)"promise");
        if (!this.isOpen()) {
            channelPromise.tryFailure((Throwable)new ClosedChannelException());
        } else {
            this.addToSpliceQueue(new SpliceFdTask(fileDescriptor, n, n2, channelPromise));
            this.failSpliceIfClosed(channelPromise);
        }
        return channelPromise;
    }

    private void failSpliceIfClosed(ChannelPromise channelPromise) {
        ClosedChannelException closedChannelException;
        if (!this.isOpen() && !channelPromise.isDone() && channelPromise.tryFailure((Throwable)(closedChannelException = new ClosedChannelException()))) {
            this.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    AbstractEpollStreamChannel.this.clearSpliceQueue(closedChannelException);
                }
            });
        }
    }

    private int writeBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            channelOutboundBuffer.remove();
            return 0;
        }
        if (byteBuf.hasMemoryAddress() || byteBuf.nioBufferCount() == 1) {
            return this.doWriteBytes(channelOutboundBuffer, byteBuf);
        }
        ByteBuffer[] byteBufferArray = byteBuf.nioBuffers();
        return this.writeBytesMultiple(channelOutboundBuffer, byteBufferArray, byteBufferArray.length, n, this.config().getMaxBytesPerGatheringWrite());
    }

    private void adjustMaxBytesPerGatheringWrite(long l, long l2, long l3) {
        if (l == l2) {
            if (l << 1 > l3) {
                this.config().setMaxBytesPerGatheringWrite(l << 1);
            }
        } else if (l > 4096L && l2 < l >>> 1) {
            this.config().setMaxBytesPerGatheringWrite(l >>> 1);
        }
    }

    private int writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, IovArray iovArray) {
        long l = iovArray.size();
        assert (l != 0L);
        int n = iovArray.count();
        assert (n != 0);
        long l2 = this.socket.writevAddresses(iovArray.memoryAddress(0), n);
        if (l2 > 0L) {
            this.adjustMaxBytesPerGatheringWrite(l, l2, iovArray.maxBytes());
            channelOutboundBuffer.removeBytes(l2);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, ByteBuffer[] byteBufferArray, int n, long l, long l2) {
        long l3;
        assert (l != 0L);
        if (l > l2) {
            l = l2;
        }
        if ((l3 = this.socket.writev(byteBufferArray, 0, n, l)) > 0L) {
            this.adjustMaxBytesPerGatheringWrite(l, l3, l2);
            channelOutboundBuffer.removeBytes(l3);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeDefaultFileRegion(ChannelOutboundBuffer channelOutboundBuffer, DefaultFileRegion defaultFileRegion) {
        long l;
        long l2 = defaultFileRegion.transferred();
        if (l2 >= (l = defaultFileRegion.count())) {
            channelOutboundBuffer.remove();
            return 0;
        }
        long l3 = this.socket.sendFile(defaultFileRegion, defaultFileRegion.position(), l2, l - l2);
        if (l3 > 0L) {
            channelOutboundBuffer.progress(l3);
            if (defaultFileRegion.transferred() >= l) {
                channelOutboundBuffer.remove();
            }
            return 1;
        }
        if (l3 == 0L) {
            this.validateFileRegion(defaultFileRegion, l2);
        }
        return Integer.MAX_VALUE;
    }

    private int writeFileRegion(ChannelOutboundBuffer channelOutboundBuffer, FileRegion fileRegion) {
        long l;
        if (fileRegion.transferred() >= fileRegion.count()) {
            channelOutboundBuffer.remove();
            return 0;
        }
        if (this.byteChannel == null) {
            this.byteChannel = new EpollSocketWritableByteChannel();
        }
        if ((l = fileRegion.transferTo(this.byteChannel, fileRegion.transferred())) > 0L) {
            channelOutboundBuffer.progress(l);
            if (fileRegion.transferred() >= fileRegion.count()) {
                channelOutboundBuffer.remove();
            }
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        int n = this.config().getWriteSpinCount();
        do {
            int n2;
            if ((n2 = channelOutboundBuffer.size()) > 1 && channelOutboundBuffer.current() instanceof ByteBuf) {
                n -= this.doWriteMultiple(channelOutboundBuffer);
                continue;
            }
            if (n2 == 0) {
                this.clearFlag(Native.EPOLLOUT);
                return;
            }
            n -= this.doWriteSingle(channelOutboundBuffer);
        } while (n > 0);
        if (n == 0) {
            this.clearFlag(Native.EPOLLOUT);
            this.eventLoop().execute(this.flushTask);
        } else {
            this.setFlag(Native.EPOLLOUT);
        }
    }

    protected int doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object = channelOutboundBuffer.current();
        if (object instanceof ByteBuf) {
            return this.writeBytes(channelOutboundBuffer, (ByteBuf)object);
        }
        if (object instanceof DefaultFileRegion) {
            return this.writeDefaultFileRegion(channelOutboundBuffer, (DefaultFileRegion)object);
        }
        if (object instanceof FileRegion) {
            return this.writeFileRegion(channelOutboundBuffer, (FileRegion)object);
        }
        if (object instanceof SpliceOutTask) {
            if (!((SpliceOutTask)object).spliceOut()) {
                return Integer.MAX_VALUE;
            }
            channelOutboundBuffer.remove();
            return 1;
        }
        throw new Error();
    }

    private int doWriteMultiple(ChannelOutboundBuffer channelOutboundBuffer) {
        long l = this.config().getMaxBytesPerGatheringWrite();
        IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanIovArray();
        iovArray.maxBytes(l);
        channelOutboundBuffer.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)iovArray);
        if (iovArray.count() >= 1) {
            return this.writeBytesMultiple(channelOutboundBuffer, iovArray);
        }
        channelOutboundBuffer.removeBytes(0L);
        return 0;
    }

    protected Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? this.newDirectBuffer(byteBuf) : byteBuf;
        }
        if (object instanceof FileRegion || object instanceof SpliceOutTask) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
    }

    protected final void doShutdownOutput() {
        this.socket.shutdown(false, true);
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.socket.shutdown(true, false);
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isShutdown() {
        return this.socket.isShutdown();
    }

    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    public ChannelFuture shutdownOutput(final ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)this.unsafe()).shutdownOutput(channelPromise);
        } else {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)AbstractEpollStreamChannel.this.unsafe()).shutdownOutput(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    public ChannelFuture shutdownInput(final ChannelPromise channelPromise) {
        Executor executor = ((EpollStreamUnsafe)this.unsafe()).prepareToClose();
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractEpollStreamChannel.this.shutdownInput0(channelPromise);
                }
            });
        } else {
            EventLoop eventLoop = this.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.shutdownInput0(channelPromise);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEpollStreamChannel.this.shutdownInput0(channelPromise);
                    }
                });
            }
        }
        return channelPromise;
    }

    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    public ChannelFuture shutdown(final ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    AbstractEpollStreamChannel.this.shutdownOutputDone(channelFuture, channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void shutdownOutputDone(final ChannelFuture channelFuture, final ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            AbstractEpollStreamChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
        } else {
            channelFuture2.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture2) {
                    AbstractEpollStreamChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
                }
            });
        }
    }

    private static void shutdownDone(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        Throwable throwable2 = channelFuture2.cause();
        if (throwable != null) {
            if (throwable2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", throwable2);
            }
            channelPromise.setFailure(throwable);
        } else if (throwable2 != null) {
            channelPromise.setFailure(throwable2);
        } else {
            channelPromise.setSuccess();
        }
    }

    @Override
    protected void doClose() {
        try {
            super.doClose();
        }
        finally {
            AbstractEpollStreamChannel.safeClosePipe(this.pipeIn);
            AbstractEpollStreamChannel.safeClosePipe(this.pipeOut);
            this.clearSpliceQueue(null);
        }
    }

    private void clearSpliceQueue(ClosedChannelException closedChannelException) {
        SpliceInTask spliceInTask;
        Queue<SpliceInTask> queue = this.spliceQueue;
        if (queue == null) {
            return;
        }
        while ((spliceInTask = queue.poll()) != null) {
            if (closedChannelException == null) {
                closedChannelException = new ClosedChannelException();
            }
            spliceInTask.promise.tryFailure((Throwable)closedChannelException);
        }
    }

    private static void safeClosePipe(FileDescriptor fileDescriptor) {
        if (fileDescriptor != null) {
            try {
                fileDescriptor.close();
            }
            catch (IOException iOException) {
                logger.warn("Error while closing a pipe", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSpliceQueue(SpliceInTask spliceInTask) {
        Queue queue = this.spliceQueue;
        if (queue == null) {
            AbstractEpollStreamChannel abstractEpollStreamChannel = this;
            synchronized (abstractEpollStreamChannel) {
                queue = this.spliceQueue;
                if (queue == null) {
                    this.spliceQueue = queue = PlatformDependent.newMpscQueue();
                }
            }
        }
        queue.add((SpliceInTask)spliceInTask);
    }

    private final class EpollSocketWritableByteChannel
    extends SocketWritableByteChannel {
        EpollSocketWritableByteChannel() {
            super((FileDescriptor)AbstractEpollStreamChannel.this.socket);
            assert (this.fd == AbstractEpollStreamChannel.this.socket);
        }

        protected int write(ByteBuffer byteBuffer, int n, int n2) {
            return AbstractEpollStreamChannel.this.socket.send(byteBuffer, n, n2);
        }

        protected ByteBufAllocator alloc() {
            return AbstractEpollStreamChannel.this.alloc();
        }
    }

    private final class SpliceFdTask
    extends SpliceInTask {
        private final FileDescriptor fd;
        private final ChannelPromise promise;
        private int offset;

        SpliceFdTask(FileDescriptor fileDescriptor, int n, int n2, ChannelPromise channelPromise) {
            super(n2, channelPromise);
            this.fd = fileDescriptor;
            this.promise = channelPromise;
            this.offset = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean spliceIn(RecvByteBufAllocator.Handle handle) {
            assert (AbstractEpollStreamChannel.this.eventLoop().inEventLoop());
            if (this.len == 0) {
                this.promise.trySuccess();
                return true;
            }
            try {
                FileDescriptor[] fileDescriptorArray = FileDescriptor.pipe();
                FileDescriptor fileDescriptor2 = fileDescriptorArray[0];
                FileDescriptor fileDescriptor = fileDescriptorArray[1];
                try {
                    int n;
                    int n2 = this.spliceIn(fileDescriptor, handle);
                    if (n2 > 0) {
                        if (this.len != Integer.MAX_VALUE) {
                            this.len -= n2;
                        }
                        do {
                            n = Native.splice(fileDescriptor2.intValue(), -1L, this.fd.intValue(), this.offset, n2);
                            this.offset += n;
                        } while ((n2 -= n) > 0);
                        if (this.len == 0) {
                            this.promise.trySuccess();
                            n = 1;
                            return n != 0;
                        }
                    }
                    n = 0;
                    return n != 0;
                }
                finally {
                    AbstractEpollStreamChannel.safeClosePipe(fileDescriptor2);
                    AbstractEpollStreamChannel.safeClosePipe(fileDescriptor);
                }
            }
            catch (Throwable throwable2) {
                this.promise.tryFailure(throwable2);
                return true;
            }
        }
    }

    private final class SpliceOutTask {
        private final AbstractEpollStreamChannel ch;
        private final boolean autoRead;
        private int len;

        SpliceOutTask(AbstractEpollStreamChannel abstractEpollStreamChannel2, int n, boolean bl) {
            this.ch = abstractEpollStreamChannel2;
            this.len = n;
            this.autoRead = bl;
        }

        public boolean spliceOut() {
            assert (this.ch.eventLoop().inEventLoop());
            try {
                int n = Native.splice(this.ch.pipeIn.intValue(), -1L, this.ch.socket.intValue(), -1L, this.len);
                this.len -= n;
                if (this.len == 0) {
                    if (this.autoRead) {
                        AbstractEpollStreamChannel.this.config().setAutoRead(true);
                    }
                    return true;
                }
                return false;
            }
            catch (IOException iOException) {
                if (this.autoRead) {
                    AbstractEpollStreamChannel.this.config().setAutoRead(true);
                }
                throw iOException;
            }
        }
    }

    private final class SpliceInChannelTask
    extends SpliceInTask
    implements ChannelFutureListener {
        private final AbstractEpollStreamChannel ch;

        SpliceInChannelTask(AbstractEpollStreamChannel abstractEpollStreamChannel2, int n, ChannelPromise channelPromise) {
            super(n, channelPromise);
            this.ch = abstractEpollStreamChannel2;
        }

        public void operationComplete(ChannelFuture channelFuture) {
            if (!channelFuture.isSuccess()) {
                this.promise.tryFailure(channelFuture.cause());
            }
        }

        @Override
        public boolean spliceIn(RecvByteBufAllocator.Handle handle) {
            assert (this.ch.eventLoop().inEventLoop());
            if (this.len == 0) {
                this.promise.trySuccess();
                return true;
            }
            try {
                int n;
                FileDescriptor fileDescriptor = this.ch.pipeOut;
                if (fileDescriptor == null) {
                    FileDescriptor[] fileDescriptorArray = FileDescriptor.pipe();
                    this.ch.pipeIn = fileDescriptorArray[0];
                    fileDescriptor = this.ch.pipeOut = fileDescriptorArray[1];
                }
                if ((n = this.spliceIn(fileDescriptor, handle)) > 0) {
                    if (this.len != Integer.MAX_VALUE) {
                        this.len -= n;
                    }
                    ChannelPromise channelPromise = this.len == 0 ? this.promise : this.ch.newPromise().addListener((GenericFutureListener)this);
                    boolean bl = AbstractEpollStreamChannel.this.config().isAutoRead();
                    this.ch.unsafe().write((Object)new SpliceOutTask(this.ch, n, bl), channelPromise);
                    this.ch.unsafe().flush();
                    if (bl && !channelPromise.isDone()) {
                        AbstractEpollStreamChannel.this.config().setAutoRead(false);
                    }
                }
                return this.len == 0;
            }
            catch (Throwable throwable) {
                this.promise.tryFailure(throwable);
                return true;
            }
        }
    }

    protected abstract class SpliceInTask {
        final ChannelPromise promise;
        int len;

        protected SpliceInTask(int n, ChannelPromise channelPromise) {
            this.promise = channelPromise;
            this.len = n;
        }

        abstract boolean spliceIn(RecvByteBufAllocator.Handle var1);

        protected final int spliceIn(FileDescriptor fileDescriptor, RecvByteBufAllocator.Handle handle) {
            int n = Math.min(handle.guess(), this.len);
            int n2 = 0;
            while (true) {
                int n3 = Native.splice(AbstractEpollStreamChannel.this.socket.intValue(), -1L, fileDescriptor.intValue(), -1L, n);
                handle.lastBytesRead(n3);
                if (n3 == 0) break;
                n2 += n3;
                n -= n3;
            }
            return n2;
        }
    }

    class EpollStreamUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        EpollStreamUnsafe() {
        }

        protected Executor prepareToClose() {
            return super.prepareToClose();
        }

        private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl, EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    channelPipeline.fireChannelRead((Object)byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            epollRecvByteAllocatorHandle.readComplete();
            channelPipeline.fireChannelReadComplete();
            channelPipeline.fireExceptionCaught(throwable);
            if (bl || throwable instanceof OutOfMemoryError || throwable instanceof IOException) {
                this.shutdownInput(false);
            }
        }

        @Override
        EpollRecvByteAllocatorHandle newEpollHandle(RecvByteBufAllocator.ExtendedHandle extendedHandle) {
            return new EpollRecvByteAllocatorStreamingHandle(extendedHandle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            EpollChannelConfig epollChannelConfig = AbstractEpollStreamChannel.this.config();
            if (AbstractEpollStreamChannel.this.shouldBreakEpollInReady((ChannelConfig)epollChannelConfig)) {
                this.clearEpollIn0();
                return;
            }
            EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
            epollRecvByteAllocatorHandle.edgeTriggered(AbstractEpollStreamChannel.this.isFlagSet(Native.EPOLLET));
            ChannelPipeline channelPipeline = AbstractEpollStreamChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = epollChannelConfig.getAllocator();
            epollRecvByteAllocatorHandle.reset((ChannelConfig)epollChannelConfig);
            this.epollInBefore();
            ByteBuf byteBuf = null;
            boolean bl = false;
            Queue queue = null;
            try {
                do {
                    SpliceInTask spliceInTask;
                    if ((queue != null || (queue = AbstractEpollStreamChannel.this.spliceQueue) != null) && (spliceInTask = (SpliceInTask)queue.peek()) != null) {
                        boolean bl2 = spliceInTask.spliceIn((RecvByteBufAllocator.Handle)epollRecvByteAllocatorHandle);
                        if (epollRecvByteAllocatorHandle.isReceivedRdHup()) {
                            this.shutdownInput(true);
                        }
                        if (!bl2) break;
                        if (!AbstractEpollStreamChannel.this.isActive()) continue;
                        queue.remove();
                        continue;
                    }
                    byteBuf = epollRecvByteAllocatorHandle.allocate(byteBufAllocator);
                    epollRecvByteAllocatorHandle.lastBytesRead(AbstractEpollStreamChannel.this.doReadBytes(byteBuf));
                    if (epollRecvByteAllocatorHandle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        boolean bl3 = bl = epollRecvByteAllocatorHandle.lastBytesRead() < 0;
                        if (!bl) break;
                        this.readPending = false;
                        break;
                    }
                    epollRecvByteAllocatorHandle.incMessagesRead(1);
                    this.readPending = false;
                    channelPipeline.fireChannelRead((Object)byteBuf);
                    byteBuf = null;
                    if (AbstractEpollStreamChannel.this.shouldBreakEpollInReady((ChannelConfig)epollChannelConfig)) break;
                } while (epollRecvByteAllocatorHandle.continueReading());
                epollRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (bl) {
                    this.shutdownInput(false);
                }
            }
            catch (Throwable throwable) {
                this.handleReadException(channelPipeline, byteBuf, throwable, bl, epollRecvByteAllocatorHandle);
            }
            finally {
                if (queue == null) {
                    this.epollInFinally((ChannelConfig)epollChannelConfig);
                } else if (!epollChannelConfig.isAutoRead()) {
                    AbstractEpollStreamChannel.this.clearEpollIn();
                }
            }
        }
    }
}

