/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.NIOKt;
import io.ktor.websocket.Frame;
import io.ktor.websocket.FrameType;
import io.ktor.websocket.UtilsKt;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\t*\u00020\tH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0018\u0010\"\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010!R\u0018\u0010$\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010\u001cR\u0011\u0010,\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0011\u0010/\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00060"}, d2={"Lio/ktor/websocket/Serializer;", "", "<init>", "()V", "Lio/ktor/websocket/Frame;", "f", "", "enqueue", "(Lio/ktor/websocket/Frame;)V", "Ljava/nio/ByteBuffer;", "buffer", "serialize", "(Ljava/nio/ByteBuffer;)V", "frame", "", "mask", "serializeHeader", "(Lio/ktor/websocket/Frame;Ljava/nio/ByteBuffer;Z)V", "", "estimateFrameHeaderSize", "(Lio/ktor/websocket/Frame;Z)I", "writeCurrentPayload", "(Ljava/nio/ByteBuffer;)Z", "maskSize", "(Z)I", "maskedIfNeeded", "(Ljava/nio/ByteBuffer;)Ljava/nio/ByteBuffer;", "setMaskBuffer", "(Z)V", "Ljava/util/concurrent/ArrayBlockingQueue;", "messages", "Ljava/util/concurrent/ArrayBlockingQueue;", "frameBody", "Ljava/nio/ByteBuffer;", "maskBuffer", "Lio/ktor/websocket/FrameType;", "lastDataFrameType", "Lio/ktor/websocket/FrameType;", "masking", "Z", "getMasking", "()Z", "setMasking", "getHasOutstandingBytes", "hasOutstandingBytes", "getRemainingCapacity", "()I", "remainingCapacity", "ktor-websockets"})
public final class Serializer {
    private final ArrayBlockingQueue<Frame> messages = new ArrayBlockingQueue(1024);
    private ByteBuffer frameBody;
    private ByteBuffer maskBuffer;
    private FrameType lastDataFrameType;
    private boolean masking;

    public final boolean getMasking() {
        return this.masking;
    }

    public final void setMasking(boolean bl) {
        this.masking = bl;
    }

    public final boolean getHasOutstandingBytes() {
        return !((Collection)this.messages).isEmpty() || this.frameBody != null;
    }

    public final int getRemainingCapacity() {
        return this.messages.remainingCapacity();
    }

    public final void enqueue(Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"");
        this.messages.put(frame);
    }

    public final void serialize(ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"");
        while (this.writeCurrentPayload(byteBuffer) && this.messages.peek() != null) {
            Frame frame;
            boolean bl = this.masking;
            this.setMaskBuffer(bl);
            int n2 = this.estimateFrameHeaderSize(frame, bl);
            if (byteBuffer.remaining() < n2) break;
            this.serializeHeader(frame, byteBuffer, bl);
            this.messages.remove();
            this.frameBody = this.maskedIfNeeded(frame.getBuffer());
        }
    }

    private final void serializeHeader(Frame frame, ByteBuffer byteBuffer, boolean bl) {
        block11: {
            ByteBuffer byteBuffer2;
            int n2;
            int n3 = frame.getBuffer().remaining();
            int n4 = n3 < 126 ? n3 : (n3 <= 65535 ? 126 : 127);
            FrameType frameType = this.lastDataFrameType;
            if (frameType == null) {
                if (!frame.getFin()) {
                    this.lastDataFrameType = frame.getFrameType();
                }
                n2 = frame.getFrameType().getOpcode();
            } else if (frameType == frame.getFrameType()) {
                if (frame.getFin()) {
                    this.lastDataFrameType = null;
                }
                n2 = 0;
            } else {
                if (!frame.getFrameType().getControlFrame()) {
                    throw new IllegalStateException("Can't continue with different data frame opcode");
                }
                n2 = frame.getFrameType().getOpcode();
            }
            int n5 = n2;
            boolean bl2 = frame.getFin();
            int n6 = 7;
            boolean bl3 = false;
            int n7 = bl2 ? 1 << n6 : 0;
            bl2 = frame.getRsv1();
            n6 = 6;
            bl3 = false;
            int n8 = n7 | (bl2 ? 1 << n6 : 0);
            bl2 = frame.getRsv2();
            n6 = 5;
            bl3 = false;
            int n9 = n8 | (bl2 ? 1 << n6 : 0);
            bl2 = frame.getRsv3();
            n6 = 4;
            bl3 = false;
            int n10 = n9 | (bl2 ? 1 << n6 : 0) | n5;
            byteBuffer.put((byte)n10);
            bl2 = bl;
            n6 = 7;
            bl3 = false;
            byteBuffer.put((byte)((bl2 ? 1 << n6 : 0) | n4));
            switch (n4) {
                case 126: {
                    byteBuffer.putShort((short)frame.getBuffer().remaining());
                    break;
                }
                case 127: {
                    byteBuffer.putLong(frame.getBuffer().remaining());
                }
            }
            if ((byteBuffer2 = this.maskBuffer) == null || (byteBuffer2 = byteBuffer2.duplicate()) == null) break block11;
            NIOKt.moveTo$default((ByteBuffer)byteBuffer2, (ByteBuffer)byteBuffer, (int)0, (int)2, null);
        }
    }

    private final int estimateFrameHeaderSize(Frame frame, boolean bl) {
        int n2 = frame.getBuffer().remaining();
        return (n2 < 126 ? 2 : (n2 <= Short.MAX_VALUE ? 4 : 10)) + this.maskSize(bl);
    }

    private final boolean writeCurrentPayload(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = this.frameBody;
        if (byteBuffer2 == null) {
            return true;
        }
        ByteBuffer byteBuffer3 = byteBuffer2;
        NIOKt.moveTo$default((ByteBuffer)byteBuffer3, (ByteBuffer)byteBuffer, (int)0, (int)2, null);
        if (!byteBuffer3.hasRemaining()) {
            this.frameBody = null;
            return true;
        }
        return false;
    }

    private final int maskSize(boolean bl) {
        return bl ? 4 : 0;
    }

    private final ByteBuffer maskedIfNeeded(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        block3: {
            block2: {
                ByteBuffer byteBuffer3;
                byteBuffer2 = this.maskBuffer;
                if (byteBuffer2 == null) break block2;
                ByteBuffer byteBuffer4 = byteBuffer2;
                boolean bl = false;
                ByteBuffer byteBuffer5 = byteBuffer3 = NIOKt.copy$default((ByteBuffer)byteBuffer, (int)0, (int)1, null);
                boolean bl2 = false;
                UtilsKt.xor(byteBuffer5, byteBuffer4);
                ByteBuffer byteBuffer6 = byteBuffer3;
                byteBuffer2 = byteBuffer6;
                if (byteBuffer6 != null) break block3;
            }
            byteBuffer2 = byteBuffer;
        }
        return byteBuffer2;
    }

    private final void setMaskBuffer(boolean bl) {
        ByteBuffer byteBuffer;
        Serializer serializer = this;
        if (bl) {
            ByteBuffer byteBuffer2;
            ByteBuffer byteBuffer3 = byteBuffer2 = ByteBuffer.allocate(4);
            Serializer serializer2 = serializer;
            boolean bl2 = false;
            byteBuffer3.putInt(Random.Default.nextInt());
            byteBuffer3.clear();
            serializer = serializer2;
            byteBuffer = byteBuffer2;
        } else {
            byteBuffer = null;
        }
        serializer.maskBuffer = byteBuffer;
    }
}

