/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import dorkbox.jna.linux.GCallback;
import dorkbox.jna.linux.GObject;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.os.OS;
import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenu;
import dorkbox.systemTray.ui.gtk._AppIndicatorNativeTray;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.GtkTheme;
import dorkbox.systemTray.util.HeavyCheckMark;
import dorkbox.systemTray.util.SizeAndScaling;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class GtkMenuItemCheckbox
extends GtkBaseMenuItem
implements GCallback,
CheckboxPeer {
    private static volatile String checkedFile;
    static String uncheckedFile;
    private static final boolean useFakeCheckMark;
    private final GtkMenu parent;
    private volatile ActionListener callback;
    private volatile boolean isChecked = false;
    private volatile Pointer checkedImage;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';
    private final long handlerId;

    GtkMenuItemCheckbox(GtkMenu gtkMenu) {
        super(useFakeCheckMark ? Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic("") : Gtk.Gtk2.gtk_check_menu_item_new_with_mnemonic(""));
        this.parent = gtkMenu;
        this.handlerId = GObject.g_signal_connect_object((Pointer)this._native, (String)"activate", (Callback)this, null, (int)0);
        if (useFakeCheckMark) {
            if (checkedFile == null) {
                Color color = GtkTheme.getTextColor();
                if (color == null) {
                    SystemTray.logger.error("Unable to determine the text color in use by your system. Please create an issue and include your full OS configuration and desktop environment, including theme details, such as the theme name, color variant, and custom theme options (if any).");
                    color = Color.BLACK;
                }
                if (checkedFile == null) {
                    Rectangle rectangle = GtkTheme.getPixelTextHeight("X");
                    int n = SizeAndScaling.TRAY_MENU_SIZE;
                    int n2 = rectangle.height;
                    if (SystemTray.DEBUG) {
                        SystemTray.logger.debug("Fake checkmark size: {}px", (Object)n2);
                    }
                    checkedFile = _AppIndicatorNativeTray.isLoaded ? HeavyCheckMark.get(color, n2, n2) : HeavyCheckMark.get(color, n2, n);
                }
            }
            this.setCheckedIconForFakeCheckMarks();
        } else {
            GObject.g_signal_handler_block((Pointer)this._native, (long)this.handlerId);
            Gtk.Gtk2.gtk_check_menu_item_set_active(this._native, false);
            GObject.g_signal_handler_unblock((Pointer)this._native, (long)this.handlerId);
        }
    }

    public int callback(Pointer pointer, Pointer pointer2) {
        ActionListener actionListener = this.callback;
        if (actionListener != null) {
            GtkEventDispatch.proxyClick((ActionListener)actionListener);
        }
        return 1;
    }

    @Override
    public boolean hasImage() {
        return true;
    }

    @Override
    public void setSpacerImage(boolean bl) {
    }

    @Override
    public void setEnabled(Checkbox checkbox) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_sensitive(this._native, checkbox.getEnabled()));
    }

    @Override
    public void setText(Checkbox checkbox) {
        String string;
        int n;
        String string2 = this.mnemonicKey != '\u0000' ? ((n = (string = checkbox.getText()).toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? string.substring(0, n) + "_" + string.substring(n) : checkbox.getText()) : checkbox.getText();
        GtkEventDispatch.dispatch(() -> {
            Gtk.Gtk2.gtk_menu_item_set_label(this._native, string2);
            Gtk.Gtk2.gtk_widget_show_all(this._native);
        });
    }

    @Override
    public void setCallback(final Checkbox checkbox) {
        this.callback = checkbox.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = checkbox.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    checkbox.setChecked(!GtkMenuItemCheckbox.this.isChecked);
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(checkbox, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu checkbox entry {} click event.", (Object)checkbox.getText(), (Object)throwable);
                        }
                    });
                }
            };
        }
    }

    @Override
    public void setChecked(Checkbox checkbox) {
        boolean bl = checkbox.getChecked();
        if (bl != this.isChecked) {
            this.isChecked = bl;
            GtkEventDispatch.dispatch(() -> {
                if (useFakeCheckMark) {
                    this.setCheckedIconForFakeCheckMarks();
                } else {
                    GObject.g_signal_handler_block((Pointer)this._native, (long)this.handlerId);
                    Gtk.Gtk2.gtk_check_menu_item_set_active(this._native, this.isChecked);
                    GObject.g_signal_handler_unblock((Pointer)this._native, (long)this.handlerId);
                }
            });
        }
    }

    @Override
    public void setTooltip(Checkbox checkbox) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_tooltip_text(this._native, checkbox.getTooltip()));
    }

    private void setCheckedIconForFakeCheckMarks() {
        if (this.checkedImage != null) {
            Gtk.Gtk2.gtk_container_remove(this._native, this.checkedImage);
            this.checkedImage = null;
        }
        this.checkedImage = this.isChecked ? Gtk.Gtk2.gtk_image_new_from_file(checkedFile) : Gtk.Gtk2.gtk_image_new_from_file(uncheckedFile);
        Gtk.Gtk2.gtk_image_menu_item_set_image(this._native, this.checkedImage);
        Gtk.Gtk2.gtk_image_menu_item_set_always_show_image(this._native, true);
        Gtk.Gtk2.gtk_widget_show_all(this._native);
    }

    @Override
    public void setShortcut(Checkbox checkbox) {
        char c = checkbox.getShortcut();
        this.mnemonicKey = c != '\u0000' ? Character.toLowerCase(c) : (char)'\u0000';
        this.setText(checkbox);
    }

    @Override
    public void remove() {
        GtkEventDispatch.dispatch(() -> {
            GtkMenuItemCheckbox.super.remove();
            this.callback = null;
            Gtk.Gtk2.gtk_container_remove(this.parent._nativeMenu, this._native);
            if (this.image != null) {
                Gtk.Gtk2.gtk_container_remove(this._native, this.image);
                this.image = null;
            }
            this.parent.remove(this);
        });
    }

    static {
        int[] nArray;
        uncheckedFile = null;
        useFakeCheckMark = SystemTray.AUTO_FIX_INCONSISTENCIES && _AppIndicatorNativeTray.isLoaded && OS.Linux.INSTANCE.isUbuntu() ? (nArray = OS.Linux.INSTANCE.getUbuntuVersion())[0] < 17 || nArray[0] == 17 && nArray[1] == 4 : false;
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Using Fake CheckMark: " + useFakeCheckMark);
        }
    }
}

