/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.collections.ArrayMap;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.os.OS;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.ui.swing.SwingMenuItem;
import dorkbox.systemTray.ui.swing.SwingMenuItemCheckbox;
import dorkbox.systemTray.ui.swing.TrayPopup;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.systemTray.util.SizeAndScaling;
import dorkbox.util.SwingUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public final class _SwingTray
extends Tray {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private final ArrayMap<String, Image> imageCache = new ArrayMap(false, 10);

    public _SwingTray(String string, ImageResizeUtil imageResizeUtil, Runnable runnable) {
        super(runnable);
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        SwingMenuItem.createTransparentIcon(SizeAndScaling.TRAY_MENU_SIZE, imageResizeUtil);
        SwingMenuItemCheckbox.createCheckedIcon(SizeAndScaling.TRAY_MENU_SIZE);
        SwingMenu swingMenu = new SwingMenu(string){

            @Override
            public void setEnabled(MenuItem menuItem) {
                SwingUtil.INSTANCE.invokeLater(() -> {
                    if (_SwingTray.this.tray == null) {
                        _SwingTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    boolean bl = menuItem.getEnabled();
                    if (_SwingTray.this.visible && !bl) {
                        _SwingTray.this.tray.remove(_SwingTray.this.trayIcon);
                        _SwingTray.this.visible = false;
                    } else if (!_SwingTray.this.visible && bl) {
                        try {
                            _SwingTray.this.tray.add(_SwingTray.this.trayIcon);
                            _SwingTray.this.visible = true;
                            _SwingTray.this.trayIcon.setToolTip(_SwingTray.this.tooltipText);
                        }
                        catch (AWTException aWTException) {
                            SystemTray.logger.error("Error adding the icon back to the tray", (Throwable)aWTException);
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _SwingTray.this.imageFile = menuItem.getImage();
                SwingUtil.INSTANCE.invokeLater(() -> {
                    Image image;
                    Object object;
                    if (_SwingTray.this.tray == null) {
                        _SwingTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    if (_SwingTray.this.imageFile != null) {
                        object = _SwingTray.this.imageFile.getAbsolutePath();
                        ArrayMap arrayMap = _SwingTray.this.imageCache;
                        synchronized (arrayMap) {
                            Image image2 = (Image)_SwingTray.this.imageCache.get(object);
                            if (image2 == null) {
                                image2 = new ImageIcon((String)object).getImage();
                                _SwingTray.this.imageCache.put(object, (Object)image2);
                                if (_SwingTray.this.imageCache.getSize() > 120) {
                                    SystemTray.logger.error("More than 120 different images used for the SystemTray icon. This will lead to performance issues.");
                                }
                            }
                            image = image2;
                        }
                    } else {
                        image = null;
                    }
                    if (_SwingTray.this.trayIcon == null) {
                        if (image == null) {
                            return;
                        }
                        _SwingTray.this.trayIcon = new TrayIcon(image);
                        object = (JPopupMenu)this._native;
                        ((JPopupMenu)object).pack();
                        ((Component)object).setFocusable(true);
                        if (_SwingTray.this.tooltipText != null && !_SwingTray.this.tooltipText.isEmpty()) {
                            _SwingTray.this.trayIcon.setToolTip(_SwingTray.this.tooltipText);
                        }
                        _SwingTray.this.trayIcon.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mousePressed(MouseEvent mouseEvent) {
                                TrayPopup trayPopup = (TrayPopup)_native;
                                Point point = mouseEvent.getPoint();
                                double d = SizeAndScaling.getDpiScaleForMouseClick(point.x, point.y);
                                Point point2 = new Point((int)((double)point.x * d), (int)((double)point.y * d));
                                trayPopup.doShow(point2, 0);
                            }
                        });
                        try {
                            _SwingTray.this.tray.add(_SwingTray.this.trayIcon);
                        }
                        catch (AWTException aWTException) {
                            SystemTray.logger.error("TrayIcon could not be added.", (Throwable)aWTException);
                        }
                    } else if (image != null) {
                        _SwingTray.this.trayIcon.setImage(image);
                    }
                    _SwingTray.this.trayIcon.setToolTip(_SwingTray.this.tooltipText);
                    if (_SwingTray.this.imageFile != null) {
                        ((TrayPopup)this._native).setTitleBarImage(_SwingTray.this.imageFile);
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                String string = menuItem.getTooltip();
                if (_SwingTray.this.tooltipText != null && _SwingTray.this.tooltipText.equals(string)) {
                    return;
                }
                _SwingTray.this.tooltipText = string;
                SwingUtil.INSTANCE.invokeLater(() -> {
                    if (_SwingTray.this.trayIcon != null) {
                        _SwingTray.this.trayIcon.setToolTip(string);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                ArrayMap arrayMap = _SwingTray.this.imageCache;
                synchronized (arrayMap) {
                    for (Image image : _SwingTray.this.imageCache.getValues()) {
                        image.flush();
                    }
                    _SwingTray.this.imageCache.clear();
                }
                SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
                    if (_SwingTray.this.trayIcon != null) {
                        if (_SwingTray.this.tray != null) {
                            _SwingTray.this.tray.remove(_SwingTray.this.trayIcon);
                        }
                        _SwingTray.this.trayIcon = null;
                    }
                    _SwingTray.this.tray = null;
                });
                super.remove();
                if (OS.INSTANCE.isLinux() || OS.INSTANCE.isUnix()) {
                    GtkEventDispatch.shutdownGui();
                }
            }
        };
        this.bind(swingMenu, null, imageResizeUtil);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

