/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import dorkbox.collections.ArrayMap;
import dorkbox.jna.windows.HBITMAPWrap;
import dorkbox.jna.windows.HICONWrap;
import dorkbox.jna.windows.Listener;
import dorkbox.jna.windows.Shell32;
import dorkbox.jna.windows.User32;
import dorkbox.jna.windows.WindowsEventDispatch;
import dorkbox.jna.windows.structs.NOTIFYICONDATA;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.ui.swing.SwingMenuItem;
import dorkbox.systemTray.ui.swing.SwingMenuItemCheckbox;
import dorkbox.systemTray.ui.swing.TrayPopup;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.systemTray.util.SizeAndScaling;
import dorkbox.systemTray.util.SizeAndScalingWindows;
import dorkbox.util.ImageUtil;
import dorkbox.util.SwingUtil;
import java.awt.Point;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class _WindowsNativeTray
extends Tray {
    private final Listener quitListener;
    private final Listener menuListener;
    private final Listener showListener;
    private volatile TrayPopup popupMenu;
    private volatile boolean visible = false;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private final WindowsEventDispatch edt;
    private final ArrayMap<File, HICONWrap> imageCache = new ArrayMap(false, 10);

    public _WindowsNativeTray(String string, ImageResizeUtil imageResizeUtil, Runnable runnable) {
        super(runnable);
        SwingMenuItem.createTransparentIcon(SizeAndScaling.TRAY_MENU_SIZE, imageResizeUtil);
        SwingMenuItemCheckbox.createCheckedIcon(SizeAndScaling.TRAY_MENU_SIZE);
        this.edt = WindowsEventDispatch.start();
        SwingMenu swingMenu = new SwingMenu(string){

            @Override
            public void setImage(MenuItem menuItem) {
                _WindowsNativeTray.this.imageFile = menuItem.getImage();
                NOTIFYICONDATA nOTIFYICONDATA = new NOTIFYICONDATA();
                nOTIFYICONDATA.hWnd = _WindowsNativeTray.this.edt.get();
                if (_WindowsNativeTray.this.imageFile != null) {
                    HICONWrap hICONWrap = _WindowsNativeTray.this.convertImage(_WindowsNativeTray.this.imageFile);
                    nOTIFYICONDATA.setIcon((WinDef.HICON)hICONWrap);
                }
                if (!Shell32.Shell_NotifyIcon((int)1, (NOTIFYICONDATA)nOTIFYICONDATA)) {
                    SystemTray.logger.error("Error setting the image for the tray. {}", (Object)Kernel32Util.getLastErrorMessage());
                }
                _WindowsNativeTray.this.setTooltip_(_WindowsNativeTray.this.tooltipText);
                SwingUtil.INSTANCE.invokeLater(() -> {
                    if (_WindowsNativeTray.this.popupMenu == null) {
                        TrayPopup trayPopup = (TrayPopup)this._native;
                        trayPopup.pack();
                        trayPopup.setFocusable(true);
                        _WindowsNativeTray.this.popupMenu = trayPopup;
                    }
                    _WindowsNativeTray.this.popupMenu.setTitleBarImage(_WindowsNativeTray.this.imageFile);
                });
            }

            @Override
            public void setEnabled(MenuItem menuItem) {
                boolean bl = menuItem.getEnabled();
                if (_WindowsNativeTray.this.visible && !bl) {
                    _WindowsNativeTray.this.hide();
                } else if (!_WindowsNativeTray.this.visible && bl) {
                    _WindowsNativeTray.this.show();
                }
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                String string = menuItem.getTooltip();
                _WindowsNativeTray.this.setTooltip_(string);
            }

            @Override
            public void remove() {
                _WindowsNativeTray.this.hide();
                super.remove();
                _WindowsNativeTray.this.edt.stop();
            }
        };
        WinDef.HWND hWND = this.edt.get();
        if (hWND == null) {
            throw new RuntimeException("The Windows System Tray is not supported! Please write an issue and include your OS type and configuration");
        }
        this.showListener = new Listener(){

            public void run(WinDef.HWND hWND, WinDef.WPARAM wPARAM, WinDef.LPARAM lPARAM) {
                _WindowsNativeTray.this.show();
            }
        };
        this.quitListener = new Listener(){

            public void run(WinDef.HWND hWND, WinDef.WPARAM wPARAM, WinDef.LPARAM lPARAM) {
                _WindowsNativeTray.this.edt.removeListener(_WindowsNativeTray.this.showListener);
                _WindowsNativeTray.this.edt.removeListener(_WindowsNativeTray.this.quitListener);
                _WindowsNativeTray.this.edt.removeListener(_WindowsNativeTray.this.menuListener);
                _WindowsNativeTray.this.edt.stop();
            }
        };
        this.menuListener = new Listener(){
            final WinDef.POINT mousePosition = new WinDef.POINT();

            public void run(WinDef.HWND hWND, WinDef.WPARAM wPARAM, WinDef.LPARAM lPARAM) {
                int n = lPARAM.intValue();
                switch (n) {
                    case 514: 
                    case 517: {
                        if (_WindowsNativeTray.this.popupMenu == null || !User32.User32.GetCursorPos(this.mousePosition)) break;
                        double d = SizeAndScalingWindows.getDpiScaleForMouseClick(this.mousePosition.x, this.mousePosition.y);
                        Point point = new Point((int)((double)this.mousePosition.x * d), (int)((double)this.mousePosition.y * d));
                        _WindowsNativeTray.this.popupMenu.doShow(point, 0);
                        break;
                    }
                }
            }
        };
        this.edt.addListener(WindowsEventDispatch.WM_TASKBARCREATED, this.showListener);
        this.edt.addListener(18, this.quitListener);
        this.edt.addListener(1025, this.menuListener);
        this.show();
        this.bind(swingMenu, null, imageResizeUtil);
    }

    private void setTooltip_(String string) {
        if (this.tooltipText != null && this.tooltipText.equals(string)) {
            return;
        }
        NOTIFYICONDATA nOTIFYICONDATA = new NOTIFYICONDATA();
        nOTIFYICONDATA.hWnd = this.edt.get();
        if (string != null) {
            this.tooltipText = string;
            nOTIFYICONDATA.setTooltip(string);
        } else {
            this.tooltipText = "";
        }
        Shell32.Shell_NotifyIcon((int)1, (NOTIFYICONDATA)nOTIFYICONDATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hide() {
        NOTIFYICONDATA nOTIFYICONDATA = this.imageCache;
        synchronized (nOTIFYICONDATA) {
            for (HICONWrap hICONWrap : this.imageCache.getValues()) {
                hICONWrap.close();
            }
            this.imageCache.clear();
        }
        if (this.visible) {
            nOTIFYICONDATA = new NOTIFYICONDATA();
            nOTIFYICONDATA.hWnd = this.edt.get();
            if (nOTIFYICONDATA.hWnd != null && !Shell32.Shell_NotifyIcon((int)2, (NOTIFYICONDATA)nOTIFYICONDATA)) {
                SystemTray.logger.error("Error hiding tray. {}", (Object)Kernel32Util.getLastErrorMessage());
            }
            this.visible = false;
        }
    }

    private void show() {
        HICONWrap hICONWrap;
        if (this.visible) {
            this.hide();
        }
        NOTIFYICONDATA nOTIFYICONDATA = new NOTIFYICONDATA();
        nOTIFYICONDATA.hWnd = this.edt.get();
        nOTIFYICONDATA.setTooltip(this.tooltipText);
        if (this.imageFile != null && (hICONWrap = this.convertImage(this.imageFile)) != null) {
            nOTIFYICONDATA.setIcon((WinDef.HICON)hICONWrap);
        }
        nOTIFYICONDATA.setCallback(1025);
        if (!Shell32.Shell_NotifyIcon((int)0, (NOTIFYICONDATA)nOTIFYICONDATA)) {
            SystemTray.logger.error("Error showing tray. {}, {}", (Object)Kernel32Util.getLastErrorMessage(), (Object)Thread.currentThread().getStackTrace());
        }
        this.visible = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HICONWrap convertImage(File file) {
        ArrayMap<File, HICONWrap> arrayMap = this.imageCache;
        synchronized (arrayMap) {
            HICONWrap hICONWrap = (HICONWrap)this.imageCache.get((Object)file);
            if (hICONWrap == null) {
                ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
                if ((imageIcon = new ImageIcon(imageIcon.getImage())).getIconHeight() <= 0 || imageIcon.getIconWidth() <= 0) {
                    SystemTray.logger.error("Error loading image for the system tray. {}", (Object)file);
                    return null;
                }
                HBITMAPWrap hBITMAPWrap = new HBITMAPWrap(ImageUtil.getBufferedImage((Icon)imageIcon));
                hICONWrap = new HICONWrap(hBITMAPWrap);
                this.imageCache.put((Object)file, (Object)hICONWrap);
                if (this.imageCache.getSize() > 120) {
                    SystemTray.logger.error("More than 120 different images used for the SystemTray icon. This will lead to performance issues.");
                }
            }
            return hICONWrap;
        }
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

