/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.ReferenceCountUtil;

public class HttpToHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private final boolean validateHeaders;
    private int currentStreamId;
    private HttpScheme httpScheme;

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings);
        this.validateHeaders = bl;
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl, boolean bl2) {
        this(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl, bl2, null);
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl, boolean bl2, HttpScheme httpScheme) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl2);
        this.validateHeaders = bl;
        this.httpScheme = httpScheme;
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl, boolean bl2, boolean bl3, HttpScheme httpScheme) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings, bl2, bl3);
        this.validateHeaders = bl;
        this.httpScheme = httpScheme;
    }

    private int getStreamId(HttpHeaders httpHeaders) {
        return httpHeaders.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), this.connection().local().incrementAndGetNextStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!(object instanceof HttpMessage) && !(object instanceof HttpContent)) {
            channelHandlerContext.write(object, channelPromise);
            return;
        }
        boolean bl = true;
        Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            Object object2;
            Http2ConnectionEncoder http2ConnectionEncoder = this.encoder();
            boolean bl2 = false;
            if (object instanceof HttpMessage) {
                HttpMessage httpMessage = (HttpMessage)object;
                this.currentStreamId = this.getStreamId(httpMessage.headers());
                if (this.httpScheme != null && !httpMessage.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text())) {
                    httpMessage.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)this.httpScheme.name());
                }
                object2 = HttpConversionUtil.toHttp2Headers(httpMessage, this.validateHeaders);
                bl2 = object instanceof FullHttpMessage && !((FullHttpMessage)object).content().isReadable();
                HttpToHttp2ConnectionHandler.writeHeaders(channelHandlerContext, http2ConnectionEncoder, this.currentStreamId, httpMessage.headers(), (Http2Headers)object2, bl2, simpleChannelPromiseAggregator);
            }
            if (!bl2 && object instanceof HttpContent) {
                ByteBuf byteBuf;
                boolean bl3 = false;
                object2 = EmptyHttpHeaders.INSTANCE;
                Http2Headers http2Headers = EmptyHttp2Headers.INSTANCE;
                if (object instanceof LastHttpContent) {
                    bl3 = true;
                    byteBuf = (LastHttpContent)object;
                    object2 = byteBuf.trailingHeaders();
                    http2Headers = HttpConversionUtil.toHttp2Headers((HttpHeaders)object2, this.validateHeaders);
                }
                byteBuf = ((HttpContent)object).content();
                bl2 = bl3 && object2.isEmpty();
                http2ConnectionEncoder.writeData(channelHandlerContext, this.currentStreamId, byteBuf, 0, bl2, simpleChannelPromiseAggregator.newPromise());
                bl = false;
                if (!object2.isEmpty()) {
                    HttpToHttp2ConnectionHandler.writeHeaders(channelHandlerContext, http2ConnectionEncoder, this.currentStreamId, (HttpHeaders)object2, http2Headers, true, simpleChannelPromiseAggregator);
                }
            }
        }
        catch (Throwable throwable) {
            this.onError(channelHandlerContext, true, throwable);
            simpleChannelPromiseAggregator.setFailure(throwable);
        }
        finally {
            if (bl) {
                ReferenceCountUtil.release((Object)object);
            }
            simpleChannelPromiseAggregator.doneAllocatingPromises();
        }
    }

    private static void writeHeaders(ChannelHandlerContext channelHandlerContext, Http2ConnectionEncoder http2ConnectionEncoder, int n, HttpHeaders httpHeaders, Http2Headers http2Headers, boolean bl, Http2CodecUtil.SimpleChannelPromiseAggregator simpleChannelPromiseAggregator) {
        int n2 = httpHeaders.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
        short s = httpHeaders.getShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        http2ConnectionEncoder.writeHeaders(channelHandlerContext, n, http2Headers, n2, s, false, 0, bl, simpleChannelPromiseAggregator.newPromise());
    }
}

