/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;

final class MaxCapacityQueue<E>
implements Queue<E> {
    private final Queue<E> queue;
    private final int maxCapacity;

    MaxCapacityQueue(Queue<E> queue, int n) {
        this.queue = queue;
        this.maxCapacity = n;
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean offer(E e) {
        if (this.maxCapacity <= this.queue.size()) {
            return false;
        }
        return this.queue.offer(e);
    }

    @Override
    public E remove() {
        return this.queue.remove();
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    @Override
    public E element() {
        return this.queue.element();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.queue.contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.queue.toArray(TArray);
    }

    @Override
    public boolean remove(Object object) {
        return this.queue.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.queue.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.maxCapacity >= this.size() + collection.size()) {
            return this.queue.addAll(collection);
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.queue.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.queue.retainAll(collection);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }
}

