/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.Map;

public class DefaultLastHttpContent
extends DefaultHttpContent
implements LastHttpContent {
    private final HttpHeaders trailingHeaders;

    public DefaultLastHttpContent() {
        this(Unpooled.buffer((int)0));
    }

    public DefaultLastHttpContent(ByteBuf byteBuf) {
        this(byteBuf, DefaultHttpHeadersFactory.trailersFactory());
    }

    @Deprecated
    public DefaultLastHttpContent(ByteBuf byteBuf, boolean bl) {
        this(byteBuf, DefaultHttpHeadersFactory.trailersFactory().withValidation(bl));
    }

    public DefaultLastHttpContent(ByteBuf byteBuf, HttpHeadersFactory httpHeadersFactory) {
        super(byteBuf);
        this.trailingHeaders = httpHeadersFactory.newHeaders();
    }

    public DefaultLastHttpContent(ByteBuf byteBuf, HttpHeaders httpHeaders) {
        super(byteBuf);
        this.trailingHeaders = (HttpHeaders)ObjectUtil.checkNotNull((Object)httpHeaders, (String)"trailingHeaders");
    }

    @Override
    public LastHttpContent copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public LastHttpContent duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public LastHttpContent retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public LastHttpContent replace(ByteBuf byteBuf) {
        return new DefaultLastHttpContent(byteBuf, this.trailingHeaders().copy());
    }

    @Override
    public LastHttpContent retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public LastHttpContent retain() {
        super.retain();
        return this;
    }

    @Override
    public LastHttpContent touch() {
        super.touch();
        return this;
    }

    @Override
    public LastHttpContent touch(Object object) {
        super.touch(object);
        return this;
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(StringUtil.NEWLINE);
        this.appendHeaders(stringBuilder);
        stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
        return stringBuilder.toString();
    }

    private void appendHeaders(StringBuilder stringBuilder) {
        for (Map.Entry<String, String> entry : this.trailingHeaders()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(StringUtil.NEWLINE);
        }
    }
}

