/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

public class WebSocketServerExtensionHandler
extends ChannelDuplexHandler {
    private final List<WebSocketServerExtensionHandshaker> extensionHandshakers;
    private final Queue<List<WebSocketServerExtension>> validExtensions = new ArrayDeque<List<WebSocketServerExtension>>(4);

    public WebSocketServerExtensionHandler(WebSocketServerExtensionHandshaker ... webSocketServerExtensionHandshakerArray) {
        this.extensionHandshakers = Arrays.asList(ObjectUtil.checkNonEmpty((Object[])webSocketServerExtensionHandshakerArray, (String)"extensionHandshakers"));
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object != LastHttpContent.EMPTY_LAST_CONTENT) {
            if (object instanceof DefaultHttpRequest) {
                this.onHttpRequestChannelRead(channelHandlerContext, (DefaultHttpRequest)object);
            } else if (object instanceof HttpRequest) {
                this.onHttpRequestChannelRead(channelHandlerContext, (HttpRequest)object);
            } else {
                super.channelRead(channelHandlerContext, object);
            }
        } else {
            super.channelRead(channelHandlerContext, object);
        }
    }

    protected void onHttpRequestChannelRead(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        String string;
        List list = null;
        if (WebSocketExtensionUtil.isWebsocketUpgrade(httpRequest.headers()) && (string = httpRequest.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS)) != null) {
            List<WebSocketExtensionData> list2 = WebSocketExtensionUtil.extractExtensions(string);
            int n = 0;
            for (WebSocketExtensionData webSocketExtensionData : list2) {
                Iterator<WebSocketServerExtensionHandshaker> iterator = this.extensionHandshakers.iterator();
                WebSocketExtension webSocketExtension = null;
                while (webSocketExtension == null && iterator.hasNext()) {
                    WebSocketServerExtensionHandshaker webSocketServerExtensionHandshaker = iterator.next();
                    webSocketExtension = webSocketServerExtensionHandshaker.handshakeExtension(webSocketExtensionData);
                }
                if (webSocketExtension == null || (webSocketExtension.rsv() & n) != 0) continue;
                if (list == null) {
                    list = new ArrayList(1);
                }
                n |= webSocketExtension.rsv();
                list.add(webSocketExtension);
            }
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        this.validExtensions.offer(list);
        super.channelRead(channelHandlerContext, (Object)httpRequest);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object != Unpooled.EMPTY_BUFFER && !(object instanceof ByteBuf)) {
            if (object instanceof DefaultHttpResponse) {
                this.onHttpResponseWrite(channelHandlerContext, (DefaultHttpResponse)object, channelPromise);
            } else if (object instanceof HttpResponse) {
                this.onHttpResponseWrite(channelHandlerContext, (HttpResponse)object, channelPromise);
            } else {
                super.write(channelHandlerContext, object, channelPromise);
            }
        } else {
            super.write(channelHandlerContext, object, channelPromise);
        }
    }

    protected void onHttpResponseWrite(ChannelHandlerContext channelHandlerContext, HttpResponse httpResponse, ChannelPromise channelPromise) {
        List<WebSocketServerExtension> list = this.validExtensions.poll();
        if (HttpResponseStatus.SWITCHING_PROTOCOLS.equals(httpResponse.status())) {
            this.handlePotentialUpgrade(channelHandlerContext, channelPromise, httpResponse, list);
        }
        super.write(channelHandlerContext, (Object)httpResponse, channelPromise);
    }

    private void handlePotentialUpgrade(final ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, HttpResponse httpResponse, final List<WebSocketServerExtension> list) {
        HttpHeaders httpHeaders = httpResponse.headers();
        if (WebSocketExtensionUtil.isWebsocketUpgrade(httpHeaders)) {
            if (list != null && !list.isEmpty()) {
                String string = httpHeaders.getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
                ArrayList<WebSocketExtensionData> arrayList = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
                for (WebSocketServerExtension webSocketServerExtension : list) {
                    arrayList.add(webSocketServerExtension.newReponseData());
                }
                String string2 = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(string, arrayList);
                channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        if (channelFuture.isSuccess()) {
                            for (WebSocketServerExtension webSocketServerExtension : list) {
                                WebSocketExtensionDecoder webSocketExtensionDecoder = webSocketServerExtension.newExtensionDecoder();
                                WebSocketExtensionEncoder webSocketExtensionEncoder = webSocketServerExtension.newExtensionEncoder();
                                String string = channelHandlerContext.name();
                                channelHandlerContext.pipeline().addAfter(string, ((Object)((Object)webSocketExtensionDecoder)).getClass().getName(), (ChannelHandler)webSocketExtensionDecoder).addAfter(string, ((Object)((Object)webSocketExtensionEncoder)).getClass().getName(), (ChannelHandler)webSocketExtensionEncoder);
                            }
                        }
                    }
                });
                if (string2 != null) {
                    httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)string2);
                }
            }
            channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    if (channelFuture.isSuccess()) {
                        channelHandlerContext.pipeline().remove((ChannelHandler)WebSocketServerExtensionHandler.this);
                    }
                }
            });
        }
    }
}

