/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

abstract class DeflateDecoder
extends WebSocketExtensionDecoder {
    static final ByteBuf FRAME_TAIL = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, -1, -1})).asReadOnly();
    static final ByteBuf EMPTY_DEFLATE_BLOCK = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0})).asReadOnly();
    private final boolean noContext;
    private final WebSocketExtensionFilter extensionDecoderFilter;
    private EmbeddedChannel decoder;

    DeflateDecoder(boolean bl, WebSocketExtensionFilter webSocketExtensionFilter) {
        this.noContext = bl;
        this.extensionDecoderFilter = (WebSocketExtensionFilter)ObjectUtil.checkNotNull((Object)webSocketExtensionFilter, (String)"extensionDecoderFilter");
    }

    protected WebSocketExtensionFilter extensionDecoderFilter() {
        return this.extensionDecoderFilter;
    }

    protected abstract boolean appendFrameTail(WebSocketFrame var1);

    protected abstract int newRsv(WebSocketFrame var1);

    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        WebSocketFrame webSocketFrame2;
        ByteBuf byteBuf = this.decompressContent(channelHandlerContext, webSocketFrame);
        if (webSocketFrame instanceof TextWebSocketFrame) {
            webSocketFrame2 = new TextWebSocketFrame(webSocketFrame.isFinalFragment(), this.newRsv(webSocketFrame), byteBuf);
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            webSocketFrame2 = new BinaryWebSocketFrame(webSocketFrame.isFinalFragment(), this.newRsv(webSocketFrame), byteBuf);
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            webSocketFrame2 = new ContinuationWebSocketFrame(webSocketFrame.isFinalFragment(), this.newRsv(webSocketFrame), byteBuf);
        } else {
            throw new CodecException("unexpected frame type: " + ((Object)((Object)webSocketFrame)).getClass().getName());
        }
        list.add((Object)webSocketFrame2);
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.handlerRemoved(channelHandlerContext);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.channelInactive(channelHandlerContext);
    }

    private ByteBuf decompressContent(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame) {
        ByteBuf byteBuf;
        if (this.decoder == null) {
            if (!(webSocketFrame instanceof TextWebSocketFrame) && !(webSocketFrame instanceof BinaryWebSocketFrame)) {
                throw new CodecException("unexpected initial frame type: " + ((Object)((Object)webSocketFrame)).getClass().getName());
            }
            this.decoder = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE)});
        }
        boolean bl = webSocketFrame.content().isReadable();
        boolean bl2 = EMPTY_DEFLATE_BLOCK.equals((Object)webSocketFrame.content());
        this.decoder.writeInbound(new Object[]{webSocketFrame.content().retain()});
        if (this.appendFrameTail(webSocketFrame)) {
            this.decoder.writeInbound(new Object[]{FRAME_TAIL.duplicate()});
        }
        CompositeByteBuf compositeByteBuf = channelHandlerContext.alloc().compositeBuffer();
        while ((byteBuf = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            compositeByteBuf.addComponent(true, byteBuf);
        }
        if (!bl2 && bl && compositeByteBuf.numComponents() <= 0 && !(webSocketFrame instanceof ContinuationWebSocketFrame)) {
            compositeByteBuf.release();
            throw new CodecException("cannot read uncompressed buffer");
        }
        if (webSocketFrame.isFinalFragment() && this.noContext) {
            this.cleanup();
        }
        return compositeByteBuf;
    }

    private void cleanup() {
        if (this.decoder != null) {
            this.decoder.finishAndReleaseAll();
            this.decoder = null;
        }
    }
}

