/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

abstract class DeflateEncoder
extends WebSocketExtensionEncoder {
    private final int compressionLevel;
    private final int windowSize;
    private final boolean noContext;
    private final WebSocketExtensionFilter extensionEncoderFilter;
    private EmbeddedChannel encoder;

    DeflateEncoder(int n, int n2, boolean bl, WebSocketExtensionFilter webSocketExtensionFilter) {
        this.compressionLevel = n;
        this.windowSize = n2;
        this.noContext = bl;
        this.extensionEncoderFilter = (WebSocketExtensionFilter)ObjectUtil.checkNotNull((Object)webSocketExtensionFilter, (String)"extensionEncoderFilter");
    }

    protected WebSocketExtensionFilter extensionEncoderFilter() {
        return this.extensionEncoderFilter;
    }

    protected abstract int rsv(WebSocketFrame var1);

    protected abstract boolean removeFrameTail(WebSocketFrame var1);

    protected void encode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        WebSocketFrame webSocketFrame2;
        ByteBuf byteBuf;
        if (webSocketFrame.content().isReadable()) {
            byteBuf = this.compressContent(channelHandlerContext, webSocketFrame);
        } else if (webSocketFrame.isFinalFragment()) {
            byteBuf = PerMessageDeflateDecoder.EMPTY_DEFLATE_BLOCK.duplicate();
        } else {
            throw new CodecException("cannot compress content buffer");
        }
        if (webSocketFrame instanceof TextWebSocketFrame) {
            webSocketFrame2 = new TextWebSocketFrame(webSocketFrame.isFinalFragment(), this.rsv(webSocketFrame), byteBuf);
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            webSocketFrame2 = new BinaryWebSocketFrame(webSocketFrame.isFinalFragment(), this.rsv(webSocketFrame), byteBuf);
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            webSocketFrame2 = new ContinuationWebSocketFrame(webSocketFrame.isFinalFragment(), this.rsv(webSocketFrame), byteBuf);
        } else {
            throw new CodecException("unexpected frame type: " + ((Object)((Object)webSocketFrame)).getClass().getName());
        }
        list.add((Object)webSocketFrame2);
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.handlerRemoved(channelHandlerContext);
    }

    private ByteBuf compressContent(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame) {
        ByteBuf byteBuf;
        if (this.encoder == null) {
            this.encoder = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)this.compressionLevel, (int)this.windowSize, (int)8)});
        }
        this.encoder.writeOutbound(new Object[]{webSocketFrame.content().retain()});
        CompositeByteBuf compositeByteBuf = channelHandlerContext.alloc().compositeBuffer();
        while ((byteBuf = (ByteBuf)this.encoder.readOutbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            compositeByteBuf.addComponent(true, byteBuf);
        }
        if (compositeByteBuf.numComponents() <= 0) {
            compositeByteBuf.release();
            throw new CodecException("cannot read compressed buffer");
        }
        if (webSocketFrame.isFinalFragment() && this.noContext) {
            this.cleanup();
        }
        if (this.removeFrameTail(webSocketFrame)) {
            int n = compositeByteBuf.readableBytes() - PerMessageDeflateDecoder.FRAME_TAIL.readableBytes();
            byteBuf = compositeByteBuf.slice(0, n);
        } else {
            byteBuf = compositeByteBuf;
        }
        return byteBuf;
    }

    private void cleanup() {
        if (this.encoder != null) {
            this.encoder.finishAndReleaseAll();
            this.encoder = null;
        }
    }
}

