/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.rtsp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectEncoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;

public class RtspEncoder
extends HttpObjectEncoder<HttpMessage> {
    private static final int CRLF_SHORT = 3338;

    @Override
    public boolean acceptOutboundMessage(Object object) {
        return super.acceptOutboundMessage(object) && (object instanceof HttpRequest || object instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf byteBuf, HttpMessage httpMessage) {
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            ByteBufUtil.copy((AsciiString)httpRequest.method().asciiName(), (ByteBuf)byteBuf);
            byteBuf.writeByte(32);
            byteBuf.writeCharSequence((CharSequence)httpRequest.uri(), CharsetUtil.UTF_8);
            byteBuf.writeByte(32);
            byteBuf.writeCharSequence((CharSequence)httpRequest.protocolVersion().toString(), CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE((ByteBuf)byteBuf, (int)3338);
        } else if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            byteBuf.writeCharSequence((CharSequence)httpResponse.protocolVersion().toString(), CharsetUtil.US_ASCII);
            byteBuf.writeByte(32);
            ByteBufUtil.copy((AsciiString)httpResponse.status().codeAsText(), (ByteBuf)byteBuf);
            byteBuf.writeByte(32);
            byteBuf.writeCharSequence((CharSequence)httpResponse.status().reasonPhrase(), CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE((ByteBuf)byteBuf, (int)3338);
        } else {
            throw new UnsupportedMessageTypeException((Object)httpMessage, new Class[]{HttpRequest.class, HttpResponse.class});
        }
    }
}

