/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.handler.codec.spdy.SpdyUnknownFrame;
import io.netty.util.internal.StringUtil;

public final class DefaultSpdyUnknownFrame
extends DefaultByteBufHolder
implements SpdyUnknownFrame {
    private final int frameType;
    private final byte flags;

    public DefaultSpdyUnknownFrame(int n, byte by, ByteBuf byteBuf) {
        super(byteBuf);
        this.frameType = n;
        this.flags = by;
    }

    @Override
    public int frameType() {
        return this.frameType;
    }

    @Override
    public byte flags() {
        return this.flags;
    }

    @Override
    public DefaultSpdyUnknownFrame copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public DefaultSpdyUnknownFrame duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public DefaultSpdyUnknownFrame retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public DefaultSpdyUnknownFrame replace(ByteBuf byteBuf) {
        return new DefaultSpdyUnknownFrame(this.frameType, this.flags, byteBuf);
    }

    @Override
    public DefaultSpdyUnknownFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public DefaultSpdyUnknownFrame retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public DefaultSpdyUnknownFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public DefaultSpdyUnknownFrame touch(Object object) {
        super.touch(object);
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultSpdyUnknownFrame)) {
            return false;
        }
        DefaultSpdyUnknownFrame defaultSpdyUnknownFrame = (DefaultSpdyUnknownFrame)object;
        return this.frameType == defaultSpdyUnknownFrame.frameType && this.flags == defaultSpdyUnknownFrame.flags && super.equals((Object)defaultSpdyUnknownFrame);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.frameType;
        n = 31 * n + this.flags;
        return n;
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(frameType=" + this.frameType + ", flags=" + this.flags + ", content=" + this.contentToString() + ')';
    }
}

