/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public class SpdyHttpResponseStreamIdHandler
extends MessageToMessageCodec<Object, HttpMessage> {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new ArrayDeque<Integer>();

    public boolean acceptInboundMessage(Object object) {
        return object instanceof HttpMessage || object instanceof SpdyRstStreamFrame;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, HttpMessage httpMessage, List<Object> list) {
        Integer n = this.ids.poll();
        if (n != null && n.intValue() != NO_ID.intValue() && !httpMessage.headers().contains((CharSequence)SpdyHttpHeaders.Names.STREAM_ID)) {
            httpMessage.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, n);
        }
        list.add(ReferenceCountUtil.retain((Object)httpMessage));
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) {
        if (object instanceof HttpMessage) {
            boolean bl = ((HttpMessage)object).headers().contains((CharSequence)SpdyHttpHeaders.Names.STREAM_ID);
            if (!bl) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(((HttpMessage)object).headers().getInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID));
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)object).streamId());
        }
        list.add(ReferenceCountUtil.retain((Object)object));
    }
}

