/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.JdkLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;

public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory;

    private static InternalLoggerFactory newDefaultFactory(String string) {
        InternalLoggerFactory internalLoggerFactory = InternalLoggerFactory.useSlf4JLoggerFactory(string);
        if (internalLoggerFactory != null) {
            return internalLoggerFactory;
        }
        internalLoggerFactory = InternalLoggerFactory.useLog4J2LoggerFactory(string);
        if (internalLoggerFactory != null) {
            return internalLoggerFactory;
        }
        internalLoggerFactory = InternalLoggerFactory.useLog4JLoggerFactory(string);
        if (internalLoggerFactory != null) {
            return internalLoggerFactory;
        }
        return InternalLoggerFactory.useJdkLoggerFactory(string);
    }

    private static InternalLoggerFactory useSlf4JLoggerFactory(String string) {
        try {
            InternalLoggerFactory internalLoggerFactory = Slf4JLoggerFactory.getInstanceWithNopCheck();
            internalLoggerFactory.newInstance(string).debug("Using SLF4J as the default logging framework");
            return internalLoggerFactory;
        }
        catch (LinkageError linkageError) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static InternalLoggerFactory useLog4J2LoggerFactory(String string) {
        try {
            InternalLoggerFactory internalLoggerFactory = Log4J2LoggerFactory.INSTANCE;
            internalLoggerFactory.newInstance(string).debug("Using Log4J2 as the default logging framework");
            return internalLoggerFactory;
        }
        catch (LinkageError linkageError) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static InternalLoggerFactory useLog4JLoggerFactory(String string) {
        try {
            InternalLoggerFactory internalLoggerFactory = Log4JLoggerFactory.INSTANCE;
            internalLoggerFactory.newInstance(string).debug("Using Log4J as the default logging framework");
            return internalLoggerFactory;
        }
        catch (LinkageError linkageError) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static InternalLoggerFactory useJdkLoggerFactory(String string) {
        InternalLoggerFactory internalLoggerFactory = JdkLoggerFactory.INSTANCE;
        internalLoggerFactory.newInstance(string).debug("Using java.util.logging as the default logging framework");
        return internalLoggerFactory;
    }

    public static InternalLoggerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = InternalLoggerFactory.newDefaultFactory(InternalLoggerFactory.class.getName());
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory internalLoggerFactory) {
        defaultFactory = ObjectUtil.checkNotNull(internalLoggerFactory, "defaultFactory");
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String string) {
        return InternalLoggerFactory.getDefaultFactory().newInstance(string);
    }

    protected abstract InternalLogger newInstance(String var1);
}

