/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractCollection;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010*\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b'\u0018\u0000  *\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004\u001d\u001e\u001f B\t\bD\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u0007H\u00a6\u0082\u0004\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0096\u0082\u0004J\u0017\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0080\u0004\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0080\u0004\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0096\u0080\u0004J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u000b\u001a\u00020\u0007H\u0096\u0080\u0004J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0096\u0080\u0004J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0082\u0004J\n\u0010\u001c\u001a\u00020\u0007H\u0096\u0080\u0004R\u0013\u0010\u0006\u001a\u00020\u0007X\u00a6\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lkotlin/collections/AbstractList;", "E", "Lkotlin/collections/AbstractCollection;", "", "<init>", "()V", "size", "", "getSize", "()I", "get", "index", "(I)Ljava/lang/Object;", "iterator", "", "indexOf", "element", "(Ljava/lang/Object;)I", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "equals", "", "other", "", "hashCode", "SubList", "IteratorImpl", "ListIteratorImpl", "Companion", "kotlin-stdlib"})
public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E>,
KMappedMarker {
    public static final Companion Companion = new Companion(null);
    private static final int maxArraySize = 0x7FFFFFF7;

    protected AbstractList() {
    }

    @Override
    public abstract int getSize();

    @Override
    public abstract E get(int var1);

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public int indexOf(Object object) {
        int n;
        block2: {
            List list = this;
            boolean bl = false;
            int n2 = 0;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object e;
                Object e2 = e = iterator2.next();
                boolean bl2 = false;
                if (Intrinsics.areEqual(e2, object)) {
                    n = n2;
                    break block2;
                }
                ++n2;
            }
            n = -1;
        }
        return n;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n;
        block1: {
            List list = this;
            boolean bl = false;
            ListIterator listIterator2 = list.listIterator(list.size());
            while (listIterator2.hasPrevious()) {
                Object e = listIterator2.previous();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(e, object)) continue;
                n = listIterator2.nextIndex();
                break block1;
            }
            n = -1;
        }
        return n;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIteratorImpl(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new ListIteratorImpl(n);
    }

    @Override
    public List<E> subList(int n, int n2) {
        return new SubList(this, n, n2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        return Companion.orderedEquals$kotlin_stdlib(this, (Collection)object);
    }

    @Override
    public int hashCode() {
        return Companion.orderedHashCode$kotlin_stdlib(this);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public E remove(int n) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\bB\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0080\u0080\u0004\u00a2\u0006\u0002\b\tJ\u001f\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0080\u0080\u0004\u00a2\u0006\u0002\b\u000bJ'\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0080\u0080\u0004\u00a2\u0006\u0002\b\u000fJ'\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0080\u0080\u0004\u00a2\u0006\u0002\b\u0013J\u001f\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0080\u0080\u0004\u00a2\u0006\u0002\b\u0018J\u001b\u0010\u0019\u001a\u00020\u00072\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0080\u0080\u0004\u00a2\u0006\u0002\b\u001cJ'\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0080\u0080\u0004\u00a2\u0006\u0002\b R\u000f\u0010\u0014\u001a\u00020\u0007X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lkotlin/collections/AbstractList$Companion;", "", "<init>", "()V", "checkElementIndex", "", "index", "", "size", "checkElementIndex$kotlin_stdlib", "checkPositionIndex", "checkPositionIndex$kotlin_stdlib", "checkRangeIndexes", "fromIndex", "toIndex", "checkRangeIndexes$kotlin_stdlib", "checkBoundsIndexes", "startIndex", "endIndex", "checkBoundsIndexes$kotlin_stdlib", "maxArraySize", "newCapacity", "oldCapacity", "minCapacity", "newCapacity$kotlin_stdlib", "orderedHashCode", "c", "", "orderedHashCode$kotlin_stdlib", "orderedEquals", "", "other", "orderedEquals$kotlin_stdlib", "kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkElementIndex$kotlin_stdlib(int n, int n2) {
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException("index: " + n + ", size: " + n2);
            }
        }

        public final void checkPositionIndex$kotlin_stdlib(int n, int n2) {
            if (n < 0 || n > n2) {
                throw new IndexOutOfBoundsException("index: " + n + ", size: " + n2);
            }
        }

        public final void checkRangeIndexes$kotlin_stdlib(int n, int n2, int n3) {
            if (n < 0 || n2 > n3) {
                throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + ", size: " + n3);
            }
            if (n > n2) {
                throw new IllegalArgumentException("fromIndex: " + n + " > toIndex: " + n2);
            }
        }

        public final void checkBoundsIndexes$kotlin_stdlib(int n, int n2, int n3) {
            if (n < 0 || n2 > n3) {
                throw new IndexOutOfBoundsException("startIndex: " + n + ", endIndex: " + n2 + ", size: " + n3);
            }
            if (n > n2) {
                throw new IllegalArgumentException("startIndex: " + n + " > endIndex: " + n2);
            }
        }

        public final int newCapacity$kotlin_stdlib(int n, int n2) {
            int n3 = n + (n >> 1);
            if (n3 - n2 < 0) {
                n3 = n2;
            }
            if (n3 - 0x7FFFFFF7 > 0) {
                n3 = n2 > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
            }
            return n3;
        }

        public final int orderedHashCode$kotlin_stdlib(Collection<?> collection) {
            Intrinsics.checkNotNullParameter(collection, "");
            int n = 1;
            Iterator<?> iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Object obj;
                Object obj2 = obj = iterator2.next();
                n = 31 * n + (obj2 != null ? obj2.hashCode() : 0);
            }
            return n;
        }

        public final boolean orderedEquals$kotlin_stdlib(Collection<?> collection, Collection<?> collection2) {
            Intrinsics.checkNotNullParameter(collection, "");
            Intrinsics.checkNotNullParameter(collection2, "");
            if (collection.size() != collection2.size()) {
                return false;
            }
            Iterator<?> iterator2 = collection2.iterator();
            for (Object obj : collection) {
                Object obj2;
                if (Intrinsics.areEqual(obj, obj2 = iterator2.next())) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0092\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\t\bF\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\n\u001a\u00020\u000bH\u0096\u0082\u0004J\u000f\u0010\f\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\rR\u001b\u0010\u0004\u001a\u00020\u0005X\u0084\u008e\b\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lkotlin/collections/AbstractList$IteratorImpl;", "", "<init>", "(Lkotlin/collections/AbstractList;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "hasNext", "", "next", "()Ljava/lang/Object;", "kotlin-stdlib"})
    private class IteratorImpl
    implements Iterator<E>,
    KMappedMarker {
        private int index;

        protected final int getIndex() {
            return this.index;
        }

        protected final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractList.this.size();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.index;
            this.index = n + 1;
            return AbstractList.this.get(n);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010*\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0092\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0011\bF\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004J\n\u0010\n\u001a\u00020\u0005H\u0096\u0080\u0004J\u000f\u0010\u000b\u001a\u00028\u0000H\u0096\u0080\u0004\u00a2\u0006\u0002\u0010\fJ\n\u0010\r\u001a\u00020\u0005H\u0096\u0080\u0004\u00a8\u0006\u000e"}, d2={"Lkotlin/collections/AbstractList$ListIteratorImpl;", "Lkotlin/collections/AbstractList$IteratorImpl;", "Lkotlin/collections/AbstractList;", "", "index", "", "<init>", "(Lkotlin/collections/AbstractList;I)V", "hasPrevious", "", "nextIndex", "previous", "()Ljava/lang/Object;", "previousIndex", "kotlin-stdlib"})
    private class ListIteratorImpl
    extends IteratorImpl
    implements ListIterator<E>,
    KMappedMarker {
        public ListIteratorImpl(int n) {
            Companion.checkPositionIndex$kotlin_stdlib(n, AbstractList.this.size());
            this.setIndex(n);
        }

        @Override
        public boolean hasPrevious() {
            return this.getIndex() > 0;
        }

        @Override
        public int nextIndex() {
            return this.getIndex();
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.setIndex(this.getIndex() + -1);
            return AbstractList.this.get(this.getIndex());
        }

        @Override
        public int previousIndex() {
            return this.getIndex() - 1;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00060\u0003j\u0002`\u0004B'\bF\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u0007H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u000eJ \u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0096\u0080\u0004R\u0015\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0006\u001a\u00020\u0007X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u000b\u001a\u00020\u0007X\u0082\u008e\b\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000f\u001a\u00020\u00078VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lkotlin/collections/AbstractList$SubList;", "E", "Lkotlin/collections/AbstractList;", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "list", "fromIndex", "", "toIndex", "<init>", "(Lkotlin/collections/AbstractList;II)V", "_size", "get", "index", "(I)Ljava/lang/Object;", "size", "getSize", "()I", "subList", "", "kotlin-stdlib"})
    private static final class SubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final AbstractList<E> list;
        private final int fromIndex;
        private int _size;

        public SubList(AbstractList<? extends E> abstractList, int n, int n2) {
            Intrinsics.checkNotNullParameter(abstractList, "");
            this.list = abstractList;
            this.fromIndex = n;
            Companion.checkRangeIndexes$kotlin_stdlib(this.fromIndex, n2, this.list.size());
            this._size = n2 - this.fromIndex;
        }

        @Override
        public E get(int n) {
            Companion.checkElementIndex$kotlin_stdlib(n, this._size);
            return this.list.get(this.fromIndex + n);
        }

        @Override
        public int getSize() {
            return this._size;
        }

        @Override
        public List<E> subList(int n, int n2) {
            Companion.checkRangeIndexes$kotlin_stdlib(n, n2, this._size);
            return new SubList<E>(this.list, this.fromIndex + n, this.fromIndex + n2);
        }
    }
}

