/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Comparator;
import kotlin.Deprecated;
import kotlin.DeprecatedSinceKotlin;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.UByteArray;
import kotlin.ULong;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Instant;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidKt__UuidKt;
import kotlin.uuid.UuidV7Generator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00000\u00012\u00060\u0002j\u0002`\u0003:\u00010B\u0019\bB\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ]\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u001026\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u0002H\u00100\u0012H\u0087\u0088\u0004\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0015J]\u0010\u0016\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u001026\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u0002H\u00100\u0012H\u0087\u0088\u0004\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0015J\n\u0010\u0018\u001a\u00020\u0019H\u0096\u0080\u0004J\n\u0010\u001a\u001a\u00020\u0019H\u0087\u0080\u0004J\n\u0010\u001b\u001a\u00020\u0019H\u0086\u0080\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u0086\u0080\u0004J\u0011\u0010\u001e\u001a\u00020\u001fH\u0087\u0080\u0004\u00a2\u0006\u0004\b \u0010!J\u0014\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0082\u0004J\u0012\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0000H\u0097\u0082\u0004J\n\u0010(\u001a\u00020'H\u0096\u0080\u0004J\n\u0010)\u001a\u00020%H\u0082\u0080\u0004J\u001b\u0010*\u001a\u00020+2\n\u0010,\u001a\u00060-j\u0002`.H\u0082\u0080\u0004\u00a2\u0006\u0002\u0010/R\u001d\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0084\b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u00020\u00058\u0000X\u0081\u0084\b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Lkotlin/uuid/Uuid;", "", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "mostSignificantBits", "", "leastSignificantBits", "<init>", "(JJ)V", "getMostSignificantBits$annotations", "()V", "getMostSignificantBits", "()J", "getLeastSignificantBits$annotations", "getLeastSignificantBits", "toLongs", "T", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "toULongs", "Lkotlin/ULong;", "toString", "", "toHexDashString", "toHexString", "toByteArray", "", "toUByteArray", "Lkotlin/UByteArray;", "toUByteArray-TcUX1vc", "()[B", "equals", "", "other", "", "compareTo", "", "hashCode", "writeReplace", "readObject", "", "input", "Ljava/io/ObjectInputStream;", "Lkotlin/internal/ReadObjectParameterType;", "(Ljava/io/ObjectInputStream;)V", "Companion", "kotlin-stdlib"})
public final class Uuid
implements Serializable,
Comparable<Uuid> {
    public static final Companion Companion = new Companion(null);
    private final long mostSignificantBits;
    private final long leastSignificantBits;
    private static final Uuid NIL = new Uuid(0L, 0L);
    public static final int SIZE_BYTES = 16;
    public static final int SIZE_BITS = 128;

    private Uuid(long l, long l2) {
        this.mostSignificantBits = l;
        this.leastSignificantBits = l2;
    }

    public final long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    public static /* synthetic */ void getMostSignificantBits$annotations() {
    }

    public final long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    public static /* synthetic */ void getLeastSignificantBits$annotations() {
    }

    private final <T> T toLongs(Function2<? super Long, ? super Long, ? extends T> function2) {
        Intrinsics.checkNotNullParameter(function2, "");
        return function2.invoke(this.getMostSignificantBits(), this.getLeastSignificantBits());
    }

    private final <T> T toULongs(Function2<? super ULong, ? super ULong, ? extends T> function2) {
        Intrinsics.checkNotNullParameter(function2, "");
        return function2.invoke(ULong.box-impl(ULong.constructor-impl(this.getMostSignificantBits())), ULong.box-impl(ULong.constructor-impl(this.getLeastSignificantBits())));
    }

    public String toString() {
        return this.toHexDashString();
    }

    public final String toHexDashString() {
        byte[] byArray = new byte[36];
        UuidKt.formatBytesInto(this.mostSignificantBits, byArray, 0, 0, 4);
        byArray[8] = 45;
        UuidKt.formatBytesInto(this.mostSignificantBits, byArray, 9, 4, 6);
        byArray[13] = 45;
        UuidKt.formatBytesInto(this.mostSignificantBits, byArray, 14, 6, 8);
        byArray[18] = 45;
        UuidKt.formatBytesInto(this.leastSignificantBits, byArray, 19, 0, 2);
        byArray[23] = 45;
        UuidKt.formatBytesInto(this.leastSignificantBits, byArray, 24, 2, 8);
        return StringsKt.decodeToString(byArray);
    }

    public final String toHexString() {
        byte[] byArray = new byte[32];
        UuidKt.formatBytesInto(this.mostSignificantBits, byArray, 0, 0, 8);
        UuidKt.formatBytesInto(this.leastSignificantBits, byArray, 16, 0, 8);
        return StringsKt.decodeToString(byArray);
    }

    public final byte[] toByteArray() {
        byte[] byArray = new byte[16];
        UuidKt.setLongAt(byArray, 0, this.mostSignificantBits);
        UuidKt.setLongAt(byArray, 8, this.leastSignificantBits);
        return byArray;
    }

    public final byte[] toUByteArray-TcUX1vc() {
        return UByteArray.constructor-impl(this.toByteArray());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Uuid)) {
            return false;
        }
        return this.mostSignificantBits == ((Uuid)object).mostSignificantBits && this.leastSignificantBits == ((Uuid)object).leastSignificantBits;
    }

    @Override
    public int compareTo(Uuid uuid) {
        Intrinsics.checkNotNullParameter(uuid, "");
        return this.mostSignificantBits != uuid.mostSignificantBits ? Long.compareUnsigned(ULong.constructor-impl(this.mostSignificantBits), ULong.constructor-impl(uuid.mostSignificantBits)) : Long.compareUnsigned(ULong.constructor-impl(this.leastSignificantBits), ULong.constructor-impl(uuid.leastSignificantBits));
    }

    public int hashCode() {
        return Long.hashCode(this.mostSignificantBits ^ this.leastSignificantBits);
    }

    private final Object writeReplace() {
        return UuidKt.serializedUuid(this);
    }

    private final void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Deserialization is supported via proxy only");
    }

    public /* synthetic */ Uuid(long l, long l2, DefaultConstructorMarker defaultConstructorMarker) {
        this(l, l2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\bB\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0086\u0080\u0004J!\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0010H\u0086\u0080\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0012\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0080\u0004J\u0019\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0087\u0080\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0080\u0004J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0087\u0080\u0004J\u0012\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001dH\u0087\u0080\u0004J\u0014\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u001dH\u0087\u0080\u0004J\u0012\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u001dH\u0086\u0080\u0004J\u0014\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u001dH\u0087\u0080\u0004J\n\u0010%\u001a\u00020\u0005H\u0086\u0080\u0004J\n\u0010&\u001a\u00020\u0005H\u0087\u0080\u0004J\n\u0010'\u001a\u00020\u0005H\u0087\u0080\u0004J\u0012\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0087\u0080\u0004J\u0017\u0010'\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,H\u0080\u0080\u0004\u00a2\u0006\u0002\b-R\u0015\u0010\u0004\u001a\u00020\u0005X\u0086\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000f\u0010\b\u001a\u00020\tX\u0086\u00d4\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\n\u001a\u00020\tX\u0086\u00d4\b\u00a2\u0006\u0002\n\u0000R+\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\u00050/j\b\u0012\u0004\u0012\u00020\u0005`08FX\u0087\u0084\b\u00a2\u0006\f\u0012\u0004\b1\u0010\u0003\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lkotlin/uuid/Uuid$Companion;", "", "<init>", "()V", "NIL", "Lkotlin/uuid/Uuid;", "getNIL", "()Lkotlin/uuid/Uuid;", "SIZE_BYTES", "", "SIZE_BITS", "fromLongs", "mostSignificantBits", "", "leastSignificantBits", "fromULongs", "Lkotlin/ULong;", "fromULongs-eb3DHEI", "(JJ)Lkotlin/uuid/Uuid;", "fromByteArray", "byteArray", "", "fromUByteArray", "ubyteArray", "Lkotlin/UByteArray;", "fromUByteArray-GBYM_sE", "([B)Lkotlin/uuid/Uuid;", "parse", "uuidString", "", "parseOrNull", "parseHexDash", "hexDashString", "parseHexDashOrNull", "parseHex", "hexString", "parseHexOrNull", "random", "generateV4", "generateV7", "generateV7NonMonotonicAt", "timestamp", "Lkotlin/time/Instant;", "clock", "Lkotlin/time/Clock;", "generateV7$kotlin_stdlib", "LEXICAL_ORDER", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getLEXICAL_ORDER$annotations", "getLEXICAL_ORDER", "()Ljava/util/Comparator;", "kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        public final Uuid getNIL() {
            return NIL;
        }

        public final Uuid fromLongs(long l, long l2) {
            return l == 0L && l2 == 0L ? this.getNIL() : new Uuid(l, l2, null);
        }

        public final Uuid fromULongs-eb3DHEI(long l, long l2) {
            return this.fromLongs(l, l2);
        }

        public final Uuid fromByteArray(byte[] byArray) {
            Intrinsics.checkNotNullParameter(byArray, "");
            if (!(byArray.length == 16)) {
                boolean bl = false;
                String string = "Expected exactly 16 bytes, but was " + UuidKt__UuidKt.access$truncateForErrorMessage(byArray, 32) + " of size " + byArray.length;
                throw new IllegalArgumentException(string.toString());
            }
            return this.fromLongs(UuidKt.getLongAt(byArray, 0), UuidKt.getLongAt(byArray, 8));
        }

        public final Uuid fromUByteArray-GBYM_sE(byte[] byArray) {
            Intrinsics.checkNotNullParameter(byArray, "");
            return this.fromByteArray(byArray);
        }

        public final Uuid parse(String string) {
            Uuid uuid;
            Intrinsics.checkNotNullParameter(string, "");
            switch (string.length()) {
                case 36: {
                    uuid = UuidKt.uuidParseHexDash(string);
                    break;
                }
                case 32: {
                    uuid = UuidKt.uuidParseHex(string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Expected either a 36-char string in the standard hex-and-dash UUID format or a 32-char hexadecimal string, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(string, 64) + "\" of length " + string.length());
                }
            }
            return uuid;
        }

        public final Uuid parseOrNull(String string) {
            Uuid uuid;
            Intrinsics.checkNotNullParameter(string, "");
            switch (string.length()) {
                case 36: {
                    uuid = this.parseHexDashOrNull(string);
                    break;
                }
                case 32: {
                    uuid = this.parseHexOrNull(string);
                    break;
                }
                default: {
                    uuid = null;
                }
            }
            return uuid;
        }

        public final Uuid parseHexDash(String string) {
            Intrinsics.checkNotNullParameter(string, "");
            if (!(string.length() == 36)) {
                boolean bl = false;
                String string2 = "Expected a 36-char string in the standard hex-and-dash UUID format, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(string, 64) + "\" of length " + string.length();
                throw new IllegalArgumentException(string2.toString());
            }
            return UuidKt.uuidParseHexDash(string);
        }

        public final Uuid parseHexDashOrNull(String string) {
            Intrinsics.checkNotNullParameter(string, "");
            if (string.length() != 36) {
                return null;
            }
            return UuidKt.uuidParseHexDashOrNull(string);
        }

        public final Uuid parseHex(String string) {
            Intrinsics.checkNotNullParameter(string, "");
            if (!(string.length() == 32)) {
                boolean bl = false;
                String string2 = "Expected a 32-char hexadecimal string, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(string, 64) + "\" of length " + string.length();
                throw new IllegalArgumentException(string2.toString());
            }
            return UuidKt.uuidParseHex(string);
        }

        public final Uuid parseHexOrNull(String string) {
            Intrinsics.checkNotNullParameter(string, "");
            if (string.length() != 32) {
                return null;
            }
            return UuidKt.uuidParseHexOrNull(string);
        }

        public final Uuid random() {
            return this.generateV4();
        }

        public final Uuid generateV4() {
            return UuidKt.secureRandomUuid();
        }

        public final Uuid generateV7() {
            return this.generateV7$kotlin_stdlib(Clock.System.INSTANCE);
        }

        public final Uuid generateV7NonMonotonicAt(Instant instant) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter(instant, "");
            byte[] byArray2 = byArray = new byte[10];
            boolean bl = false;
            UuidKt.secureRandomBytes(byArray2);
            byte[] byArray3 = byArray;
            int n = (byArray3[8] & 0xF | 0x70) << 8 | byArray3[9] & 0xFF;
            long l = instant.toEpochMilliseconds() << 16 | (long)n;
            byArray3[0] = (byte)((byte)(byArray3[0] & 0x3F) | 0xFFFFFF80);
            long l2 = UuidKt.getLongAt(byArray3, 0);
            return this.fromLongs(l, l2);
        }

        public final Uuid generateV7$kotlin_stdlib(Clock clock) {
            Intrinsics.checkNotNullParameter(clock, "");
            return UuidV7Generator.INSTANCE.generate(clock);
        }

        public final Comparator<Uuid> getLEXICAL_ORDER() {
            return ComparisonsKt.naturalOrder();
        }

        @Deprecated(message="Use naturalOrder<Uuid>() instead", replaceWith=@ReplaceWith(expression="naturalOrder<Uuid>()", imports={"kotlin.comparisons.naturalOrder"}))
        @DeprecatedSinceKotlin(warningSince="2.1")
        public static /* synthetic */ void getLEXICAL_ORDER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

