/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.cache.disk;

import e.C;
import e.K;
import e.M;
import e.f;
import e.g;
import e.k;
import e.l;
import e.x;
import io.kamel.core.cache.disk.DiskLruCache;
import io.kamel.core.cache.disk.FaultHidingSink;
import io.kamel.core.utils.FileSystemKt;
import io.ktor.util.collections.ConcurrentMap;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.J;
import kotlinx.coroutines.aS;
import kotlinx.coroutines.aw;
import kotlinx.coroutines.i;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001%\b\u0001\u0018\u0000 G2\u00060\u0001j\u0002`\u00022\u00060\u0003j\u0002`\u0004:\u0004DEFGB;\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020\u001eH\u0002J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\u0017H\u0002J\b\u0010-\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020(H\u0002J\u0014\u0010/\u001a\b\u0018\u000100R\u00020\u00002\u0006\u00101\u001a\u00020\u0017J\u0014\u00102\u001a\b\u0018\u000103R\u00020\u00002\u0006\u00101\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\fJ\u001c\u00104\u001a\u00020(2\n\u00105\u001a\u000603R\u00020\u00002\u0006\u00106\u001a\u00020 H\u0002J\b\u00107\u001a\u00020 H\u0002J\u000e\u00108\u001a\u00020 2\u0006\u00101\u001a\u00020\u0017J\u0014\u00109\u001a\u00020 2\n\u0010:\u001a\u00060\u0018R\u00020\u0000H\u0002J\b\u0010;\u001a\u00020(H\u0002J\b\u0010<\u001a\u00020(H\u0016J\b\u0010=\u001a\u00020(H\u0002J\b\u0010>\u001a\u00020 H\u0002J\b\u0010?\u001a\u00020(H\u0002J\u0006\u0010@\u001a\u00020(J\b\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020(2\u0006\u00101\u001a\u00020\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\u0018R\u00020\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&\u00a8\u0006H"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "maxSize", "", "appVersion", "", "valueCount", "<init>", "(Lokio/FileSystem;Lokio/Path;Lkotlinx/coroutines/CoroutineDispatcher;JII)V", "journalFile", "journalFileTmp", "journalFileBackup", "lruEntries", "Lio/ktor/util/collections/ConcurrentMap;", "", "Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "cleanupScope", "Lkotlinx/coroutines/CoroutineScope;", "size", "operationsSinceRewrite", "journalWriter", "Lokio/BufferedSink;", "hasJournalErrors", "", "initialized", "closed", "mostRecentTrimFailed", "mostRecentRebuildFailed", "io/kamel/core/cache/disk/DiskLruCache$fileSystem$1", "Lio/kamel/core/cache/disk/DiskLruCache$fileSystem$1;", "initialize", "", "readJournal", "newJournalWriter", "readJournalLine", "line", "processJournal", "writeJournal", "get", "Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "key", "edit", "Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "completeEdit", "editor", "success", "journalRewriteRequired", "remove", "removeEntry", "entry", "checkNotClosed", "close", "trimToSize", "removeOldestEntry", "delete", "evictAll", "launchCleanup", "Lkotlinx/coroutines/Job;", "validateKey", "Snapshot", "Editor", "Entry", "Companion", "kamel-core"})
public final class DiskLruCache
implements AutoCloseable {
    public static final Companion Companion = new Companion(null);
    private final C directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    private final C journalFile;
    private final C journalFileTmp;
    private final C journalFileBackup;
    private final ConcurrentMap<String, Entry> lruEntries;
    private final CoroutineScope cleanupScope;
    private long size;
    private int operationsSinceRewrite;
    private f journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private final fileSystem.1 fileSystem;
    public static final int $stable = 8;
    public static final String JOURNAL_FILE = "journal";
    public static final String JOURNAL_FILE_TMP = "journal.tmp";
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    public static final String MAGIC = "libcore.io.DiskLruCache";
    public static final String VERSION = "1";
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");

    public DiskLruCache(k k2, C c, CoroutineDispatcher coroutineDispatcher, long l2, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)k2, (String)"");
        Intrinsics.checkNotNullParameter((Object)c, (String)"");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"");
        this.directory = c;
        this.maxSize = l2;
        this.appVersion = n;
        this.valueCount = n2;
        if (!(this.maxSize > 0L)) {
            boolean bl = false;
            String string = "maxSize <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.valueCount > 0)) {
            boolean bl = false;
            String string = "valueCount <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.journalFile = this.directory.a(JOURNAL_FILE);
        this.journalFileTmp = this.directory.a(JOURNAL_FILE_TMP);
        this.journalFileBackup = this.directory.a(JOURNAL_FILE_BACKUP);
        this.lruEntries = new ConcurrentMap(0, 1, null);
        this.cleanupScope = J.a((CoroutineContext)aS.a(null, (int)1, null).plus((CoroutineContext)coroutineDispatcher));
        this.fileSystem = new l(k2){

            public K sink(C c, boolean bl) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)c, (String)"");
                    C c2 = c.h();
                    if (c2 == null) break block0;
                    C c3 = c2;
                    boolean bl2 = false;
                    this.createDirectories(c3);
                }
                return super.sink(c, bl);
            }
        };
    }

    public /* synthetic */ DiskLruCache(k k2, C c, CoroutineDispatcher coroutineDispatcher, long l2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n = 1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 1;
        }
        this(k2, c, coroutineDispatcher, l2, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initialize() {
        DiskLruCache diskLruCache = this;
        boolean bl = false;
        boolean bl2 = false;
        DiskLruCache diskLruCache2 = diskLruCache;
        synchronized (diskLruCache2) {
            boolean bl3 = false;
            if (this.initialized) {
                return;
            }
            this.fileSystem.delete(this.journalFileTmp);
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
                }
            }
            if (this.fileSystem.exists(this.journalFile)) {
                try {
                    this.readJournal();
                    this.processJournal();
                    this.initialized = true;
                    return;
                }
                catch (IOException iOException) {
                    try {
                        this.delete();
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.writeJournal();
            this.initialized = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() {
        Unit unit;
        g g2;
        k k2 = (k)this.fileSystem;
        C c = this.journalFile;
        boolean bl = false;
        Closeable closeable = (Closeable)x.a((M)k2.source(c));
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            g2 = (g)closeable;
            boolean bl3 = false;
            g g3 = g2;
            boolean bl4 = false;
            String string = g3.t();
            String string2 = g3.t();
            String string3 = g3.t();
            String string4 = g3.t();
            String string5 = g3.t();
            if (!Intrinsics.areEqual((Object)MAGIC, (Object)string)) throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + "]");
            if (!Intrinsics.areEqual((Object)VERSION, (Object)string2)) throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + "]");
            if (!Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)string3)) throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + "]");
            if (!Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)string4)) throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + "]");
            if (((CharSequence)string5).length() > 0) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + "]");
            }
            int n = 0;
            try {
                while (true) {
                    this.readJournalLine(g3.t());
                    ++n;
                }
            }
            catch (EOFException eOFException) {
                this.operationsSinceRewrite = n - this.lruEntries.size();
                if (!g3.d()) {
                    this.writeJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                unit = Unit.INSTANCE;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                unit = null;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                block21: {
                    try {
                        Closeable closeable3 = closeable;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                            break block21;
                        }
                        ExceptionsKt.addSuppressed((Throwable)throwable, (Throwable)throwable5);
                    }
                }
            }
        }
        g2 = unit;
        Throwable throwable6 = throwable;
        if (throwable6 == null) return;
        throw throwable6;
    }

    private final f newJournalWriter() {
        K k2 = this.fileSystem.appendingSink(this.journalFile);
        FaultHidingSink faultHidingSink = new FaultHidingSink(k2, (Function1<? super IOException, Unit>)((Function1)arg_0 -> DiskLruCache.newJournalWriter$lambda$0(this, arg_0)));
        return x.a((K)faultHidingSink);
    }

    private final void readJournalLine(String string) {
        Object object;
        int n = StringsKt.indexOf$default((CharSequence)string, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (n == -1) {
            throw new IOException("unexpected journal line: " + string);
        }
        int n2 = n + 1;
        int n3 = StringsKt.indexOf$default((CharSequence)string, (char)' ', (int)n2, (boolean)false, (int)4, null);
        String string2 = null;
        if (n3 == -1) {
            String string3 = string.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            string2 = string3;
            if (n == 6 && StringsKt.startsWith$default((String)string, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove((Object)string2);
                return;
            }
        } else {
            String string4 = string.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            string2 = string4;
        }
        Object object2 = (Map)this.lruEntries;
        Object object3 = string2;
        boolean bl = false;
        Object v = object2.get(object3);
        if (v == null) {
            boolean bl2 = false;
            Entry entry = new Entry(string2);
            object2.put(object3, entry);
            object = entry;
        } else {
            object = v;
        }
        Entry entry = (Entry)object;
        if (n3 != -1 && n == 5 && StringsKt.startsWith$default((String)string, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string5 = string.substring(n3 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
            object3 = new char[1];
            object3[0] = 32;
            object2 = StringsKt.split$default((CharSequence)string5, (char[])object3, (boolean)false, (int)0, (int)6, null);
            entry.setReadable(true);
            entry.setCurrentEditor(null);
            entry.setLengths((List<String>)object2);
        } else if (n3 == -1 && n == 5 && StringsKt.startsWith$default((String)string, (String)DIRTY, (boolean)false, (int)2, null)) {
            entry.setCurrentEditor(new Editor(entry));
        } else if (n3 != -1 || n != 4 || !StringsKt.startsWith$default((String)string, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException("unexpected journal line: " + string);
        }
    }

    private final void processJournal() {
        long l2 = 0L;
        Iterator iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            Entry entry = (Entry)iterator.next();
            if (entry.getCurrentEditor() == null) {
                n2 = this.valueCount;
                for (n = 0; n < n2; ++n) {
                    l2 += entry.getLengths()[n];
                }
                continue;
            }
            entry.setCurrentEditor(null);
            n2 = this.valueCount;
            for (n = 0; n < n2; ++n) {
                C c = entry.getCleanFiles().get(n);
                Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                this.fileSystem.delete(c);
                C c2 = entry.getDirtyFiles().get(n);
                Intrinsics.checkNotNullExpressionValue((Object)c2, (String)"");
                this.fileSystem.delete(c2);
            }
            iterator.remove();
        }
        this.size = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeJournal() {
        DiskLruCache diskLruCache = this;
        boolean bl = false;
        boolean bl2 = false;
        DiskLruCache diskLruCache2 = diskLruCache;
        synchronized (diskLruCache2) {
            Unit bl7;
            f f2;
            Throwable throwable;
            block22: {
                boolean bl3 = false;
                f f3 = this.journalWriter;
                if (f3 != null) {
                    f3.close();
                }
                k k2 = (k)this.fileSystem;
                C c = this.journalFileTmp;
                boolean bl4 = false;
                boolean bl5 = false;
                Closeable closeable = (Closeable)x.a((K)k2.sink(c, bl4));
                boolean bl6 = false;
                throwable = null;
                try {
                    f2 = (f)closeable;
                    boolean bl8 = false;
                    f f4 = f2;
                    boolean bl9 = false;
                    f4.b(MAGIC).h(10);
                    f4.b(VERSION).h(10);
                    f4.n((long)this.appVersion).h(10);
                    f4.n((long)this.valueCount).h(10);
                    f4.h(10);
                    for (Entry entry : this.lruEntries.values()) {
                        f f5;
                        if (entry.getCurrentEditor() != null) {
                            f4.b(DIRTY);
                            f4.h(32);
                            f4.b(entry.getKey());
                            f5 = f4.h(10);
                            continue;
                        }
                        f4.b(CLEAN);
                        f4.h(32);
                        f4.b(entry.getKey());
                        entry.writeLengths(f4);
                        f5 = f4.h(10);
                    }
                    bl7 = Unit.INSTANCE;
                }
                catch (Throwable f4) {
                    try {
                        throwable = f4;
                        bl7 = null;
                        break block22;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        block23: {
                            try {
                                Closeable closeable2 = closeable;
                                if (closeable2 != null) {
                                    closeable2.close();
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                    break block23;
                                }
                                ExceptionsKt.addSuppressed((Throwable)throwable, (Throwable)throwable2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            f2 = bl7;
            Throwable throwable3 = throwable;
            if (throwable3 != null) {
                throw throwable3;
            }
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            }
            this.journalWriter = this.newJournalWriter();
            this.operationsSinceRewrite = 0;
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Snapshot get(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        DiskLruCache diskLruCache = this;
        boolean bl = false;
        boolean bl2 = false;
        DiskLruCache diskLruCache2 = diskLruCache;
        synchronized (diskLruCache2) {
            f f2;
            Object object;
            block5: {
                boolean bl3 = false;
                this.checkNotClosed();
                this.validateKey(string);
                this.initialize();
                object = (Entry)this.lruEntries.get((Object)string);
                if (object != null && (object = ((Entry)object).snapshot()) != null) break block5;
                Snapshot snapshot = null;
                return snapshot;
            }
            Object object2 = object;
            int n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            f f3 = this.journalWriter;
            Intrinsics.checkNotNull((Object)f3);
            f f4 = f2 = f3;
            boolean bl4 = false;
            f4.b(READ);
            f4.h(32);
            f4.b(string);
            f4.h(10);
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            Object object3 = object2;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Editor edit(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        DiskLruCache diskLruCache = this;
        boolean bl = false;
        boolean bl2 = false;
        DiskLruCache diskLruCache2 = diskLruCache;
        synchronized (diskLruCache2) {
            Object object;
            Entry entry;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            boolean bl3 = false;
                            this.checkNotClosed();
                            this.validateKey(string);
                            this.initialize();
                            Entry entry2 = entry = (Entry)this.lruEntries.get((Object)string);
                            if ((entry2 != null ? entry2.getCurrentEditor() : null) == null) break block8;
                            Editor editor = null;
                            return editor;
                        }
                        if (entry == null || entry.getLockingSnapshotCount() == 0) break block9;
                        Editor editor = null;
                        return editor;
                    }
                    if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) break block10;
                    this.launchCleanup();
                    Editor editor = null;
                    return editor;
                }
                f f2 = this.journalWriter;
                Intrinsics.checkNotNull((Object)f2);
                f f3 = object = f2;
                boolean bl4 = false;
                f3.b(DIRTY);
                f3.h(32);
                f3.b(string);
                f3.h(10);
                f3.flush();
                if (!this.hasJournalErrors) break block11;
                Editor editor = null;
                return editor;
            }
            if (entry == null) {
                entry = new Entry(string);
                ((Map)this.lruEntries).put(string, entry);
            }
            object = new Editor(entry);
            entry.setCurrentEditor((Editor)object);
            Object object2 = object;
            return object2;
        }
    }

    public final long size() {
        this.initialize();
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completeEdit(Editor editor, boolean bl) {
        DiskLruCache diskLruCache = this;
        boolean bl2 = false;
        boolean bl3 = false;
        DiskLruCache diskLruCache2 = diskLruCache;
        synchronized (diskLruCache2) {
            f f2;
            f f3;
            int n;
            int n2;
            boolean bl4 = false;
            Entry entry = editor.getEntry();
            if (!Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor)) {
                throw new IllegalStateException("Check failed.");
            }
            if (bl && !entry.getZombie()) {
                n2 = this.valueCount;
                for (n = 0; n < n2; ++n) {
                    if (!editor.getWritten()[n]) continue;
                    C c = entry.getDirtyFiles().get(n);
                    Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                    if (this.fileSystem.exists(c)) continue;
                    editor.abort();
                    return;
                }
                n2 = this.valueCount;
                for (n = 0; n < n2; ++n) {
                    long l2;
                    C c;
                    C c2;
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getDirtyFiles().get(n), (String)"");
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getCleanFiles().get(n), (String)"");
                    if (this.fileSystem.exists(c2)) {
                        this.fileSystem.atomicMove(c2, c);
                    } else {
                        k k2 = (k)this.fileSystem;
                        C c3 = entry.getCleanFiles().get(n);
                        Intrinsics.checkNotNullExpressionValue((Object)c3, (String)"");
                        FileSystemKt.createFile(k2, c3);
                    }
                    long l3 = entry.getLengths()[n];
                    Long l4 = this.fileSystem.metadata(c).c();
                    entry.getLengths()[n] = l2 = l4 != null ? l4 : 0L;
                    this.size = this.size - l3 + l2;
                }
            } else {
                n2 = this.valueCount;
                for (n = 0; n < n2; ++n) {
                    C c = entry.getDirtyFiles().get(n);
                    Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                    this.fileSystem.delete(c);
                }
            }
            entry.setCurrentEditor(null);
            if (entry.getZombie()) {
                this.removeEntry(entry);
                return;
            }
            n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            f f4 = this.journalWriter;
            Intrinsics.checkNotNull((Object)f4);
            f f5 = f3 = f4;
            boolean bl5 = false;
            if (bl || entry.getReadable()) {
                entry.setReadable(true);
                f5.b(CLEAN);
                f5.h(32);
                f5.b(entry.getKey());
                entry.writeLengths(f5);
                f2 = f5.h(10);
            } else {
                this.lruEntries.remove((Object)entry.getKey());
                f5.b(REMOVE);
                f5.h(32);
                f5.b(entry.getKey());
                f2 = f5.h(10);
            }
            f5.flush();
            if (this.size > this.maxSize || this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean journalRewriteRequired() {
        return this.operationsSinceRewrite >= 2000;
    }

    public final boolean remove(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.checkNotClosed();
        this.validateKey(string);
        this.initialize();
        Entry entry = (Entry)this.lruEntries.get((Object)string);
        if (entry == null) {
            return false;
        }
        Entry entry2 = entry;
        boolean bl = this.removeEntry(entry2);
        if (bl && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeEntry(Entry entry) {
        DiskLruCache diskLruCache = this;
        boolean bl = false;
        boolean bl2 = false;
        DiskLruCache diskLruCache2 = diskLruCache;
        synchronized (diskLruCache2) {
            int n;
            boolean bl3;
            f f2;
            block9: {
                boolean bl4 = false;
                if (entry.getLockingSnapshotCount() > 0) {
                    f f3 = this.journalWriter;
                    if (f3 != null) {
                        f f4;
                        f2 = f4 = f3;
                        bl3 = false;
                        f2.b(DIRTY);
                        f2.h(32);
                        f2.b(entry.getKey());
                        f2.h(10);
                        f2.flush();
                    }
                }
                if (entry.getLockingSnapshotCount() <= 0 && entry.getCurrentEditor() == null) break block9;
                entry.setZombie(true);
                boolean bl5 = true;
                return bl5;
            }
            int n2 = this.valueCount;
            for (n = 0; n < n2; ++n) {
                C c = entry.getCleanFiles().get(n);
                Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                this.fileSystem.delete(c);
                this.size -= entry.getLengths()[n];
                entry.getLengths()[n] = 0L;
            }
            n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            f f5 = this.journalWriter;
            if (f5 != null) {
                f f6;
                f2 = f6 = f5;
                bl3 = false;
                f2.b(REMOVE);
                f2.h(32);
                f2.b(entry.getKey());
                f2.h(10);
            }
            this.lruEntries.remove((Object)entry.getKey());
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            boolean bl6 = true;
            return bl6;
        }
    }

    private final void checkNotClosed() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DiskLruCache diskLruCache = this;
        boolean bl = false;
        boolean bl2 = false;
        DiskLruCache diskLruCache2 = diskLruCache;
        synchronized (diskLruCache2) {
            boolean bl3 = false;
            if (!this.initialized || this.closed) {
                this.closed = true;
            } else {
                Collection collection = this.lruEntries.values();
                int n = 0;
                Collection object2 = collection;
                for (Entry entry : object2.toArray(new Entry[0])) {
                    Editor editor = entry.getCurrentEditor();
                    if (editor == null) continue;
                    editor.detach();
                }
                this.trimToSize();
                J.a((CoroutineScope)this.cleanupScope, null, (int)1, null);
                f f2 = this.journalWriter;
                Intrinsics.checkNotNull((Object)f2);
                f2.close();
                this.journalWriter = null;
                this.closed = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        for (Entry entry : this.lruEntries.values()) {
            if (entry.getZombie()) continue;
            this.removeEntry(entry);
            return true;
        }
        return false;
    }

    private final void delete() {
        this.close();
        FileSystemKt.deleteContents((k)this.fileSystem, this.directory);
    }

    public final void evictAll() {
        this.initialize();
        Collection collection = this.lruEntries.values();
        int n = 0;
        Collection object2 = collection;
        for (Entry entry : object2.toArray(new Entry[0])) {
            this.removeEntry(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final aw launchCleanup() {
        aw aw2;
        DiskLruCache diskLruCache = this;
        boolean bl = false;
        boolean bl2 = false;
        DiskLruCache diskLruCache2 = diskLruCache;
        synchronized (diskLruCache2) {
            boolean bl3 = false;
            aw2 = i.a((CoroutineScope)this.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DiskLruCache this$0;
                {
                    this.this$0 = diskLruCache;
                    super(2, continuation);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (!DiskLruCache.access$getInitialized$p(this.this$0) || DiskLruCache.access$getClosed$p(this.this$0)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(this.this$0);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(this.this$0, true);
                            }
                            try {
                                if (DiskLruCache.access$journalRewriteRequired(this.this$0)) {
                                    DiskLruCache.access$writeJournal(this.this$0);
                                }
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(this.this$0, true);
                                DiskLruCache.access$setJournalWriter$p(this.this$0, x.a((K)x.a()));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                    return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return aw2;
    }

    private final void validateKey(String string) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)string)) {
            boolean bl = false;
            String string2 = "keys must match regex [a-z0-9_-]{1,120}: \"" + string + "\"";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private static final Unit newJournalWriter$lambda$0(DiskLruCache diskLruCache, IOException iOException) {
        Intrinsics.checkNotNullParameter((Object)iOException, (String)"");
        diskLruCache.hasJournalErrors = true;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache diskLruCache) {
        return diskLruCache.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache diskLruCache) {
        return diskLruCache.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache diskLruCache) {
        diskLruCache.trimToSize();
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache diskLruCache, boolean bl) {
        diskLruCache.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRewriteRequired(DiskLruCache diskLruCache) {
        return diskLruCache.journalRewriteRequired();
    }

    public static final /* synthetic */ void access$writeJournal(DiskLruCache diskLruCache) {
        diskLruCache.writeJournal();
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache diskLruCache, boolean bl) {
        diskLruCache.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache diskLruCache, f f2) {
        diskLruCache.journalWriter = f2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Companion;", "", "<init>", "()V", "JOURNAL_FILE", "", "JOURNAL_FILE_TMP", "JOURNAL_FILE_BACKUP", "MAGIC", "VERSION", "CLEAN", "DIRTY", "REMOVE", "READ", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "kamel-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\f\u0010\u0017\u001a\b\u0018\u00010\u0018R\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "entry", "Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "Lio/kamel/core/cache/disk/DiskLruCache;", "<init>", "(Lio/kamel/core/cache/disk/DiskLruCache;Lio/kamel/core/cache/disk/DiskLruCache$Entry;)V", "getEntry", "()Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "closed", "", "written", "", "getWritten", "()[Z", "file", "Lokio/Path;", "index", "", "detach", "", "commit", "commitAndGet", "Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "abort", "complete", "success", "kamel-core"})
    public final class Editor {
        private final Entry entry;
        private boolean closed;
        private final boolean[] written;

        public Editor(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            this.entry = entry;
            this.written = new boolean[DiskLruCache.this.valueCount];
        }

        public final Entry getEntry() {
            return this.entry;
        }

        public final boolean[] getWritten() {
            return this.written;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final C file(int n) {
            Editor editor = this;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            Editor editor2 = editor;
            synchronized (editor2) {
                boolean bl3 = false;
                if (!(!this.closed)) {
                    boolean bl4 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                this.written[n] = true;
                C c = this.entry.getDirtyFiles().get(n);
                Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                C c2 = c;
                fileSystem.1 var8_10 = diskLruCache.fileSystem;
                C c3 = c2;
                boolean bl5 = false;
                FileSystemKt.createFile((k)var8_10, c3);
                C c4 = c2;
                return c4;
            }
        }

        public final C file() {
            return this.file(0);
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Snapshot commitAndGet() {
            Editor editor = this;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            Editor editor2 = editor;
            synchronized (editor2) {
                boolean bl3 = false;
                this.commit();
                Snapshot snapshot = diskLruCache.get(this.entry.getKey());
                return snapshot;
            }
        }

        public final void abort() {
            this.complete(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void complete(boolean bl) {
            Editor editor = this;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl2 = false;
            boolean bl3 = false;
            Editor editor2 = editor;
            synchronized (editor2) {
                boolean bl4 = false;
                if (!(!this.closed)) {
                    boolean bl5 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    diskLruCache.completeEdit(this, bl);
                }
                this.closed = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-J\u000e\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200J\f\u00101\u001a\b\u0018\u000102R\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R \u0010\u001d\u001a\b\u0018\u00010\u001eR\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00063"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "", "key", "", "<init>", "(Lio/kamel/core/cache/disk/DiskLruCache;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "cleanFiles", "Ljava/util/ArrayList;", "Lokio/Path;", "Lkotlin/collections/ArrayList;", "getCleanFiles", "()Ljava/util/ArrayList;", "dirtyFiles", "getDirtyFiles", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "zombie", "getZombie", "setZombie", "currentEditor", "Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "Lio/kamel/core/cache/disk/DiskLruCache;", "getCurrentEditor", "()Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "setCurrentEditor", "(Lio/kamel/core/cache/disk/DiskLruCache$Editor;)V", "lockingSnapshotCount", "", "getLockingSnapshotCount", "()I", "setLockingSnapshotCount", "(I)V", "setLengths", "", "strings", "", "writeLengths", "writer", "Lokio/BufferedSink;", "snapshot", "Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "kamel-core"})
    public final class Entry {
        private final String key;
        private final long[] lengths;
        private final ArrayList<C> cleanFiles;
        private final ArrayList<C> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            this.key = string;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            StringBuilder stringBuilder = new StringBuilder(this.key).append('.');
            int n = stringBuilder.length();
            int n2 = DiskLruCache.this.valueCount;
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(i);
                Collection collection = this.cleanFiles;
                C c = DiskLruCache.this.directory;
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                collection.add(c.a(string2));
                stringBuilder.append(".tmp");
                collection = this.dirtyFiles;
                C c2 = DiskLruCache.this.directory;
                String string3 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                collection.add(c2.a(string3));
                stringBuilder.setLength(n);
            }
        }

        public final String getKey() {
            return this.key;
        }

        public final long[] getLengths() {
            return this.lengths;
        }

        public final ArrayList<C> getCleanFiles() {
            return this.cleanFiles;
        }

        public final ArrayList<C> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = bl;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        public final void setZombie(boolean bl) {
            this.zombie = bl;
        }

        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        public final void setCurrentEditor(Editor editor) {
            this.currentEditor = editor;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        public final void setLockingSnapshotCount(int n) {
            this.lockingSnapshotCount = n;
        }

        public final void setLengths(List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"");
            if (list.size() != DiskLruCache.this.valueCount) {
                throw new IOException("unexpected journal line: " + list);
            }
            try {
                int n = ((Collection)list).size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(list.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("unexpected journal line: " + list);
            }
        }

        public final void writeLengths(f f2) {
            Intrinsics.checkNotNullParameter((Object)f2, (String)"");
            for (long l2 : this.lengths) {
                f2.h(32).n(l2);
            }
        }

        public final Snapshot snapshot() {
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            Iterable iterable = this.cleanFiles;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl = false;
            for (Object t : iterable) {
                C c = (C)t;
                boolean bl2 = false;
                if (diskLruCache.fileSystem.exists(c)) continue;
                try {
                    diskLruCache.removeEntry(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            int n = this.lockingSnapshotCount;
            this.lockingSnapshotCount = n + 1;
            return new Snapshot(this);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0005R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "Lio/ktor/utils/io/core/Closeable;", "entry", "Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "Lio/kamel/core/cache/disk/DiskLruCache;", "<init>", "(Lio/kamel/core/cache/disk/DiskLruCache;Lio/kamel/core/cache/disk/DiskLruCache$Entry;)V", "closed", "", "file", "Lokio/Path;", "index", "", "close", "", "closeAndEdit", "Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "kamel-core"})
    public final class Snapshot
    implements Closeable {
        private final Entry entry;
        private boolean closed;

        public Snapshot(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            this.entry = entry;
        }

        private final C file(int n) {
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "snapshot is closed";
                throw new IllegalStateException(string.toString());
            }
            C c = this.entry.getCleanFiles().get(n);
            Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
            return c;
        }

        public final C file() {
            return this.file(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                boolean bl3 = false;
                if (!this.closed) {
                    this.closed = true;
                    i.a((CoroutineScope)diskLruCache2.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, diskLruCache2, null){
                        int label;
                        final /* synthetic */ Snapshot this$0;
                        final /* synthetic */ DiskLruCache this$1;
                        {
                            this.this$0 = snapshot;
                            this.this$1 = diskLruCache;
                            super(2, continuation);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    Entry entry = Snapshot.access$getEntry$p(this.this$0);
                                    int n = entry.getLockingSnapshotCount();
                                    entry.setLockingSnapshotCount(n + -1);
                                    if (Snapshot.access$getEntry$p(this.this$0).getLockingSnapshotCount() == 0 && Snapshot.access$getEntry$p(this.this$0).getZombie()) {
                                        i.a((CoroutineScope)DiskLruCache.access$getCleanupScope$p(this.this$1), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.this$0, null){
                                            int label;
                                            final /* synthetic */ DiskLruCache this$0;
                                            final /* synthetic */ Snapshot this$1;
                                            {
                                                this.this$0 = diskLruCache;
                                                this.this$1 = snapshot;
                                                super(2, continuation);
                                            }

                                            public final Object invokeSuspend(Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        DiskLruCache.access$removeEntry(this.this$0, Snapshot.access$getEntry$p(this.this$1));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                                                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                            return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Editor closeAndEdit() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                boolean bl3 = false;
                this.close();
                Editor editor = diskLruCache2.edit(this.entry.getKey());
                return editor;
            }
        }

        public static final /* synthetic */ Entry access$getEntry$p(Snapshot snapshot) {
            return snapshot.entry;
        }
    }
}

