/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.icons.FlatCheckBoxMenuItemIcon;
import com.formdev.flatlaf.icons.FlatMenuArrowIcon;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.View;

public class FlatMenuItemRenderer {
    private static final String KEY_MAX_ICONS_WIDTH = "FlatLaf.internal.FlatMenuItemRenderer.maxIconWidth";
    protected final JMenuItem menuItem;
    protected Icon checkIcon;
    protected Icon arrowIcon;
    @FlatStylingSupport.Styleable
    protected Font acceleratorFont;
    protected final String acceleratorDelimiter;
    @FlatStylingSupport.Styleable
    protected boolean verticallyAlignText = FlatUIUtils.getUIBoolean("MenuItem.verticallyAlignText", true);
    @FlatStylingSupport.Styleable
    protected int minimumWidth = UIManager.getInt("MenuItem.minimumWidth");
    @FlatStylingSupport.Styleable
    protected Dimension minimumIconSize;
    @FlatStylingSupport.Styleable
    protected int textAcceleratorGap = FlatUIUtils.getUIInt("MenuItem.textAcceleratorGap", 28);
    @FlatStylingSupport.Styleable
    protected int textNoAcceleratorGap = FlatUIUtils.getUIInt("MenuItem.textNoAcceleratorGap", 6);
    @FlatStylingSupport.Styleable
    protected int acceleratorArrowGap = FlatUIUtils.getUIInt("MenuItem.acceleratorArrowGap", 2);
    @FlatStylingSupport.Styleable
    protected Color checkBackground = UIManager.getColor("MenuItem.checkBackground");
    @FlatStylingSupport.Styleable
    protected Insets checkMargins = UIManager.getInsets("MenuItem.checkMargins");
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets = UIManager.getInsets("MenuItem.selectionInsets");
    @FlatStylingSupport.Styleable
    protected int selectionArc = UIManager.getInt("MenuItem.selectionArc");
    @FlatStylingSupport.Styleable
    protected Color underlineSelectionBackground = UIManager.getColor("MenuItem.underlineSelectionBackground");
    @FlatStylingSupport.Styleable
    protected Color underlineSelectionCheckBackground = UIManager.getColor("MenuItem.underlineSelectionCheckBackground");
    @FlatStylingSupport.Styleable
    protected Color underlineSelectionColor = UIManager.getColor("MenuItem.underlineSelectionColor");
    @FlatStylingSupport.Styleable
    protected int underlineSelectionHeight = UIManager.getInt("MenuItem.underlineSelectionHeight");
    private boolean iconsShared = true;
    private final Font menuFont = UIManager.getFont("Menu.font");
    private KeyStroke cachedAccelerator;
    private String cachedAcceleratorText;
    private boolean cachedAcceleratorLeftToRight;
    private static final char controlGlyph = '\u2303';
    private static final char optionGlyph = '\u2325';
    private static final char shiftGlyph = '\u21e7';
    private static final char commandGlyph = '\u2318';

    protected FlatMenuItemRenderer(JMenuItem jMenuItem, Icon icon, Icon icon2, Font font, String string) {
        this.menuItem = jMenuItem;
        this.checkIcon = icon;
        this.arrowIcon = icon2;
        this.acceleratorFont = font;
        this.acceleratorDelimiter = string;
        Dimension dimension = UIManager.getDimension("MenuItem.minimumIconSize");
        this.minimumIconSize = dimension != null ? dimension : new Dimension(16, 16);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (string.startsWith("icon.") || string.equals("selectionForeground")) {
            if (this.iconsShared) {
                if (this.checkIcon instanceof FlatCheckBoxMenuItemIcon) {
                    this.checkIcon = FlatStylingSupport.cloneIcon(this.checkIcon);
                }
                if (this.arrowIcon instanceof FlatMenuArrowIcon) {
                    this.arrowIcon = FlatStylingSupport.cloneIcon(this.arrowIcon);
                }
                this.iconsShared = false;
            }
            if (string.startsWith("icon.")) {
                String string2 = string.substring("icon.".length());
                try {
                    if (this.checkIcon instanceof FlatCheckBoxMenuItemIcon) {
                        return ((FlatCheckBoxMenuItemIcon)this.checkIcon).applyStyleProperty(string2, object);
                    }
                }
                catch (FlatStylingSupport.UnknownStyleException unknownStyleException) {
                    // empty catch block
                }
                try {
                    if (this.arrowIcon instanceof FlatMenuArrowIcon) {
                        return ((FlatMenuArrowIcon)this.arrowIcon).applyStyleProperty(string2, object);
                    }
                }
                catch (FlatStylingSupport.UnknownStyleException unknownStyleException) {
                    // empty catch block
                }
                throw new FlatStylingSupport.UnknownStyleException(string);
            }
            if (string.equals("selectionForeground")) {
                if (this.checkIcon instanceof FlatCheckBoxMenuItemIcon) {
                    ((FlatCheckBoxMenuItemIcon)this.checkIcon).applyStyleProperty(string, object);
                }
                if (this.arrowIcon instanceof FlatMenuArrowIcon) {
                    ((FlatMenuArrowIcon)this.arrowIcon).applyStyleProperty(string, object);
                }
                throw new FlatStylingSupport.UnknownStyleException(string);
            }
        }
        return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
    }

    public Map<String, Class<?>> getStyleableInfos() {
        Map<String, Class<?>> map = FlatStylingSupport.getAnnotatedStyleableInfos(this);
        if (this.checkIcon instanceof FlatCheckBoxMenuItemIcon) {
            FlatStylingSupport.putAllPrefixKey(map, "icon.", ((FlatCheckBoxMenuItemIcon)this.checkIcon).getStyleableInfos());
        }
        map.remove("icon.selectionForeground");
        if (this.arrowIcon instanceof FlatMenuArrowIcon) {
            FlatStylingSupport.putAllPrefixKey(map, "icon.", ((FlatMenuArrowIcon)this.arrowIcon).getStyleableInfos());
        }
        map.remove("icon.selectionForeground");
        return map;
    }

    public Object getStyleableValue(String string) {
        if (string.startsWith("icon.")) {
            String string2 = string.substring("icon.".length());
            if (this.checkIcon instanceof FlatCheckBoxMenuItemIcon) {
                return ((FlatCheckBoxMenuItemIcon)this.checkIcon).getStyleableValue(string2);
            }
            if (this.arrowIcon instanceof FlatMenuArrowIcon) {
                return ((FlatMenuArrowIcon)this.arrowIcon).getStyleableValue(string2);
            }
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    protected Dimension getPreferredMenuItemSize() {
        Serializable serializable;
        int n = 0;
        int n2 = 0;
        boolean bl = FlatMenuItemRenderer.isTopLevelMenu(this.menuItem);
        Rectangle rectangle = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        SwingUtilities.layoutCompoundLabel(this.menuItem, this.menuItem.getFontMetrics(bl ? this.getTopLevelFont() : this.menuItem.getFont()), this.menuItem.getText(), this.getIconForLayout(), this.menuItem.getVerticalAlignment(), this.menuItem.getHorizontalAlignment(), this.menuItem.getVerticalTextPosition(), this.menuItem.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, UIScale.scale(this.menuItem.getIconTextGap()));
        Rectangle rectangle4 = rectangle2.union(rectangle3);
        n += rectangle4.width;
        n2 = Math.max(rectangle4.height, n2);
        String string = this.getAcceleratorText();
        if (string != null) {
            n += UIScale.scale(!bl ? this.textAcceleratorGap : this.menuItem.getIconTextGap());
            serializable = this.menuItem.getFontMetrics(this.acceleratorFont);
            n += SwingUtilities.computeStringWidth((FontMetrics)serializable, string);
            n2 = Math.max(((FontMetrics)serializable).getHeight(), n2);
        }
        if (!bl && this.arrowIcon != null) {
            if (string == null) {
                n += UIScale.scale(this.textNoAcceleratorGap);
            }
            n += UIScale.scale(this.acceleratorArrowGap);
            n += this.arrowIcon.getIconWidth();
            n2 = Math.max(this.arrowIcon.getIconHeight(), n2);
        }
        serializable = this.menuItem.getInsets();
        n += ((Insets)serializable).left + ((Insets)serializable).right;
        n2 += ((Insets)serializable).top + ((Insets)serializable).bottom;
        if (!bl) {
            int n3 = FlatUIUtils.minimumWidth(this.menuItem, this.minimumWidth);
            n = Math.max(n, UIScale.scale(n3));
        }
        return new Dimension(n, n2);
    }

    private void layout(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6) {
        int n;
        boolean bl = FlatMenuItemRenderer.isTopLevelMenu(this.menuItem);
        if (!bl && this.arrowIcon != null) {
            rectangle5.width = this.arrowIcon.getIconWidth();
            rectangle5.height = this.arrowIcon.getIconHeight();
        } else {
            rectangle5.setSize(0, 0);
        }
        rectangle5.y = rectangle.y + FlatMenuItemRenderer.centerOffset(rectangle.height, rectangle5.height);
        String string = this.getAcceleratorText();
        if (string != null) {
            FontMetrics fontMetrics = this.menuItem.getFontMetrics(this.acceleratorFont);
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics, string);
            rectangle4.height = fontMetrics.getHeight();
            rectangle4.y = rectangle.y + FlatMenuItemRenderer.centerOffset(rectangle.height, rectangle4.height);
        } else {
            rectangle4.setBounds(0, 0, 0, 0);
        }
        int n2 = n = !bl ? UIScale.scale(this.acceleratorArrowGap) : 0;
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            rectangle5.x = rectangle.x + rectangle.width - rectangle5.width;
            rectangle4.x = rectangle5.x - n - rectangle4.width;
        } else {
            rectangle5.x = rectangle.x;
            rectangle4.x = rectangle5.x + n + rectangle5.width;
        }
        int n3 = rectangle4.width + rectangle5.width;
        if (string != null) {
            n3 += UIScale.scale(!bl ? this.textAcceleratorGap : this.menuItem.getIconTextGap());
        }
        if (!bl && this.arrowIcon != null) {
            if (string == null) {
                n3 += UIScale.scale(this.textNoAcceleratorGap);
            }
            n3 += UIScale.scale(this.acceleratorArrowGap);
        }
        rectangle6.setBounds(rectangle);
        rectangle6.width -= n3;
        if (!this.menuItem.getComponentOrientation().isLeftToRight()) {
            rectangle6.x += n3;
        }
        SwingUtilities.layoutCompoundLabel(this.menuItem, this.menuItem.getFontMetrics(bl ? this.getTopLevelFont() : this.menuItem.getFont()), this.menuItem.getText(), this.getIconForLayout(), this.menuItem.getVerticalAlignment(), this.menuItem.getHorizontalAlignment(), this.menuItem.getVerticalTextPosition(), this.menuItem.getHorizontalTextPosition(), rectangle6, rectangle2, rectangle3, UIScale.scale(this.menuItem.getIconTextGap()));
    }

    private static int centerOffset(int n, int n2) {
        return n / 2 - n2 / 2;
    }

    protected void paintMenuItem(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5) {
        Rectangle rectangle = new Rectangle(this.menuItem.getWidth(), this.menuItem.getHeight());
        Insets insets = this.menuItem.getInsets();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle();
        this.layout(rectangle, rectangle2, rectangle3, rectangle4, rectangle5, rectangle6);
        boolean bl = FlatMenuItemRenderer.isArmedOrSelected(this.menuItem);
        boolean bl2 = this.isUnderlineSelection();
        this.paintBackground(graphics);
        if (bl) {
            if (bl2) {
                this.paintUnderlineSelection(graphics, this.underlineSelectionBackground, this.underlineSelectionColor, this.underlineSelectionHeight);
            } else {
                this.paintSelection(graphics, color, this.selectionInsets, this.selectionArc);
            }
        }
        this.paintIcon(graphics, rectangle2, this.getIconForPainting(), bl2 ? this.underlineSelectionCheckBackground : this.checkBackground, color);
        this.paintText(graphics, rectangle3, this.menuItem.getText(), color2, color3);
        this.paintAccelerator(graphics, rectangle4, this.getAcceleratorText(), color4, color5, color3);
        if (!FlatMenuItemRenderer.isTopLevelMenu(this.menuItem)) {
            this.paintArrowIcon(graphics, rectangle5, this.arrowIcon);
        }
    }

    protected void paintBackground(Graphics graphics) {
        if (this.menuItem.isOpaque()) {
            graphics.setColor(this.menuItem.getBackground());
            graphics.fillRect(0, 0, this.menuItem.getWidth(), this.menuItem.getHeight());
        }
    }

    protected void paintSelection(Graphics graphics, Color color, Insets insets, int n) {
        float f = UIScale.scale((float)n / 2.0f);
        graphics.setColor(this.deriveBackground(color));
        FlatUIUtils.paintSelection((Graphics2D)graphics, 0, 0, this.menuItem.getWidth(), this.menuItem.getHeight(), UIScale.scale(insets), f, f, f, f, 0);
    }

    protected void paintUnderlineSelection(Graphics graphics, Color color, Color color2, int n) {
        int n2 = this.menuItem.getWidth();
        int n3 = this.menuItem.getHeight();
        graphics.setColor(this.deriveBackground(color));
        graphics.fillRect(0, 0, n2, n3);
        int n4 = UIScale.scale(n);
        graphics.setColor(color2);
        if (FlatMenuItemRenderer.isTopLevelMenu(this.menuItem)) {
            graphics.fillRect(0, n3 - n4, n2, n4);
        } else if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            graphics.fillRect(0, 0, n4, n3);
        } else {
            graphics.fillRect(n2 - n4, 0, n4, n3);
        }
    }

    protected Color deriveBackground(Color color) {
        if (!(color instanceof DerivedColor)) {
            return color;
        }
        Color color2 = this.menuItem.isOpaque() ? this.menuItem.getBackground() : FlatUIUtils.getParentBackground(this.menuItem);
        return FlatUIUtils.deriveColor(color, color2);
    }

    protected void paintIcon(Graphics graphics, Rectangle rectangle, Icon icon, Color color, Color color2) {
        if (this.menuItem.isSelected() && this.checkIcon != null && icon != this.checkIcon) {
            Rectangle rectangle2 = FlatUIUtils.addInsets(rectangle, UIScale.scale(this.checkMargins));
            graphics.setColor(FlatUIUtils.deriveColor(color, color2));
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        FlatMenuItemRenderer.paintIcon(graphics, this.menuItem, icon, rectangle);
    }

    protected void paintText(Graphics graphics, Rectangle rectangle, String string, Color color, Color color2) {
        View view = (View)this.menuItem.getClientProperty("html");
        if (view != null) {
            FlatMenuItemRenderer.paintHTMLText(graphics, this.menuItem, rectangle, view, this.isUnderlineSelection() ? null : color);
            return;
        }
        int n = FlatLaf.isShowMnemonics() ? this.menuItem.getDisplayedMnemonicIndex() : -1;
        boolean bl = FlatMenuItemRenderer.isTopLevelMenu(this.menuItem);
        Color color3 = (bl ? this.menuItem.getParent() : this.menuItem).getForeground();
        FlatMenuItemRenderer.paintText(graphics, this.menuItem, rectangle, string, n, bl ? this.getTopLevelFont() : this.menuItem.getFont(), color3, this.isUnderlineSelection() ? color3 : color, color2);
    }

    protected void paintAccelerator(Graphics graphics, Rectangle rectangle, String string, Color color, Color color2, Color color3) {
        FlatMenuItemRenderer.paintText(graphics, this.menuItem, rectangle, string, -1, this.acceleratorFont, color, this.isUnderlineSelection() ? color : color2, color3);
    }

    protected void paintArrowIcon(Graphics graphics, Rectangle rectangle, Icon icon) {
        FlatMenuItemRenderer.paintIcon(graphics, this.menuItem, icon, rectangle);
    }

    protected static void paintIcon(Graphics graphics, JMenuItem jMenuItem, Icon icon, Rectangle rectangle) {
        if (icon == null) {
            return;
        }
        int n = rectangle.x + FlatMenuItemRenderer.centerOffset(rectangle.width, icon.getIconWidth());
        int n2 = rectangle.y + FlatMenuItemRenderer.centerOffset(rectangle.height, icon.getIconHeight());
        icon.paintIcon(jMenuItem, graphics, n, n2);
    }

    protected static void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string, int n, Font font, Color color, Color color2, Color color3) {
        if (string == null || string.isEmpty()) {
            return;
        }
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        Font font2 = graphics.getFont();
        graphics.setFont(font);
        graphics.setColor(!jMenuItem.isEnabled() ? color3 : (FlatMenuItemRenderer.isArmedOrSelected(jMenuItem) ? color2 : color));
        FlatUIUtils.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        graphics.setFont(font2);
    }

    protected static void paintHTMLText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, View view, Color color) {
        rectangle = new Rectangle(rectangle);
        rectangle.width = (int)view.getPreferredSpan(0);
        if (FlatMenuItemRenderer.isArmedOrSelected(jMenuItem) && color != null) {
            graphics = new GraphicsProxyWithTextColor((Graphics2D)graphics, color);
        }
        view.paint(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics), rectangle);
    }

    protected static boolean isArmedOrSelected(JMenuItem jMenuItem) {
        return jMenuItem.isArmed() || jMenuItem instanceof JMenu && jMenuItem.isSelected();
    }

    protected static boolean isTopLevelMenu(JMenuItem jMenuItem) {
        return jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu();
    }

    protected boolean isUnderlineSelection() {
        return "underline".equals(UIManager.getString("MenuItem.selectionType"));
    }

    private Font getTopLevelFont() {
        Font font = this.menuItem.getFont();
        return font != this.menuFont || this.menuItem.getParent() == null ? font : this.menuItem.getParent().getFont();
    }

    private Icon getIconForPainting() {
        Icon icon;
        Icon icon2 = this.menuItem.getIcon();
        if (icon2 == null && this.checkIcon != null && !FlatMenuItemRenderer.isTopLevelMenu(this.menuItem)) {
            return this.checkIcon;
        }
        if (icon2 == null) {
            return null;
        }
        if (!this.menuItem.isEnabled()) {
            return this.menuItem.getDisabledIcon();
        }
        if (this.menuItem.getModel().isPressed() && this.menuItem.isArmed() && (icon = this.menuItem.getPressedIcon()) != null) {
            return icon;
        }
        if (FlatMenuItemRenderer.isArmedOrSelected(this.menuItem) && (icon = this.menuItem.getSelectedIcon()) != null) {
            return icon;
        }
        return icon2;
    }

    private Icon getIconForLayout() {
        Icon icon = this.menuItem.getIcon();
        if (FlatMenuItemRenderer.isTopLevelMenu(this.menuItem)) {
            return icon != null ? new MinSizeIcon(icon) : null;
        }
        return new MinSizeIcon(icon != null ? icon : this.checkIcon);
    }

    private String getAcceleratorText() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        if (keyStroke == null) {
            return null;
        }
        boolean bl = this.menuItem.getComponentOrientation().isLeftToRight();
        if (keyStroke == this.cachedAccelerator && bl == this.cachedAcceleratorLeftToRight) {
            return this.cachedAcceleratorText;
        }
        this.cachedAccelerator = keyStroke;
        this.cachedAcceleratorText = this.getTextForAccelerator(keyStroke);
        this.cachedAcceleratorLeftToRight = bl;
        return this.cachedAcceleratorText;
    }

    protected String getTextForAccelerator(KeyStroke keyStroke) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.menuItem.getComponentOrientation().isLeftToRight();
        int n2 = keyStroke.getModifiers();
        if (n2 != 0) {
            if (SystemInfo.isMacOS) {
                if (bl) {
                    stringBuilder.append(this.getMacOSModifiersExText(n2, bl));
                }
            } else {
                stringBuilder.append(InputEvent.getModifiersExText(n2)).append(this.acceleratorDelimiter);
            }
        }
        if ((n = keyStroke.getKeyCode()) != 0) {
            stringBuilder.append(KeyEvent.getKeyText(n));
        } else {
            stringBuilder.append(keyStroke.getKeyChar());
        }
        if (n2 != 0 && !bl && SystemInfo.isMacOS) {
            stringBuilder.append(this.getMacOSModifiersExText(n2, bl));
        }
        return stringBuilder.toString();
    }

    protected String getMacOSModifiersExText(int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x80) != 0) {
            stringBuilder.append('\u2303');
        }
        if ((n & 0x2200) != 0) {
            stringBuilder.append('\u2325');
        }
        if ((n & 0x40) != 0) {
            stringBuilder.append('\u21e7');
        }
        if ((n & 0x100) != 0) {
            stringBuilder.append('\u2318');
        }
        if (!bl) {
            stringBuilder.reverse();
        }
        return stringBuilder.toString();
    }

    private int getMaxIconsWidth() {
        if (!this.verticallyAlignText) {
            return 0;
        }
        Container container = this.menuItem.getParent();
        if (!(container instanceof JComponent)) {
            return 0;
        }
        int n = FlatClientProperties.clientPropertyInt((JComponent)container, KEY_MAX_ICONS_WIDTH, -1);
        if (n >= 0) {
            return n;
        }
        n = 0;
        for (Component component : container.getComponents()) {
            Icon icon;
            if (!(component instanceof JMenuItem) || (icon = ((JMenuItem)component).getIcon()) == null) continue;
            n = Math.max(n, icon.getIconWidth());
        }
        ((JComponent)container).putClientProperty(KEY_MAX_ICONS_WIDTH, n);
        return n;
    }

    static void clearClientProperties(Component component) {
        if (!(component instanceof JComponent)) {
            return;
        }
        JComponent jComponent = (JComponent)component;
        jComponent.putClientProperty(KEY_MAX_ICONS_WIDTH, null);
    }

    private static class GraphicsProxyWithTextColor
    extends Graphics2DProxy {
        private final Color textColor;

        GraphicsProxyWithTextColor(Graphics2D graphics2D, Color color) {
            super(graphics2D);
            this.textColor = color;
        }

        @Override
        public void drawString(String string, int n, int n2) {
            Paint paint = this.getPaint();
            this.setPaint(this.textColor);
            super.drawString(string, n, n2);
            this.setPaint(paint);
        }

        @Override
        public void drawString(String string, float f, float f2) {
            Paint paint = this.getPaint();
            this.setPaint(this.textColor);
            super.drawString(string, f, f2);
            this.setPaint(paint);
        }

        @Override
        public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
            Paint paint = this.getPaint();
            this.setPaint(this.textColor);
            super.drawString(attributedCharacterIterator, n, n2);
            this.setPaint(paint);
        }

        @Override
        public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
            Paint paint = this.getPaint();
            this.setPaint(this.textColor);
            super.drawString(attributedCharacterIterator, f, f2);
            this.setPaint(paint);
        }

        @Override
        public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
            Paint paint = this.getPaint();
            this.setPaint(this.textColor);
            super.drawChars(cArray, n, n2, n3, n4);
            this.setPaint(paint);
        }
    }

    private class MinSizeIcon
    implements Icon {
        private final Icon delegate;

        MinSizeIcon(Icon icon) {
            this.delegate = icon;
        }

        @Override
        public int getIconWidth() {
            int n = this.delegate != null ? this.delegate.getIconWidth() : 0;
            n = Math.max(n, FlatMenuItemRenderer.this.getMaxIconsWidth());
            return Math.max(n, UIScale.scale(FlatMenuItemRenderer.this.minimumIconSize.width));
        }

        @Override
        public int getIconHeight() {
            int n = this.delegate != null ? this.delegate.getIconHeight() : 0;
            return Math.max(n, UIScale.scale(FlatMenuItemRenderer.this.minimumIconSize.height));
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }
}

