/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatNativeMacLibrary;
import com.formdev.flatlaf.ui.FlatNativeWindowBorder;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FlatWindowResizer;
import com.formdev.flatlaf.ui.FullWindowContentSupport;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class FlatRootPaneUI
extends BasicRootPaneUI {
    protected final Color borderColor = UIManager.getColor("TitlePane.borderColor");
    protected JRootPane rootPane;
    protected FlatTitlePane titlePane;
    protected FlatWindowResizer windowResizer;
    private Object nativeWindowBorderData;
    private LayoutManager oldLayout;
    private ComponentListener macFullWindowContentListener;
    private PropertyChangeListener macWindowBackgroundListener;
    protected static final Integer TITLE_PANE_LAYER = JLayeredPane.FRAME_CONTENT_LAYER - 1;
    private static final Integer TITLE_PANE_MOUSE_LAYER = JLayeredPane.FRAME_CONTENT_LAYER - 2;
    private static final Integer WINDOW_TOP_BORDER_LAYER = Integer.MAX_VALUE;
    protected static final Integer TITLE_PANE_FULL_WINDOW_CONTENT_LAYER = JLayeredPane.FRAME_CONTENT_LAYER + 1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatRootPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.rootPane = (JRootPane)jComponent;
        if (this.rootPane.getWindowDecorationStyle() != 0) {
            this.installClientDecorations();
        } else {
            this.installBorder();
        }
        this.installNativeWindowBorder();
        this.macInstallFullWindowContentSupport();
    }

    protected void installBorder() {
        Border border;
        if (this.borderColor != null && ((border = this.rootPane.getBorder()) == null || border instanceof UIResource)) {
            this.rootPane.setBorder(new FlatWindowTitleBorder(this.borderColor));
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallNativeWindowBorder();
        this.uninstallClientDecorations();
        this.macUninstallFullWindowContentSupport();
        this.rootPane = null;
    }

    @Override
    protected void installDefaults(JRootPane jRootPane) {
        Color color;
        Container container;
        super.installDefaults(jRootPane);
        if (!jRootPane.isBackgroundSet() || jRootPane.getBackground() instanceof UIResource) {
            jRootPane.setBackground(UIManager.getColor("RootPane.background"));
        }
        if (!jRootPane.isForegroundSet() || jRootPane.getForeground() instanceof UIResource) {
            jRootPane.setForeground(UIManager.getColor("RootPane.foreground"));
        }
        if (!jRootPane.isFontSet() || jRootPane.getFont() instanceof UIResource) {
            jRootPane.setFont(UIManager.getFont("RootPane.font"));
        }
        if (((container = jRootPane.getParent()) instanceof JFrame || container instanceof JDialog) && ((color = container.getBackground()) == null || color instanceof UIResource)) {
            container.setBackground(UIManager.getColor("control"));
        }
        this.macClearBackgroundForTranslucentWindow(jRootPane);
    }

    @Override
    protected void uninstallDefaults(JRootPane jRootPane) {
        super.uninstallDefaults(jRootPane);
        if (jRootPane.isBackgroundSet() && jRootPane.getBackground() instanceof UIResource) {
            jRootPane.setBackground(null);
        }
        if (jRootPane.isForegroundSet() && jRootPane.getForeground() instanceof UIResource) {
            jRootPane.setForeground(null);
        }
        if (jRootPane.isFontSet() && jRootPane.getFont() instanceof UIResource) {
            jRootPane.setFont(null);
        }
    }

    @Override
    protected void installListeners(JRootPane jRootPane) {
        super.installListeners(jRootPane);
        if (SystemInfo.isMacFullWindowContentSupported) {
            this.macFullWindowContentListener = FullWindowContentSupport.macInstallListeners(jRootPane);
        }
        this.macInstallWindowBackgroundListener(jRootPane);
    }

    @Override
    protected void uninstallListeners(JRootPane jRootPane) {
        super.uninstallListeners(jRootPane);
        if (SystemInfo.isMacFullWindowContentSupported) {
            FullWindowContentSupport.macUninstallListeners(jRootPane, this.macFullWindowContentListener);
            this.macFullWindowContentListener = null;
        }
        this.macUninstallWindowBackgroundListener(jRootPane);
    }

    protected void installNativeWindowBorder() {
        this.nativeWindowBorderData = FlatNativeWindowBorder.install(this.rootPane);
    }

    protected void uninstallNativeWindowBorder() {
        FlatNativeWindowBorder.uninstall(this.rootPane, this.nativeWindowBorderData);
        this.nativeWindowBorderData = null;
    }

    public static void updateNativeWindowBorder(JRootPane jRootPane) {
        RootPaneUI rootPaneUI = jRootPane.getUI();
        if (!(rootPaneUI instanceof FlatRootPaneUI)) {
            return;
        }
        FlatRootPaneUI flatRootPaneUI = (FlatRootPaneUI)rootPaneUI;
        flatRootPaneUI.uninstallNativeWindowBorder();
        flatRootPaneUI.installNativeWindowBorder();
    }

    protected void installClientDecorations() {
        boolean bl = FlatNativeWindowBorder.isSupported();
        if (this.rootPane.getWindowDecorationStyle() != 0 && !bl) {
            LookAndFeel.installBorder(this.rootPane, "RootPane.border");
        } else {
            LookAndFeel.uninstallBorder(this.rootPane);
        }
        this.setTitlePane(this.createTitlePane());
        this.oldLayout = this.rootPane.getLayout();
        this.rootPane.setLayout(this.createRootLayout());
        if (!bl) {
            this.windowResizer = this.createWindowResizer();
        }
    }

    protected void uninstallClientDecorations() {
        LookAndFeel.uninstallBorder(this.rootPane);
        this.setTitlePane(null);
        if (this.windowResizer != null) {
            this.windowResizer.uninstall();
            this.windowResizer = null;
        }
        if (this.oldLayout != null) {
            this.rootPane.setLayout(this.oldLayout);
            this.oldLayout = null;
        }
        if (this.rootPane.getWindowDecorationStyle() == 0) {
            this.rootPane.revalidate();
            this.rootPane.repaint();
        }
    }

    protected FlatRootLayout createRootLayout() {
        return new FlatRootLayout();
    }

    protected FlatWindowResizer createWindowResizer() {
        return new FlatWindowResizer.WindowResizer(this.rootPane);
    }

    protected FlatTitlePane createTitlePane() {
        return new FlatTitlePane(this.rootPane);
    }

    private Integer getLayerForTitlePane() {
        return FlatRootPaneUI.isFullWindowContent(this.rootPane) ? TITLE_PANE_FULL_WINDOW_CONTENT_LAYER : TITLE_PANE_LAYER;
    }

    protected void setTitlePane(FlatTitlePane flatTitlePane) {
        JLayeredPane jLayeredPane = this.rootPane.getLayeredPane();
        if (this.titlePane != null) {
            jLayeredPane.remove(this.titlePane);
            jLayeredPane.remove(this.titlePane.mouseLayer);
            if (this.titlePane.windowTopBorderLayer != null) {
                jLayeredPane.remove(this.titlePane.windowTopBorderLayer);
            }
        }
        if (flatTitlePane != null) {
            jLayeredPane.add((Component)flatTitlePane, this.getLayerForTitlePane());
            jLayeredPane.add((Component)flatTitlePane.mouseLayer, TITLE_PANE_MOUSE_LAYER);
            if (flatTitlePane.windowTopBorderLayer != null && flatTitlePane.isWindowTopBorderNeeded() && FlatRootPaneUI.isFullWindowContent(this.rootPane)) {
                jLayeredPane.add((Component)flatTitlePane.windowTopBorderLayer, WINDOW_TOP_BORDER_LAYER);
            }
        }
        this.titlePane = flatTitlePane;
    }

    private void macInstallFullWindowContentSupport() {
        if (!SystemInfo.isMacOS) {
            return;
        }
        if (this.isMacButtonsSpacingSupported() && this.rootPane.isDisplayable()) {
            int n = 0;
            String string = (String)this.rootPane.getClientProperty("FlatLaf.macOS.windowButtonsSpacing");
            if (string != null) {
                switch (string) {
                    case "medium": {
                        n = 1;
                        break;
                    }
                    case "large": {
                        n = 2;
                    }
                }
            }
            FlatNativeMacLibrary.setWindowButtonsSpacing(this.getParentWindow(this.rootPane), n);
        }
        FullWindowContentSupport.macUpdateFullWindowContentButtonsBoundsProperty(this.rootPane);
    }

    private void macUninstallFullWindowContentSupport() {
        if (!SystemInfo.isMacOS) {
            return;
        }
        if (UIManager.getLookAndFeel() instanceof FlatLaf) {
            return;
        }
        if (this.isMacButtonsSpacingSupported()) {
            FlatNativeMacLibrary.setWindowButtonsSpacing(this.getParentWindow(this.rootPane), 0);
        }
        FullWindowContentSupport.macUninstallFullWindowContentButtonsBoundsProperty(this.rootPane);
    }

    private boolean isMacButtonsSpacingSupported() {
        return SystemInfo.isMacOS && SystemInfo.isJava_17_orLater && FlatNativeMacLibrary.isLoaded();
    }

    private void macInstallWindowBackgroundListener(JRootPane jRootPane) {
        if (!SystemInfo.isMacOS) {
            return;
        }
        Window window = this.getParentWindow(jRootPane);
        if (window != null && this.macWindowBackgroundListener == null) {
            this.macWindowBackgroundListener = propertyChangeEvent -> this.macClearBackgroundForTranslucentWindow(jRootPane);
            window.addPropertyChangeListener("background", this.macWindowBackgroundListener);
        }
    }

    private void macUninstallWindowBackgroundListener(JRootPane jRootPane) {
        if (!SystemInfo.isMacOS) {
            return;
        }
        Window window = this.getParentWindow(jRootPane);
        if (window != null && this.macWindowBackgroundListener != null) {
            window.removePropertyChangeListener("background", this.macWindowBackgroundListener);
            this.macWindowBackgroundListener = null;
        }
    }

    private void macClearBackgroundForTranslucentWindow(JRootPane jRootPane) {
        Color color;
        if (!SystemInfo.isMacOS) {
            return;
        }
        Window window = this.getParentWindow(jRootPane);
        if (window != null && (color = window.getBackground()) != null && color.getAlpha() < 255 && jRootPane.getBackground() instanceof UIResource) {
            jRootPane.setBackground(null);
        }
    }

    private Window getParentWindow(JRootPane jRootPane) {
        Container container = jRootPane.getParent();
        return container instanceof Window ? (Window)container : null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        switch (propertyChangeEvent.getPropertyName()) {
            case "windowDecorationStyle": {
                this.uninstallClientDecorations();
                if (this.rootPane.getWindowDecorationStyle() != 0) {
                    this.installClientDecorations();
                    break;
                }
                this.installBorder();
                break;
            }
            case "JRootPane.useWindowDecorations": {
                FlatRootPaneUI.updateNativeWindowBorder(this.rootPane);
                break;
            }
            case "JRootPane.menuBarEmbedded": {
                if (this.titlePane == null) break;
                this.titlePane.menuBarChanged();
                this.rootPane.revalidate();
                this.rootPane.repaint();
                break;
            }
            case "JRootPane.titleBarShowIcon": {
                if (this.titlePane == null) break;
                this.titlePane.updateIcon();
                break;
            }
            case "JRootPane.titleBarShowTitle": 
            case "JRootPane.titleBarShowIconify": 
            case "JRootPane.titleBarShowMaximize": 
            case "JRootPane.titleBarShowClose": {
                if (this.titlePane == null) break;
                this.titlePane.updateVisibility();
                break;
            }
            case "JRootPane.titleBarBackground": 
            case "JRootPane.titleBarForeground": {
                if (this.titlePane == null) break;
                this.titlePane.titleBarColorsChanged();
                break;
            }
            case "FlatLaf.fullWindowContent": {
                if (this.titlePane != null) {
                    this.rootPane.getLayeredPane().setLayer(this.titlePane, this.getLayerForTitlePane());
                    if (this.titlePane.windowTopBorderLayer != null) {
                        JLayeredPane jLayeredPane = this.rootPane.getLayeredPane();
                        if (this.titlePane.isWindowTopBorderNeeded() && FlatRootPaneUI.isFullWindowContent(this.rootPane)) {
                            jLayeredPane.add((Component)this.titlePane.windowTopBorderLayer, WINDOW_TOP_BORDER_LAYER);
                        } else {
                            jLayeredPane.remove(this.titlePane.windowTopBorderLayer);
                        }
                    }
                    this.titlePane.updateIcon();
                    this.titlePane.updateVisibility();
                    this.titlePane.updateFullWindowContentButtonsBoundsProperty();
                }
                FullWindowContentSupport.revalidatePlaceholders(this.rootPane);
                this.rootPane.revalidate();
                break;
            }
            case "FlatLaf.fullWindowContent.buttonsBounds": {
                FullWindowContentSupport.revalidatePlaceholders(this.rootPane);
                break;
            }
            case "JRootPane.glassPaneFullHeight": {
                this.rootPane.revalidate();
                break;
            }
            case "Window.style": {
                if (!this.rootPane.isDisplayable()) break;
                throw new IllegalComponentStateException("The client property 'Window.style' must be set before the window becomes displayable.");
            }
            case "ancestor": {
                if (propertyChangeEvent.getNewValue() instanceof Window) {
                    this.macClearBackgroundForTranslucentWindow(this.rootPane);
                }
                this.macUninstallWindowBackgroundListener(this.rootPane);
                this.macInstallWindowBackgroundListener(this.rootPane);
                if (!(propertyChangeEvent.getNewValue() instanceof Window)) break;
                this.macInstallFullWindowContentSupport();
                break;
            }
            case "FlatLaf.macOS.windowButtonsSpacing": {
                this.macInstallFullWindowContentSupport();
                break;
            }
            case "apple.awt.fullWindowContent": {
                if (!SystemInfo.isMacFullWindowContentSupported) break;
                FullWindowContentSupport.macUpdateFullWindowContentButtonsBoundsProperty(this.rootPane);
            }
        }
    }

    protected static boolean isFullWindowContent(JRootPane jRootPane) {
        return FlatClientProperties.clientPropertyBoolean(jRootPane, "FlatLaf.fullWindowContent", false);
    }

    protected static boolean isMenuBarEmbedded(JRootPane jRootPane) {
        FlatTitlePane flatTitlePane = FlatRootPaneUI.getTitlePane(jRootPane);
        return flatTitlePane != null && flatTitlePane.isMenuBarEmbedded();
    }

    protected static FlatTitlePane getTitlePane(JRootPane jRootPane) {
        RootPaneUI rootPaneUI = jRootPane.getUI();
        return rootPaneUI instanceof FlatRootPaneUI ? ((FlatRootPaneUI)rootPaneUI).titlePane : null;
    }

    private static class FlatWindowTitleBorder
    extends BorderUIResource.EmptyBorderUIResource {
        private final Color borderColor;

        FlatWindowTitleBorder(Color color) {
            super(0, 0, 0, 0);
            this.borderColor = color;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.showBorder(component)) {
                float f = UIScale.scale(1.0f);
                FlatUIUtils.paintFilledRectangle(graphics, this.borderColor, n, n2, n3, f);
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(this.showBorder(component) ? 1 : 0, 0, 0, 0);
            return insets;
        }

        private boolean showBorder(Component component) {
            Container container = component.getParent();
            return container instanceof JFrame && (((JFrame)container).getJMenuBar() == null || !((JFrame)container).getJMenuBar().isVisible()) || container instanceof JDialog && (((JDialog)container).getJMenuBar() == null || !((JDialog)container).getJMenuBar().isVisible());
        }
    }

    public static class FlatWindowBorder
    extends BorderUIResource.EmptyBorderUIResource {
        protected final Color activeBorderColor = UIManager.getColor("RootPane.activeBorderColor");
        protected final Color inactiveBorderColor = UIManager.getColor("RootPane.inactiveBorderColor");
        protected final Color baseBorderColor = UIManager.getColor("Panel.background");

        public FlatWindowBorder() {
            super(1, 1, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            if (this.isWindowMaximized(component) || FlatUIUtils.isFullScreen(component)) {
                insets.right = 0;
                insets.bottom = 0;
                insets.left = 0;
                insets.top = 0;
                return insets;
            }
            return super.getBorderInsets(component, insets);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.isWindowMaximized(component) || FlatUIUtils.isFullScreen(component)) {
                return;
            }
            Container container = component.getParent();
            boolean bl = container instanceof Window && ((Window)container).isActive();
            graphics.setColor(FlatUIUtils.deriveColor(bl ? this.activeBorderColor : this.inactiveBorderColor, this.baseBorderColor));
            HiDPIUtils.paintAtScale1x((Graphics2D)graphics, n, n2, n3, n4, this::paintImpl);
        }

        private void paintImpl(Graphics2D graphics2D, int n, int n2, int n3, int n4, double d) {
            graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        protected boolean isWindowMaximized(Component component) {
            Container container = component.getParent();
            return container instanceof Frame && (((Frame)container).getExtendedState() & 6) == 6;
        }
    }

    protected class FlatRootLayout
    implements LayoutManager2 {
        protected FlatRootLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.computeLayoutSize(container, component -> component.getPreferredSize());
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.computeLayoutSize(container, component -> component.getMinimumSize());
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        private Dimension computeLayoutSize(Container container, Function<Component, Dimension> function) {
            Serializable serializable;
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension = jRootPane.getContentPane() != null ? function.apply(jRootPane.getContentPane()) : jRootPane.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (FlatRootPaneUI.this.titlePane != null && !FlatRootPaneUI.isFullWindowContent(jRootPane)) {
                n2 += function.apply((Component)FlatRootPaneUI.this.titlePane).height;
            }
            if ((FlatRootPaneUI.this.titlePane == null || !FlatRootPaneUI.this.titlePane.isMenuBarEmbedded()) && (serializable = jRootPane.getJMenuBar()) != null && serializable.isVisible()) {
                Dimension dimension2 = function.apply((Component)serializable);
                n = Math.max(n, dimension2.width);
                n2 += dimension2.height;
            }
            serializable = jRootPane.getInsets();
            return new Dimension(n + ((Insets)serializable).left + ((Insets)serializable).right, n2 + ((Insets)serializable).top + ((Insets)serializable).bottom);
        }

        @Override
        public void layoutContainer(Container container) {
            Container container2;
            JMenuBar jMenuBar;
            int n;
            int n2;
            int n3;
            int n4;
            JRootPane jRootPane = (JRootPane)container;
            boolean bl = FlatUIUtils.isFullScreen(jRootPane);
            Insets insets = jRootPane.getInsets();
            int n5 = insets.left;
            int n6 = insets.top;
            int n7 = jRootPane.getWidth() - insets.left - insets.right;
            int n8 = jRootPane.getHeight() - insets.top - insets.bottom;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(n5, n6, n7, n8);
            }
            int n9 = 0;
            if (FlatRootPaneUI.this.titlePane != null) {
                n4 = !bl ? FlatRootPaneUI.this.titlePane.getPreferredSize().height : 0;
                n3 = FlatRootPaneUI.isFullWindowContent(jRootPane) ? 1 : 0;
                if (n3 != 0 && !UIManager.getBoolean("FlatLaf.debug.titlebar.showRectangles")) {
                    n2 = Math.min(FlatRootPaneUI.this.titlePane.getPreferredSize().width, n7);
                    n = FlatRootPaneUI.this.titlePane.getComponentOrientation().isLeftToRight() ? n7 - n2 : 0;
                    FlatRootPaneUI.this.titlePane.setBounds(n, 0, n2, n4);
                } else {
                    FlatRootPaneUI.this.titlePane.setBounds(0, 0, n7, n4);
                }
                FlatRootPaneUI.this.titlePane.mouseLayer.setBounds(0, 0, n7, n4);
                if (FlatRootPaneUI.this.titlePane.windowTopBorderLayer != null) {
                    int n10 = n2 = n3 != 0 && !FlatRootPaneUI.this.titlePane.isWindowMaximized() && !bl ? 1 : 0;
                    if (n2 != 0) {
                        FlatRootPaneUI.this.titlePane.windowTopBorderLayer.setBounds(0, 0, n7, 1);
                    }
                    FlatRootPaneUI.this.titlePane.windowTopBorderLayer.setVisible(n2 != 0);
                }
                if (n3 == 0) {
                    n9 += n4;
                }
            }
            if (jRootPane.getGlassPane() != null) {
                n4 = FlatClientProperties.clientPropertyBoolean(jRootPane, "JRootPane.glassPaneFullHeight", false) ? 1 : 0;
                n3 = n4 != 0 ? 0 : n9;
                jRootPane.getGlassPane().setBounds(n5, n6 + n3, n7, n8 - n3);
            }
            if ((jMenuBar = jRootPane.getJMenuBar()) != null && jMenuBar.isVisible()) {
                int n11 = n3 = !bl && FlatRootPaneUI.this.titlePane != null && FlatRootPaneUI.this.titlePane.isMenuBarEmbedded() ? 1 : 0;
                if (n3 != 0) {
                    FlatRootPaneUI.this.titlePane.validate();
                    jMenuBar.setBounds(FlatRootPaneUI.this.titlePane.getMenuBarBounds());
                } else {
                    n2 = 0;
                    n = n7;
                    if (FlatRootPaneUI.this.titlePane != null && FlatRootPaneUI.isFullWindowContent(jRootPane)) {
                        int n12 = Math.min(FlatRootPaneUI.this.titlePane.getPreferredSize().width, n7);
                        n -= n12;
                        if (!FlatRootPaneUI.this.titlePane.getComponentOrientation().isLeftToRight()) {
                            n2 = n12;
                        }
                    }
                    Dimension dimension = jMenuBar.getPreferredSize();
                    jMenuBar.setBounds(n2, n9, n, dimension.height);
                    n9 += dimension.height;
                }
            }
            if ((container2 = jRootPane.getContentPane()) != null) {
                container2.setBounds(0, n9, n7, Math.max(n8 - n9, 0));
            }
            if (FlatRootPaneUI.this.titlePane != null) {
                FlatRootPaneUI.this.titlePane.menuBarLayouted();
            }
        }

        @Override
        public void invalidateLayout(Container container) {
            if (FlatRootPaneUI.this.titlePane != null) {
                FlatRootPaneUI.this.titlePane.menuBarInvalidate();
            }
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }
    }
}

