/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.ColorFunctions;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

public class DerivedColor
extends ColorUIResource {
    private final ColorFunctions.ColorFunction[] functions;
    private boolean hasBaseOfDefaultColor;
    private int baseOfDefaultColorRGB;

    public DerivedColor(Color color, ColorFunctions.ColorFunction ... colorFunctionArray) {
        super(color != null ? color : Color.red);
        this.functions = colorFunctionArray;
    }

    public Color derive(Color color) {
        if (this.hasBaseOfDefaultColor && this.baseOfDefaultColorRGB == color.getRGB() || color == this) {
            return this;
        }
        Color color2 = ColorFunctions.applyFunctions(color, this.functions);
        if (!this.hasBaseOfDefaultColor && color2.getRGB() == this.getRGB()) {
            this.hasBaseOfDefaultColor = true;
            this.baseOfDefaultColorRGB = color.getRGB();
        }
        return color2;
    }

    public ColorFunctions.ColorFunction[] getFunctions() {
        return this.functions;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        for (ColorFunctions.ColorFunction colorFunction : this.functions) {
            stringBuilder.append('\n');
            stringBuilder.append(colorFunction.toString());
        }
        return stringBuilder.toString();
    }
}

