/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class SoftCache<K, V>
implements Map<K, V> {
    private final Map<K, CacheReference<K, V>> map;
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public SoftCache() {
        this.map = new HashMap<K, CacheReference<K, V>>();
    }

    public SoftCache(int n) {
        this.map = new HashMap<K, CacheReference<K, V>>(n);
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.expungeStaleEntries();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        this.expungeStaleEntries();
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object object) {
        this.expungeStaleEntries();
        return this.getRef(this.map.get(object));
    }

    @Override
    public V put(K k, V v) {
        this.expungeStaleEntries();
        return this.getRef(this.map.put(k, new CacheReference<K, V>(k, v, this.queue)));
    }

    @Override
    public V remove(Object object) {
        this.expungeStaleEntries();
        return this.getRef(this.map.remove(object));
    }

    private V getRef(CacheReference<K, V> cacheReference) {
        return cacheReference != null ? (V)cacheReference.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.expungeStaleEntries();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.expungeStaleEntries();
    }

    @Override
    public Set<K> keySet() {
        this.expungeStaleEntries();
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        throw new UnsupportedOperationException();
    }

    private void expungeStaleEntries() {
        Reference<V> reference;
        while ((reference = this.queue.poll()) != null) {
            this.map.remove(((CacheReference)reference).key);
        }
    }

    private static class CacheReference<K, V>
    extends SoftReference<V> {
        final K key;

        CacheReference(K k, V v, ReferenceQueue<? super V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
        }
    }
}

