/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueDatagramChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueDatagramChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.DatagramSocketAddress;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;

public final class KQueueDatagramChannel
extends AbstractKQueueDatagramChannel
implements DatagramChannel {
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private volatile boolean connected;
    private final KQueueDatagramChannelConfig config = new KQueueDatagramChannelConfig(this);

    public KQueueDatagramChannel() {
        super(null, BsdSocket.newSocketDgram(), false);
    }

    public KQueueDatagramChannel(InternetProtocolFamily internetProtocolFamily) {
        super(null, BsdSocket.newSocketDgram(internetProtocolFamily), false);
    }

    public KQueueDatagramChannel(int n) {
        this(new BsdSocket(n), true);
    }

    KQueueDatagramChannel(BsdSocket bsdSocket, boolean bl) {
        super(null, bsdSocket, bl);
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public ChannelFuture joinGroup(InetAddress inetAddress) {
        return this.joinGroup(inetAddress, this.newPromise());
    }

    public ChannelFuture joinGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            NetworkInterface networkInterface = this.config().getNetworkInterface();
            if (networkInterface == null) {
                networkInterface = NetworkInterface.getByInetAddress(this.localAddress().getAddress());
            }
            return this.joinGroup(inetAddress, networkInterface, null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure((Throwable)socketException);
            return channelPromise;
        }
    }

    public ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.joinGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    public ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.joinGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    public ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.joinGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    public ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        channelPromise.setFailure((Throwable)new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    public ChannelFuture leaveGroup(InetAddress inetAddress) {
        return this.leaveGroup(inetAddress, this.newPromise());
    }

    public ChannelFuture leaveGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.leaveGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure((Throwable)socketException);
            return channelPromise;
        }
    }

    public ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    public ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.leaveGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    public ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.leaveGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    public ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        channelPromise.setFailure((Throwable)new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    public ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.block(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    public ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)inetAddress2, (String)"sourceToBlock");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        channelPromise.setFailure((Throwable)new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    public ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2) {
        return this.block(inetAddress, inetAddress2, this.newPromise());
    }

    public ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2, ChannelPromise channelPromise) {
        try {
            return this.block(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), inetAddress2, channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueDatagramChannelUnsafe();
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        super.doBind(socketAddress);
        this.active = true;
    }

    @Override
    protected boolean doWriteMessage(Object object) {
        long l;
        InetSocketAddress inetSocketAddress;
        ByteBuf byteBuf;
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            byteBuf = (ByteBuf)addressedEnvelope.content();
            inetSocketAddress = (InetSocketAddress)addressedEnvelope.recipient();
        } else {
            byteBuf = (ByteBuf)object;
            inetSocketAddress = null;
        }
        int n = byteBuf.readableBytes();
        if (n == 0) {
            return true;
        }
        if (byteBuf.hasMemoryAddress()) {
            long l2 = byteBuf.memoryAddress();
            l = inetSocketAddress == null ? (long)this.socket.writeAddress(l2, byteBuf.readerIndex(), byteBuf.writerIndex()) : (long)this.socket.sendToAddress(l2, byteBuf.readerIndex(), byteBuf.writerIndex(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        } else if (byteBuf.nioBufferCount() > 1) {
            IovArray iovArray = ((KQueueEventLoop)this.eventLoop()).cleanArray();
            iovArray.add(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
            int n2 = iovArray.count();
            assert (n2 != 0);
            l = inetSocketAddress == null ? this.socket.writevAddresses(iovArray.memoryAddress(0), n2) : (long)this.socket.sendToAddresses(iovArray.memoryAddress(0), n2, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        } else {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes());
            l = inetSocketAddress == null ? (long)this.socket.write(byteBuffer, byteBuffer.position(), byteBuffer.limit()) : (long)this.socket.sendTo(byteBuffer, byteBuffer.position(), byteBuffer.limit(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        return l > 0L;
    }

    private static void checkUnresolved(AddressedEnvelope<?, ?> addressedEnvelope) {
        if (addressedEnvelope.recipient() instanceof InetSocketAddress && ((InetSocketAddress)addressedEnvelope.recipient()).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected Object filterOutboundMessage(Object object) {
        if (object instanceof DatagramPacket) {
            DatagramPacket datagramPacket = (DatagramPacket)object;
            KQueueDatagramChannel.checkUnresolved(datagramPacket);
            ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? new DatagramPacket(this.newDirectBuffer(datagramPacket, byteBuf), (InetSocketAddress)datagramPacket.recipient()) : object;
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? this.newDirectBuffer(byteBuf) : byteBuf;
        }
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            KQueueDatagramChannel.checkUnresolved(addressedEnvelope);
            if (addressedEnvelope.content() instanceof ByteBuf && (addressedEnvelope.recipient() == null || addressedEnvelope.recipient() instanceof InetSocketAddress)) {
                ByteBuf byteBuf = (ByteBuf)addressedEnvelope.content();
                return UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf) ? new DefaultAddressedEnvelope((Object)this.newDirectBuffer(addressedEnvelope, byteBuf), (SocketAddress)((InetSocketAddress)addressedEnvelope.recipient())) : addressedEnvelope;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
    }

    @Override
    public KQueueDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected void doDisconnect() {
        this.socket.disconnect();
        this.active = false;
        this.connected = false;
        this.resetCachedAddresses();
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (super.doConnect(socketAddress, socketAddress2)) {
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.connected = false;
    }

    final class KQueueDatagramChannelUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        KQueueDatagramChannelUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void readReady(KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle) {
            assert (KQueueDatagramChannel.this.eventLoop().inEventLoop());
            KQueueDatagramChannelConfig kQueueDatagramChannelConfig = KQueueDatagramChannel.this.config();
            if (KQueueDatagramChannel.this.shouldBreakReadReady((ChannelConfig)kQueueDatagramChannelConfig)) {
                this.clearReadFilter0();
                return;
            }
            ChannelPipeline channelPipeline = KQueueDatagramChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = kQueueDatagramChannelConfig.getAllocator();
            kQueueRecvByteAllocatorHandle.reset((ChannelConfig)kQueueDatagramChannelConfig);
            this.readReadyBefore();
            Throwable throwable = null;
            try {
                ByteBuf byteBuf = null;
                try {
                    boolean bl = KQueueDatagramChannel.this.isConnected();
                    do {
                        DatagramPacket datagramPacket;
                        Object object;
                        byteBuf = kQueueRecvByteAllocatorHandle.allocate(byteBufAllocator);
                        kQueueRecvByteAllocatorHandle.attemptedBytesRead(byteBuf.writableBytes());
                        if (bl) {
                            try {
                                kQueueRecvByteAllocatorHandle.lastBytesRead(KQueueDatagramChannel.this.doReadBytes(byteBuf));
                            }
                            catch (Errors.NativeIoException nativeIoException) {
                                if (nativeIoException.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
                                    object = new PortUnreachableException(nativeIoException.getMessage());
                                    ((Throwable)object).initCause(nativeIoException);
                                    throw object;
                                }
                                throw nativeIoException;
                            }
                            if (kQueueRecvByteAllocatorHandle.lastBytesRead() <= 0) {
                                byteBuf.release();
                                byteBuf = null;
                                break;
                            }
                            datagramPacket = new DatagramPacket(byteBuf, (InetSocketAddress)this.localAddress(), (InetSocketAddress)this.remoteAddress());
                        } else {
                            DatagramSocketAddress datagramSocketAddress;
                            if (byteBuf.hasMemoryAddress()) {
                                datagramSocketAddress = KQueueDatagramChannel.this.socket.recvFromAddress(byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity());
                            } else {
                                object = byteBuf.internalNioBuffer(byteBuf.writerIndex(), byteBuf.writableBytes());
                                datagramSocketAddress = KQueueDatagramChannel.this.socket.recvFrom((ByteBuffer)object, ((Buffer)object).position(), ((Buffer)object).limit());
                            }
                            if (datagramSocketAddress == null) {
                                kQueueRecvByteAllocatorHandle.lastBytesRead(-1);
                                byteBuf.release();
                                byteBuf = null;
                                break;
                            }
                            object = datagramSocketAddress.localAddress();
                            if (object == null) {
                                object = (InetSocketAddress)this.localAddress();
                            }
                            kQueueRecvByteAllocatorHandle.lastBytesRead(datagramSocketAddress.receivedAmount());
                            byteBuf.writerIndex(byteBuf.writerIndex() + kQueueRecvByteAllocatorHandle.lastBytesRead());
                            datagramPacket = new DatagramPacket(byteBuf, (InetSocketAddress)object, (InetSocketAddress)datagramSocketAddress);
                        }
                        kQueueRecvByteAllocatorHandle.incMessagesRead(1);
                        this.readPending = false;
                        channelPipeline.fireChannelRead((Object)datagramPacket);
                        byteBuf = null;
                    } while (kQueueRecvByteAllocatorHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER));
                }
                catch (Throwable throwable2) {
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                    throwable = throwable2;
                }
                kQueueRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (throwable != null) {
                    channelPipeline.fireExceptionCaught(throwable);
                }
            }
            finally {
                this.readReadyFinally((ChannelConfig)kQueueDatagramChannelConfig);
            }
        }
    }
}

