/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sm.packet;

import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaErrorTextElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class StreamManagement {
    public static final String NAMESPACE = "urn:xmpp:sm:3";

    public static final class AckRequest
    implements Nonza {
        public static final String ELEMENT = "r";
        public static final AckRequest INSTANCE = new AckRequest();

        private AckRequest() {
        }

        public CharSequence toXML(XmlEnvironment xmlEnvironment) {
            return "<r xmlns='urn:xmpp:sm:3'/>";
        }

        public String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class AckAnswer
    implements Nonza {
        public static final String ELEMENT = "a";
        private final long handledCount;

        public AckAnswer(long l) {
            this.handledCount = l;
        }

        public long getHandledCount() {
            return this.handledCount;
        }

        public CharSequence toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlStringBuilder.attribute("h", Long.toString(this.handledCount));
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }

        public String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Resumed
    extends AbstractResume {
        public static final String ELEMENT = "resumed";

        public Resumed(long l, String string) {
            super(l, string);
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Resume
    extends AbstractResume {
        public static final String ELEMENT = "resume";

        public Resume(long l, String string) {
            super(l, string);
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    private static abstract class AbstractResume
    implements Nonza {
        private final long handledCount;
        private final String previd;

        private AbstractResume(long l, String string) {
            this.handledCount = l;
            this.previd = string;
        }

        public long getHandledCount() {
            return this.handledCount;
        }

        public String getPrevId() {
            return this.previd;
        }

        public final String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public final XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlStringBuilder.attribute("h", Long.toString(this.handledCount));
            xmlStringBuilder.attribute("previd", this.previd);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }
    }

    public static class Failed
    implements Nonza {
        public static final String ELEMENT = "failed";
        private final StanzaError.Condition condition;
        private final List<StanzaErrorTextElement> textElements;

        public Failed() {
            this(null, null);
        }

        public Failed(StanzaError.Condition condition, List<StanzaErrorTextElement> list) {
            this.condition = condition;
            this.textElements = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        }

        public StanzaError.Condition getStanzaErrorCondition() {
            return this.condition;
        }

        public List<StanzaErrorTextElement> getTextElements() {
            return this.textElements;
        }

        public CharSequence toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            if (this.condition == null && this.textElements.isEmpty()) {
                xmlStringBuilder.closeEmptyElement();
            } else {
                if (this.condition != null) {
                    xmlStringBuilder.rightAngleBracket();
                    xmlStringBuilder.append((CharSequence)this.condition.toString());
                    xmlStringBuilder.xmlnsAttribute("urn:ietf:params:xml:ns:xmpp-stanzas");
                    xmlStringBuilder.closeEmptyElement();
                }
                xmlStringBuilder.append(this.textElements);
                xmlStringBuilder.closeElement(ELEMENT);
            }
            return xmlStringBuilder;
        }

        public String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Enabled
    extends AbstractEnable {
        public static final String ELEMENT = "enabled";
        private final String id;
        private final String location;

        public Enabled(String string, boolean bl) {
            this(string, bl, null, -1);
        }

        public Enabled(String string, boolean bl, String string2, int n) {
            this.id = string;
            this.resume = bl;
            this.location = string2;
            this.max = n;
        }

        public String getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        public CharSequence toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlStringBuilder.optAttribute("id", this.id);
            this.maybeAddResumeAttributeTo(xmlStringBuilder);
            xmlStringBuilder.optAttribute("location", this.location);
            this.maybeAddMaxAttributeTo(xmlStringBuilder);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Enable
    extends AbstractEnable {
        public static final String ELEMENT = "enable";
        public static final Enable INSTANCE = new Enable();

        private Enable() {
        }

        public Enable(boolean bl) {
            this.resume = bl;
        }

        public Enable(boolean bl, int n) {
            this(bl);
            this.max = n;
        }

        public CharSequence toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            this.maybeAddResumeAttributeTo(xmlStringBuilder);
            this.maybeAddMaxAttributeTo(xmlStringBuilder);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    private static abstract class AbstractEnable
    implements Nonza {
        protected int max = -1;
        protected boolean resume = false;

        private AbstractEnable() {
        }

        protected void maybeAddResumeAttributeTo(XmlStringBuilder xmlStringBuilder) {
            if (this.resume) {
                xmlStringBuilder.attribute("resume", "true");
            }
        }

        protected void maybeAddMaxAttributeTo(XmlStringBuilder xmlStringBuilder) {
            if (this.max > 0) {
                xmlStringBuilder.attribute("max", Integer.toString(this.max));
            }
        }

        public boolean isResumeSet() {
            return this.resume;
        }

        public int getMaxResumptionTime() {
            return this.max;
        }

        public final String getNamespace() {
            return StreamManagement.NAMESPACE;
        }
    }

    public static final class StreamManagementFeature
    implements ExtensionElement {
        public static final String ELEMENT = "sm";
        public static final StreamManagementFeature INSTANCE = new StreamManagementFeature();

        private StreamManagementFeature() {
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public CharSequence toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }
    }
}

