/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementResult;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.ExposedSavepoint;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcPreparedStatementImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcSavepoint;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0016\u0010*\u001a\u00020(2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0,H\u0016J,\u0010\u0015\u001a\u0002H-\"\u0004\b\u0000\u0010-2\u0017\u0010.\u001a\u0013\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002H-0/\u00a2\u0006\u0002\b1H\u0016\u00a2\u0006\u0002\u00102J#\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\f2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\f07H\u0016\u00a2\u0006\u0002\u00108J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\f2\u0006\u00109\u001a\u00020\u0006H\u0016J\u0010\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020(H\u0016J\u0010\u0010=\u001a\u00020(2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020\fH\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR$\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R&\u0010\"\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006@"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "Ljava/sql/Connection;", "connection", "(Ljava/sql/Connection;)V", "value", "", "autoCommit", "getAutoCommit", "()Z", "setAutoCommit", "(Z)V", "", "catalog", "getCatalog", "()Ljava/lang/String;", "setCatalog", "(Ljava/lang/String;)V", "getConnection", "()Ljava/sql/Connection;", "isClosed", "metadata", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "getMetadata", "()Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "metadata$delegate", "Lkotlin/Lazy;", "readOnly", "getReadOnly", "setReadOnly", "schema", "getSchema", "setSchema", "", "transactionIsolation", "getTransactionIsolation", "()I", "setTransactionIsolation", "(I)V", "close", "", "commit", "executeInBatch", "sqls", "", "T", "body", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "prepareStatement", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "sql", "columns", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "returnKeys", "releaseSavepoint", "savepoint", "Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "rollback", "setSavepoint", "name", "exposed-jdbc"})
public final class JdbcConnectionImpl
implements ExposedConnection<Connection> {
    private final Connection connection;
    private int transactionIsolation;
    private final Lazy metadata$delegate;

    public JdbcConnectionImpl(Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"");
        this.connection = connection;
        this.transactionIsolation = -1;
        this.metadata$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JdbcDatabaseMetadataImpl>(this){
            final /* synthetic */ JdbcConnectionImpl this$0;
            {
                this.this$0 = jdbcConnectionImpl;
                super(0);
            }

            public final JdbcDatabaseMetadataImpl invoke() {
                String string = this.this$0.getCatalog();
                DatabaseMetaData databaseMetaData = this.this$0.getConnection().getMetaData();
                Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"");
                return new JdbcDatabaseMetadataImpl(string, databaseMetaData);
            }
        }));
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getCatalog() {
        String string;
        String string2;
        String string3;
        try {
            string3 = this.getConnection().getCatalog();
        }
        catch (Exception exception) {
            string3 = null;
        }
        if ((string2 = string3) == null) {
            string2 = string = this.getConnection().getMetaData().getUserName();
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    public void setCatalog(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            this.getConnection().setCatalog(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSchema() {
        String string;
        try {
            string = this.getConnection().getSchema();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public void setSchema(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            this.getConnection().setSchema(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() {
        this.getConnection().commit();
    }

    public void rollback() {
        this.getConnection().rollback();
    }

    public boolean isClosed() {
        return this.getConnection().isClosed();
    }

    public void close() {
        this.getConnection().close();
    }

    public boolean getAutoCommit() {
        return this.getConnection().getAutoCommit();
    }

    public void setAutoCommit(boolean bl) {
        this.getConnection().setAutoCommit(bl);
    }

    public boolean getReadOnly() {
        return this.getConnection().isReadOnly();
    }

    public void setReadOnly(boolean bl) {
        this.getConnection().setReadOnly(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolation() {
        if (this.transactionIsolation == -1) {
            JdbcConnectionImpl jdbcConnectionImpl = this;
            synchronized (jdbcConnectionImpl) {
                boolean bl = false;
                this.transactionIsolation = this.getConnection().getTransactionIsolation();
                Unit unit = Unit.INSTANCE;
            }
        }
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int n) {
        if (this.transactionIsolation != n) {
            this.getConnection().setTransactionIsolation(n);
            this.transactionIsolation = n;
        }
    }

    private final JdbcDatabaseMetadataImpl getMetadata() {
        Lazy lazy = this.metadata$delegate;
        return (JdbcDatabaseMetadataImpl)((Object)lazy.getValue());
    }

    public <T> T metadata(Function1<? super ExposedDatabaseMetadata, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return (T)function1.invoke((Object)this.getMetadata());
    }

    public PreparedStatementApi prepareStatement(String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = bl ? 1 : 2;
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"");
        return new JdbcPreparedStatementImpl(preparedStatement, bl);
    }

    public PreparedStatementApi prepareStatement(String string, String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"");
        return new JdbcPreparedStatementImpl(preparedStatement, true);
    }

    public void executeInBatch(List<String> list) {
        boolean bl;
        List list2;
        Object object;
        boolean bl2;
        Iterable iterable;
        block9: {
            Intrinsics.checkNotNullParameter(list, (String)"");
            iterable = list;
            bl2 = false;
            object = iterable;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl3 = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                StatementType statementType;
                Object v0;
                Collection collection2;
                block8: {
                    Object t = iterator.next();
                    String string = (String)t;
                    collection2 = collection3;
                    boolean bl4 = false;
                    Iterable iterable2 = (Iterable)EntriesMappings.entries$0;
                    for (Object t2 : iterable2) {
                        StatementType statementType2 = (StatementType)t2;
                        boolean bl5 = false;
                        if (!StringsKt.startsWith((String)string, (String)statementType2.name(), (boolean)true)) continue;
                        v0 = t2;
                        break block8;
                    }
                    v0 = null;
                }
                if ((statementType = (StatementType)v0) == null) {
                    statementType = StatementType.OTHER;
                }
                collection2.add(statementType);
            }
            list2 = (List)collection3;
            iterable = list2;
            bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Collection collection3 : iterable) {
                    StatementType statementType = (StatementType)collection3;
                    boolean bl6 = false;
                    if (!(statementType == StatementType.SELECT)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (!bl) {
            bl2 = false;
            String string = "SELECT statements are unsupported in batch execution";
            throw new IllegalStateException(string.toString());
        }
        StatementType statementType = (StatementType)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)list2));
        if (statementType == null) {
            statementType = StatementType.OTHER;
        }
        iterable = statementType;
        object = CollectionsKt.emptyList();
        Statement<Unit> statement = new Statement<Unit>((StatementType)iterable, this, list, (List<? extends Table>)object){
            final /* synthetic */ JdbcConnectionImpl this$0;
            final /* synthetic */ List<String> $sqls;
            {
                this.this$0 = jdbcConnectionImpl;
                this.$sqls = list;
                super(statementType, list2);
            }

            public PreparedStatementApi prepared(Transaction transaction, String string) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"");
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                PreparedStatementApi preparedStatementApi = super.prepared(transaction, StringsKt.substringBefore$default((String)string, (char)'\n', null, (int)2, null));
                java.sql.Statement statement = this.this$0.getConnection().createStatement();
                List<String> list = this.$sqls;
                java.sql.Statement statement2 = statement;
                boolean bl = false;
                Iterable iterable = list;
                boolean bl2 = false;
                for (T t : iterable) {
                    String string2 = (String)t;
                    boolean bl3 = false;
                    statement2.addBatch(string2);
                }
                java.sql.Statement statement3 = statement;
                return new PreparedStatementApi(preparedStatementApi, statement3){
                    private final /* synthetic */ PreparedStatementApi $$delegate_0;
                    final /* synthetic */ PreparedStatementApi $originalStatement;
                    final /* synthetic */ java.sql.Statement $batchStatement;
                    {
                        this.$originalStatement = preparedStatementApi;
                        this.$batchStatement = statement;
                        this.$$delegate_0 = preparedStatementApi;
                    }

                    public Integer getFetchSize() {
                        return this.$$delegate_0.getFetchSize();
                    }

                    public void setFetchSize(Integer n) {
                        this.$$delegate_0.setFetchSize(n);
                    }

                    public ResultSet getResultSet() {
                        return this.$$delegate_0.getResultSet();
                    }

                    public Integer getTimeout() {
                        return this.$$delegate_0.getTimeout();
                    }

                    public void setTimeout(Integer n) {
                        this.$$delegate_0.setTimeout(n);
                    }

                    public void addBatch() {
                        this.$$delegate_0.addBatch();
                    }

                    public void cancel() {
                        this.$$delegate_0.cancel();
                    }

                    public List<Integer> executeBatch() {
                        return this.$$delegate_0.executeBatch();
                    }

                    public List<StatementResult> executeMultiple() {
                        return this.$$delegate_0.executeMultiple();
                    }

                    public ResultSet executeQuery() {
                        return this.$$delegate_0.executeQuery();
                    }

                    public int fillParameters(Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> iterable) {
                        Intrinsics.checkNotNullParameter(iterable, (String)"");
                        return this.$$delegate_0.fillParameters(iterable);
                    }

                    public void set(int n, Object object) {
                        Intrinsics.checkNotNullParameter((Object)object, (String)"");
                        this.$$delegate_0.set(n, object);
                    }

                    public void setArray(int n, String string, Object[] objectArray) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"");
                        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
                        this.$$delegate_0.setArray(n, string, objectArray);
                    }

                    public void setInputStream(int n, InputStream inputStream, boolean bl) {
                        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
                        this.$$delegate_0.setInputStream(n, inputStream, bl);
                    }

                    public void setNull(int n, IColumnType<?> iColumnType) {
                        Intrinsics.checkNotNullParameter(iColumnType, (String)"");
                        this.$$delegate_0.setNull(n, iColumnType);
                    }

                    public void closeIfPossible() {
                        this.$batchStatement.close();
                        this.$originalStatement.closeIfPossible();
                    }

                    public int executeUpdate() {
                        this.$batchStatement.executeBatch();
                        return 0;
                    }
                };
            }

            public void executeInternal(PreparedStatementApi preparedStatementApi, Transaction transaction) {
                Intrinsics.checkNotNullParameter((Object)preparedStatementApi, (String)"");
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"");
                preparedStatementApi.executeUpdate();
            }

            public String prepareSQL(Transaction transaction, boolean bl) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"");
                return CollectionsKt.joinToString$default((Iterable)this.$sqls, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }

            public Iterable<Iterable<Pair<ColumnType<?>, Object>>> arguments() {
                return CollectionsKt.emptyList();
            }
        };
        statement.execute(TransactionManager.Companion.current());
    }

    public ExposedSavepoint setSavepoint(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Savepoint savepoint = this.getConnection().setSavepoint(string);
        Intrinsics.checkNotNullExpressionValue((Object)savepoint, (String)"");
        return new JdbcSavepoint(string, savepoint);
    }

    public void releaseSavepoint(ExposedSavepoint exposedSavepoint) {
        Intrinsics.checkNotNullParameter((Object)exposedSavepoint, (String)"");
        this.getConnection().releaseSavepoint(((JdbcSavepoint)exposedSavepoint).getSavepoint$exposed_jdbc());
    }

    public void rollback(ExposedSavepoint exposedSavepoint) {
        Intrinsics.checkNotNullParameter((Object)exposedSavepoint, (String)"");
        this.getConnection().rollback(((JdbcSavepoint)exposedSavepoint).getSavepoint$exposed_jdbc());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<StatementType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])StatementType.values()));
        }
    }
}

