/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.InternalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;

@InternalSerializationApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\t\b\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0017J%\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u001dR\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lkotlinx/serialization/internal/AbstractPolymorphicSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "<init>", "()V", "baseClass", "Lkotlin/reflect/KClass;", "getBaseClass", "()Lkotlin/reflect/KClass;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "decodeSequentially", "compositeDecoder", "Lkotlinx/serialization/encoding/CompositeDecoder;", "(Lkotlinx/serialization/encoding/CompositeDecoder;)Ljava/lang/Object;", "findPolymorphicSerializerOrNull", "Lkotlinx/serialization/DeserializationStrategy;", "klassName", "", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)Lkotlinx/serialization/SerializationStrategy;", "kotlinx-serialization-core"})
public abstract class AbstractPolymorphicSerializer<T>
implements KSerializer<T> {
    public abstract KClass<T> getBaseClass();

    @Override
    public final void serialize(Encoder encoder, T t) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        SerializationStrategy<T> serializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer(this, encoder, t);
        Encoder encoder2 = encoder;
        SerialDescriptor serialDescriptor = this.getDescriptor();
        boolean bl = false;
        CompositeEncoder compositeEncoder2 = compositeEncoder = encoder2.beginStructure(serialDescriptor);
        boolean bl2 = false;
        compositeEncoder2.encodeStringElement(this.getDescriptor(), 0, serializationStrategy.getDescriptor().getSerialName());
        SerialDescriptor serialDescriptor2 = this.getDescriptor();
        SerializationStrategy<T> serializationStrategy2 = serializationStrategy;
        boolean bl3 = false;
        Intrinsics.checkNotNull(serializationStrategy2);
        compositeEncoder2.encodeSerializableElement(serialDescriptor2, 1, serializationStrategy2, t);
        compositeEncoder.endStructure(serialDescriptor);
    }

    @Override
    public final T deserialize(Decoder decoder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"");
        Decoder decoder2 = decoder;
        SerialDescriptor serialDescriptor = this.getDescriptor();
        boolean bl = false;
        CompositeDecoder compositeDecoder = decoder2.beginStructure(serialDescriptor);
        Object object2 = compositeDecoder;
        boolean bl2 = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Object object3 = null;
        if (object2.decodeSequentially()) {
            object = this.decodeSequentially((CompositeDecoder)object2);
        } else {
            block5: while (true) {
                int n = object2.decodeElementIndex(this.getDescriptor());
                switch (n) {
                    case -1: {
                        break block5;
                    }
                    case 0: {
                        objectRef.element = object2.decodeStringElement(this.getDescriptor(), n);
                        continue block5;
                    }
                    case 1: {
                        if (objectRef.element == null) {
                            Object cfr_ignored_0 = objectRef.element;
                            Ref.ObjectRef objectRef2 = objectRef;
                            boolean bl3 = false;
                            Ref.ObjectRef objectRef3 = objectRef2;
                            String string = "Cannot read polymorphic value before its type token";
                            throw new IllegalArgumentException(string.toString());
                        }
                        objectRef.element = objectRef.element;
                        DeserializationStrategy deserializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer(this, (CompositeDecoder)object2, (String)objectRef.element);
                        object3 = CompositeDecoder.decodeSerializableElement$default((CompositeDecoder)object2, this.getDescriptor(), n, deserializationStrategy, null, 8, null);
                        continue block5;
                    }
                    default: {
                        StringBuilder stringBuilder = new StringBuilder().append("Invalid index in polymorphic deserialization of ");
                        String string = (String)objectRef.element;
                        if (string == null) {
                            string = "unknown class";
                        }
                        throw new SerializationException(stringBuilder.append(string).append("\n Expected 0, 1 or DECODE_DONE(-1), but found ").append(n).toString());
                    }
                }
                break;
            }
            Object object4 = object3;
            if (object4 == null) {
                boolean bl4 = false;
                String string = "Polymorphic value has not been read for class " + (String)objectRef.element;
                throw new IllegalArgumentException(string.toString());
            }
            object = object4;
            Intrinsics.checkNotNull(object4);
        }
        object2 = object;
        compositeDecoder.endStructure(serialDescriptor);
        return (T)object2;
    }

    private final T decodeSequentially(CompositeDecoder compositeDecoder) {
        String string = compositeDecoder.decodeStringElement(this.getDescriptor(), 0);
        DeserializationStrategy deserializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer(this, compositeDecoder, string);
        return (T)CompositeDecoder.decodeSerializableElement$default(compositeDecoder, this.getDescriptor(), 1, deserializationStrategy, null, 8, null);
    }

    @InternalSerializationApi
    public DeserializationStrategy<T> findPolymorphicSerializerOrNull(CompositeDecoder compositeDecoder, String string) {
        Intrinsics.checkNotNullParameter((Object)compositeDecoder, (String)"");
        return compositeDecoder.getSerializersModule().getPolymorphic(this.getBaseClass(), string);
    }

    @InternalSerializationApi
    public SerializationStrategy<T> findPolymorphicSerializerOrNull(Encoder encoder, T t) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        return encoder.getSerializersModule().getPolymorphic(this.getBaseClass(), t);
    }
}

