/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.stringencoder.Base32;
import org.jivesoftware.smack.util.stringencoder.StringEncoder;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;

public class SimpleDirectoryPersistentCache
implements EntityCapsPersistentCache {
    private static final Logger LOGGER = Logger.getLogger(SimpleDirectoryPersistentCache.class.getName());
    private final File cacheDir;
    private final StringEncoder<String> filenameEncoder;

    public SimpleDirectoryPersistentCache(File file) {
        this(file, (StringEncoder<String>)Base32.getStringEncoder());
    }

    public SimpleDirectoryPersistentCache(File file, StringEncoder<String> stringEncoder) {
        if (!file.exists()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" is not a directory");
        }
        this.cacheDir = file;
        this.filenameEncoder = stringEncoder;
    }

    @Override
    public void addDiscoverInfoByNodePersistent(String string, DiscoverInfo discoverInfo) {
        File file = this.getFileFor(string);
        try {
            if (file.createNewFile()) {
                SimpleDirectoryPersistentCache.writeInfoToFile(file, discoverInfo);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to write disco info to file", iOException);
        }
    }

    @Override
    public DiscoverInfo lookup(String string) {
        File file = this.getFileFor(string);
        if (!file.isFile()) {
            return null;
        }
        DiscoverInfo discoverInfo = null;
        try {
            discoverInfo = SimpleDirectoryPersistentCache.restoreInfoFromFile(file);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Coud not restore info from file", exception);
        }
        return discoverInfo;
    }

    private File getFileFor(String string) {
        String string2 = this.filenameEncoder.encode((Object)string);
        return new File(this.cacheDir, string2);
    }

    @Override
    public void emptyCache() {
        File[] fileArray = this.cacheDir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            file.delete();
        }
    }

    private static void writeInfoToFile(File file, DiscoverInfo discoverInfo) {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));){
            dataOutputStream.writeUTF(discoverInfo.toXML().toString());
        }
    }

    private static DiscoverInfo restoreInfoFromFile(File file) {
        String string;
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            string = dataInputStream.readUTF();
        }
        if (string == null) {
            return null;
        }
        return (DiscoverInfo)PacketParserUtils.parseStanza((String)string);
    }
}

