/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.packet;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;

public final class GeoLocation
implements Serializable,
ExtensionElement,
FormFieldChildElement {
    private static final long serialVersionUID = 1L;
    public static final String NAMESPACE = "http://jabber.org/protocol/geoloc";
    public static final String ELEMENT = "geoloc";
    public static final QName QNAME = new QName("http://jabber.org/protocol/geoloc", "geoloc");
    public static final GeoLocation EMPTY_GEO_LOCATION = GeoLocation.builder().build();
    private final Double accuracy;
    private final Double alt;
    private final Double altAccuracy;
    private final String area;
    private final Double bearing;
    private final String building;
    private final String country;
    private final String countryCode;
    private final String datum;
    private final String description;
    private final Double error;
    private final String floor;
    private final Double lat;
    private final String locality;
    private final Double lon;
    private final String postalcode;
    private final String region;
    private final String room;
    private final Double speed;
    private final String street;
    private final String text;
    private final Date timestamp;
    private final String tzo;
    private final URI uri;
    private final HashCode.Cache hashCodeCache = new HashCode.Cache();

    private GeoLocation(Builder builder) {
        this.accuracy = builder.accuracy;
        this.alt = builder.alt;
        this.altAccuracy = builder.altAccuracy;
        this.area = builder.area;
        this.bearing = builder.bearing;
        this.building = builder.building;
        this.country = builder.country;
        this.countryCode = builder.countryCode;
        this.datum = builder.datum;
        this.description = builder.description;
        this.error = builder.error;
        this.floor = builder.floor;
        this.lat = builder.lat;
        this.locality = builder.locality;
        this.lon = builder.lon;
        this.postalcode = builder.postalcode;
        this.region = builder.region;
        this.room = builder.room;
        this.speed = builder.speed;
        this.street = builder.street;
        this.text = builder.text;
        this.timestamp = builder.timestamp;
        this.tzo = builder.tzo;
        this.uri = builder.uri;
    }

    public Double getAccuracy() {
        return this.accuracy;
    }

    public Double getAlt() {
        return this.alt;
    }

    public Double getAltAccuracy() {
        return this.altAccuracy;
    }

    public String getArea() {
        return this.area;
    }

    public Double getBearing() {
        return this.bearing;
    }

    public String getBuilding() {
        return this.building;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getDatum() {
        return this.datum;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public Double getError() {
        return this.error;
    }

    public String getFloor() {
        return this.floor;
    }

    public Double getLat() {
        return this.lat;
    }

    public String getLocality() {
        return this.locality;
    }

    public Double getLon() {
        return this.lon;
    }

    public String getPostalcode() {
        return this.postalcode;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRoom() {
        return this.room;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public String getStreet() {
        return this.street;
    }

    public String getText() {
        return this.text;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getTzo() {
        return this.tzo;
    }

    public URI getUri() {
        return this.uri;
    }

    public QName getQName() {
        return QNAME;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public CharSequence toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((ExtensionElement)this);
        xmlStringBuilder.rightAngleBracket();
        xmlStringBuilder.optElement("accuracy", (Object)this.accuracy);
        xmlStringBuilder.optElement("alt", (Object)this.alt);
        xmlStringBuilder.optElement("altaccuracy", (Object)this.altAccuracy);
        xmlStringBuilder.optElement("area", this.area);
        xmlStringBuilder.optElement("bearing", (Object)this.bearing);
        xmlStringBuilder.optElement("building", this.building);
        xmlStringBuilder.optElement("country", this.country);
        xmlStringBuilder.optElement("countrycode", this.countryCode);
        xmlStringBuilder.optElement("datum", this.datum);
        xmlStringBuilder.optElement("description", this.description);
        xmlStringBuilder.optElement("error", (Object)this.error);
        xmlStringBuilder.optElement("floor", this.floor);
        xmlStringBuilder.optElement("lat", (Object)this.lat);
        xmlStringBuilder.optElement("locality", this.locality);
        xmlStringBuilder.optElement("lon", (Object)this.lon);
        xmlStringBuilder.optElement("postalcode", this.postalcode);
        xmlStringBuilder.optElement("region", this.region);
        xmlStringBuilder.optElement("room", this.room);
        xmlStringBuilder.optElement("speed", (Object)this.speed);
        xmlStringBuilder.optElement("street", this.street);
        xmlStringBuilder.optElement("text", this.text);
        xmlStringBuilder.optElement("timestamp", this.timestamp);
        xmlStringBuilder.optElement("tzo", this.tzo);
        xmlStringBuilder.optElement("uri", (Object)this.uri);
        xmlStringBuilder.closeElement((NamedElement)this);
        return xmlStringBuilder;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public int hashCode() {
        return this.hashCodeCache.getHashCode(builder -> builder.append((Object)this.accuracy).append((Object)this.alt).append((Object)this.altAccuracy).append((Object)this.area).append((Object)this.bearing).append((Object)this.building).append((Object)this.country).append((Object)this.countryCode).append((Object)this.datum).append((Object)this.description).append((Object)this.error).append((Object)this.floor).append((Object)this.lat).append((Object)this.locality).append((Object)this.lon).append((Object)this.postalcode).append((Object)this.region).append((Object)this.room).append((Object)this.speed).append((Object)this.street).append((Object)this.text).append((Object)this.timestamp).append((Object)this.tzo).append((Object)this.uri));
    }

    public boolean equals(Object object) {
        return EqualsUtil.equals((Object)this, (Object)object, (builder, geoLocation) -> builder.append((Object)this.accuracy, (Object)geoLocation.accuracy).append((Object)this.altAccuracy, (Object)geoLocation.altAccuracy).append((Object)this.area, (Object)geoLocation.area).append((Object)this.bearing, (Object)geoLocation.bearing).append((Object)this.building, (Object)geoLocation.building).append((Object)this.country, (Object)geoLocation.country).append((Object)this.countryCode, (Object)geoLocation.countryCode).append((Object)this.datum, (Object)geoLocation.datum).append((Object)this.description, (Object)geoLocation.description).append((Object)this.error, (Object)geoLocation.error).append((Object)this.floor, (Object)geoLocation.floor).append((Object)this.lat, (Object)geoLocation.lat).append((Object)this.locality, (Object)geoLocation.locality).append((Object)this.lon, (Object)geoLocation.lon).append((Object)this.postalcode, (Object)geoLocation.postalcode).append((Object)this.region, (Object)geoLocation.region).append((Object)this.room, (Object)geoLocation.room).append((Object)this.speed, (Object)geoLocation.speed).append((Object)this.street, (Object)geoLocation.street).append((Object)this.text, (Object)geoLocation.text).append((Object)this.timestamp, (Object)geoLocation.timestamp).append((Object)this.tzo, (Object)geoLocation.tzo).append((Object)this.uri, (Object)geoLocation.uri));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isExclusiveElement() {
        return true;
    }

    public static GeoLocation from(Message message) {
        return (GeoLocation)message.getExtension(GeoLocation.class);
    }

    public static GeoLocation from(FormField formField) {
        return (GeoLocation)formField.getFormFieldChildElement(QNAME);
    }

    public static class Builder {
        private Double accuracy;
        private Double alt;
        private Double altAccuracy;
        private String area;
        private Double bearing;
        private String building;
        private String country;
        private String countryCode;
        private String datum = "WGS84";
        private String description;
        private Double error;
        private String floor;
        private Double lat;
        private String locality;
        private Double lon;
        private String postalcode;
        private String region;
        private String room;
        private Double speed;
        private String street;
        private String text;
        private Date timestamp;
        private String tzo;
        private URI uri;

        public Builder setAccuracy(Double d2) {
            this.accuracy = d2;
            return this;
        }

        public Builder setAlt(Double d2) {
            this.alt = d2;
            return this;
        }

        public Builder setAltAccuracy(Double d2) {
            this.altAccuracy = d2;
            return this;
        }

        public Builder setArea(String string) {
            this.area = string;
            return this;
        }

        public Builder setBearing(Double d2) {
            this.bearing = d2;
            return this;
        }

        public Builder setBuilding(String string) {
            this.building = string;
            return this;
        }

        public Builder setCountry(String string) {
            this.country = string;
            return this;
        }

        public Builder setCountryCode(String string) {
            this.countryCode = string;
            return this;
        }

        public Builder setDatum(String string) {
            this.datum = string;
            return this;
        }

        public Builder setDescription(String string) {
            this.description = string;
            return this;
        }

        @Deprecated
        public Builder setError(Double d2) {
            this.error = d2;
            return this;
        }

        public Builder setFloor(String string) {
            this.floor = string;
            return this;
        }

        public Builder setLat(Double d2) {
            this.lat = d2;
            return this;
        }

        public Builder setLocality(String string) {
            this.locality = string;
            return this;
        }

        public Builder setLon(Double d2) {
            this.lon = d2;
            return this;
        }

        public Builder setPostalcode(String string) {
            this.postalcode = string;
            return this;
        }

        public Builder setRegion(String string) {
            this.region = string;
            return this;
        }

        public Builder setRoom(String string) {
            this.room = string;
            return this;
        }

        public Builder setSpeed(Double d2) {
            this.speed = d2;
            return this;
        }

        public Builder setStreet(String string) {
            this.street = string;
            return this;
        }

        public Builder setText(String string) {
            this.text = string;
            return this;
        }

        public Builder setTimestamp(Date date) {
            this.timestamp = date;
            return this;
        }

        public Builder setTzo(String string) {
            this.tzo = string;
            return this;
        }

        public Builder setUri(URI uRI) {
            this.uri = uRI;
            return this;
        }

        public GeoLocation build() {
            return new GeoLocation(this);
        }
    }
}

