/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.f;
import org.e.a.h;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.jingle.FullJidAndSessionId;
import org.jivesoftware.smackx.jingle.JingleHandler;
import org.jivesoftware.smackx.jingle.JingleSessionHandler;
import org.jivesoftware.smackx.jingle.JingleTransportMethodManager;
import org.jivesoftware.smackx.jingle.JingleUtil;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.JingleIBBTransportManager;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.JingleS5BTransportManager;

public final class JingleManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(JingleManager.class.getName());
    private static final Map<XMPPConnection, JingleManager> INSTANCES = new WeakHashMap<XMPPConnection, JingleManager>();
    private static final ExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final Map<String, JingleHandler> descriptionHandlers = new ConcurrentHashMap<String, JingleHandler>();
    private final Map<FullJidAndSessionId, JingleSessionHandler> jingleSessionHandlers = new ConcurrentHashMap<FullJidAndSessionId, JingleSessionHandler>();
    private final JingleUtil jutil;

    public static ExecutorService getThreadPool() {
        return threadPool;
    }

    public static synchronized JingleManager getInstanceFor(XMPPConnection xMPPConnection) {
        JingleManager jingleManager = INSTANCES.get(xMPPConnection);
        if (jingleManager == null) {
            jingleManager = new JingleManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, jingleManager);
        }
        return jingleManager;
    }

    private JingleManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.jutil = new JingleUtil(xMPPConnection);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("jingle", "urn:xmpp:jingle:1", IQ.Type.set, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                Jingle jingle = (Jingle)iQ;
                f f2 = jingle.getFrom().u();
                String string = jingle.getSid();
                FullJidAndSessionId fullJidAndSessionId = new FullJidAndSessionId((h)f2, string);
                JingleSessionHandler jingleSessionHandler = (JingleSessionHandler)JingleManager.this.jingleSessionHandlers.get(fullJidAndSessionId);
                if (jingleSessionHandler != null) {
                    return jingleSessionHandler.handleJingleSessionRequest(jingle);
                }
                if (jingle.getAction() == JingleAction.session_initiate) {
                    JingleContent jingleContent = jingle.getContents().get(0);
                    JingleContentDescription jingleContentDescription = jingleContent.getDescription();
                    JingleHandler jingleHandler = (JingleHandler)JingleManager.this.descriptionHandlers.get(jingleContentDescription.getNamespace());
                    if (jingleHandler == null) {
                        LOGGER.log(Level.WARNING, "Unsupported Jingle application.");
                        return JingleManager.this.jutil.createSessionTerminateUnsupportedApplications((h)f2, string);
                    }
                    return jingleHandler.handleJingleRequest(jingle);
                }
                LOGGER.log(Level.WARNING, "Unknown session.");
                return JingleManager.this.jutil.createErrorUnknownSession(jingle);
            }
        });
        JingleTransportMethodManager jingleTransportMethodManager = JingleTransportMethodManager.getInstanceFor(xMPPConnection);
        jingleTransportMethodManager.registerTransportManager(JingleIBBTransportManager.getInstanceFor(xMPPConnection));
        jingleTransportMethodManager.registerTransportManager(JingleS5BTransportManager.getInstanceFor(xMPPConnection));
    }

    public JingleHandler registerDescriptionHandler(String string, JingleHandler jingleHandler) {
        return this.descriptionHandlers.put(string, jingleHandler);
    }

    public JingleSessionHandler registerJingleSessionHandler(h h2, String string, JingleSessionHandler jingleSessionHandler) {
        FullJidAndSessionId fullJidAndSessionId = new FullJidAndSessionId(h2, string);
        return this.jingleSessionHandlers.put(fullJidAndSessionId, jingleSessionHandler);
    }

    public JingleSessionHandler unregisterJingleSessionHandler(h h2, String string, JingleSessionHandler jingleSessionHandler) {
        FullJidAndSessionId fullJidAndSessionId = new FullJidAndSessionId(h2, string);
        return this.jingleSessionHandlers.remove(fullJidAndSessionId);
    }

    public static String randomId() {
        return StringUtils.randomString((int)24);
    }
}

