/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mediaelement.element;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;

public class MediaElement
implements FormFieldChildElement {
    public static final String ELEMENT = "media";
    public static final String NAMESPACE = "urn:xmpp:media-element";
    public static final QName QNAME = new QName("urn:xmpp:media-element", "media");
    private final UInt16 height;
    private final UInt16 width;
    private final List<Uri> uris;

    public MediaElement(Builder builder) {
        this.height = builder.height;
        this.width = builder.width;
        this.uris = Collections.unmodifiableList(builder.uris);
    }

    public UInt16 getHeight() {
        return this.height;
    }

    public UInt16 getWidth() {
        return this.width;
    }

    public List<Uri> getUris() {
        return this.uris;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public QName getQName() {
        return QNAME;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
        xmlStringBuilder.optAttributeCs("height", (CharSequence)this.height).optAttributeCs("width", (CharSequence)this.width).rightAngleBracket();
        xmlStringBuilder.append(this.uris);
        xmlStringBuilder.closeElement((NamedElement)this);
        return xmlStringBuilder;
    }

    public MediaElement from(FormField formField) {
        return (MediaElement)formField.getFormFieldChildElement(QNAME);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Uri
    implements FullyQualifiedElement {
        public static final String ELEMENT = "uri";
        public static final QName QNAME = new QName("urn:xmpp:media-element", "uri");
        private final URI uri;
        private final String type;

        public Uri(URI uRI, String string) {
            this.uri = (URI)Objects.requireNonNull((Object)uRI);
            this.type = (String)StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"The 'type' argument must not be null or empty");
        }

        public URI getUri() {
            return this.uri;
        }

        public String getType() {
            return this.type;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return MediaElement.NAMESPACE;
        }

        public QName getQName() {
            return QNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlStringBuilder.attribute("type", this.type).rightAngleBracket();
            xmlStringBuilder.escape(this.uri.toString());
            xmlStringBuilder.closeElement((NamedElement)this);
            return xmlStringBuilder;
        }
    }

    public static final class Builder {
        private UInt16 height;
        private UInt16 width;
        private List<Uri> uris = new ArrayList<Uri>();

        public Builder setHeightAndWidth(int n, int n2) {
            return this.setHeightAndWidth(UInt16.from((int)n), UInt16.from((int)n2));
        }

        public Builder setHeightAndWidth(UInt16 uInt16, UInt16 uInt162) {
            this.height = uInt16;
            this.width = uInt162;
            return this;
        }

        public Builder addUri(URI uRI, String string) {
            return this.addUri(new Uri(uRI, string));
        }

        public Builder addUri(Uri uri) {
            this.uris.add(uri);
            return this;
        }

        public MediaElement build() {
            return new MediaElement(this);
        }
    }
}

