/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.bookmarkautojoin;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.b.d;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bookmarks.BookmarkManager;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;

public final class MucBookmarkAutojoinManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(MucBookmarkAutojoinManager.class.getName());
    private static final Map<XMPPConnection, MucBookmarkAutojoinManager> INSTANCES = new WeakHashMap<XMPPConnection, MucBookmarkAutojoinManager>();
    private static boolean autojoinEnabledDefault = false;
    private final MultiUserChatManager multiUserChatManager;
    private final BookmarkManager bookmarkManager;
    private boolean autojoinEnabled = autojoinEnabledDefault;

    public static void setAutojoinPerDefault(boolean bl) {
        autojoinEnabledDefault = bl;
    }

    public static synchronized MucBookmarkAutojoinManager getInstanceFor(XMPPConnection xMPPConnection) {
        MucBookmarkAutojoinManager mucBookmarkAutojoinManager = INSTANCES.get(xMPPConnection);
        if (mucBookmarkAutojoinManager == null) {
            mucBookmarkAutojoinManager = new MucBookmarkAutojoinManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, mucBookmarkAutojoinManager);
        }
        return mucBookmarkAutojoinManager;
    }

    private MucBookmarkAutojoinManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.multiUserChatManager = MultiUserChatManager.getInstanceFor(xMPPConnection);
        this.bookmarkManager = BookmarkManager.getBookmarkManager(xMPPConnection);
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (!MucBookmarkAutojoinManager.this.autojoinEnabled) {
                    return;
                }
                MucBookmarkAutojoinManager.this.autojoinBookmarkedConferences();
            }
        });
    }

    public void setAutojoinEnabled(boolean bl) {
        this.autojoinEnabled = bl;
    }

    public void autojoinBookmarkedConferences() {
        List<BookmarkedConference> list;
        try {
            list = this.bookmarkManager.getBookmarkedConferences();
        }
        catch (InterruptedException | SmackException.NotConnectedException throwable) {
            LOGGER.log(Level.FINER, "Could not get MUC bookmarks", throwable);
            return;
        }
        catch (SmackException.NoResponseException | XMPPException.XMPPErrorException throwable) {
            LOGGER.log(Level.WARNING, "Could not get MUC bookmarks", throwable);
            return;
        }
        XMPPConnection xMPPConnection = this.connection();
        d d2 = xMPPConnection.getUser().d();
        for (BookmarkedConference bookmarkedConference : list) {
            if (!bookmarkedConference.isAutoJoin()) continue;
            d d3 = bookmarkedConference.getNickname();
            if (d3 == null) {
                d3 = d2;
            }
            String string = bookmarkedConference.getPassword();
            MultiUserChat multiUserChat = this.multiUserChatManager.getMultiUserChat(bookmarkedConference.getJid());
            try {
                MultiUserChat.MucCreateConfigFormHandle mucCreateConfigFormHandle = multiUserChat.createOrJoinIfNecessary(d3, string);
                if (mucCreateConfigFormHandle == null) continue;
                mucCreateConfigFormHandle.makeInstant();
            }
            catch (InterruptedException | SmackException.NotConnectedException throwable) {
                LOGGER.log(Level.FINER, "Could not autojoin bookmarked MUC", throwable);
                break;
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException | MultiUserChatException.NotAMucServiceException object) {
                LOGGER.log(Level.WARNING, "Could not autojoin bookmarked MUC", (Throwable)object);
            }
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                MucBookmarkAutojoinManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

