/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.CharHelpers_jvmKt;
import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.TextInclusionStrategy;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.paragraph.Direction;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.TextBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u0005H\u0016J\u0010\u0010@\u001a\u0002092\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010D\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010E\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010F\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0015\u0010G\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bHJ\u0010\u0010I\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0015\u0010J\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bKJ\u0012\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010A\u001a\u00020\u0005H\u0002J\u0010\u0010N\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010O\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010P\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0018\u0010Q\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u00052\u0006\u0010R\u001a\u000202H\u0016J\u0010\u0010S\u001a\u0002022\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010T\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020$H\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010M2\u0006\u0010V\u001a\u00020$H\u0002J\u0018\u0010X\u001a\u00020$2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010Y\u001a\u000202H\u0016J\u0010\u0010Z\u001a\u00020$2\u0006\u0010[\u001a\u000202H\u0002J\u0013\u0010b\u001a\b\u0012\u0004\u0012\u00020M0]H\u0002\u00a2\u0006\u0002\u0010aJ\u0012\u0010c\u001a\u0004\u0018\u00010d2\u0006\u0010A\u001a\u00020\u0005H\u0002J\u001c\u0010e\u001a\u0004\u0018\u00010d2\u0006\u0010A\u001a\u00020\u00052\b\b\u0002\u0010?\u001a\u00020\u0005H\u0002J\u0010\u0010f\u001a\u00020g2\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010h\u001a\u00020g2\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0017\u0010i\u001a\u00020\u00052\u0006\u0010j\u001a\u00020kH\u0016\u00a2\u0006\u0004\bl\u0010mJ'\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u0002092\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020tH\u0016\u00a2\u0006\u0004\bu\u0010vJ\u0010\u0010w\u001a\u0002092\u0006\u0010A\u001a\u00020\u0005H\u0016J'\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020o2\u0006\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b~\u0010\u007fJ\u001a\u0010\u0080\u0001\u001a\u00020o2\u0006\u0010A\u001a\u00020\u0005H\u0016\u00a2\u0006\u0006\b\u0081\u0001\u0010\u0082\u0001J>\u0010\u0083\u0001\u001a\u00020y2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0016\u00a2\u0006\u0006\b\u008c\u0001\u0010\u008d\u0001JT\u0010\u0083\u0001\u001a\u00020y2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0017\u00a2\u0006\u0006\b\u0092\u0001\u0010\u0093\u0001J]\u0010\u0083\u0001\u001a\u00020y2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020$2\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0017\u00a2\u0006\u0006\b\u0097\u0001\u0010\u0098\u0001J\u0012\u0010\u0099\u0001\u001a\u00020y2\u0006\u0010A\u001a\u00020\u0005H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0013\u0010\b\u001a\u00020\t\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010&R\u0014\u0010+\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010&R\u0014\u0010-\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010&R\u0014\u0010/\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010&R\u0014\u00101\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\rR\u001c\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u000109088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0018\u0010\\\u001a\n\u0012\u0004\u0012\u00020M\u0018\u00010]X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010^R\u001a\u0010_\u001a\b\u0012\u0004\u0012\u00020M0]8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010a\u00a8\u0006\u009a\u0001"}, d2={"Landroidx/compose/ui/text/SkiaParagraph;", "Landroidx/compose/ui/text/Paragraph;", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "maxLines", "", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "<init>", "(Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;IIJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getMaxLines", "()I", "I", "getConstraints-msEJaDk", "()J", "J", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont$ui_text", "()Lorg/jetbrains/skia/Font;", "value", "Lorg/jetbrains/skia/paragraph/Paragraph;", "paragraph", "setParagraph", "(Lorg/jetbrains/skia/paragraph/Paragraph;)V", "ellipsis", "", "getEllipsis", "()Ljava/lang/String;", "text", "getText", "width", "", "getWidth", "()F", "height", "getHeight", "minIntrinsicWidth", "getMinIntrinsicWidth", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "firstBaseline", "getFirstBaseline", "lastBaseline", "getLastBaseline", "didExceedMaxLines", "", "getDidExceedMaxLines", "()Z", "lineCount", "getLineCount", "placeholderRects", "", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "getCursorRect", "offset", "getLineLeft", "lineIndex", "getLineRight", "getLineTop", "getLineBottom", "getLineAscent", "getLineAscent$ui_text", "getLineBaseline", "getLineDescent", "getLineDescent$ui_text", "lineMetricsForOffset", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "getLineHeight", "getLineWidth", "getLineStart", "getLineEnd", "visibleEnd", "isLineEllipsized", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineMetricsForVerticalPosition", "getHorizontalPosition", "usePrimaryDirection", "getAlignedStartingPosition", "isRtl", "_lineMetrics", "", "[Lorg/jetbrains/skia/paragraph/LineMetrics;", "lineMetrics", "getLineMetrics", "()[Lorg/jetbrains/skia/paragraph/LineMetrics;", "receiveLineMetrics", "getBoxForwardByOffset", "Lorg/jetbrains/skia/paragraph/TextBox;", "getBoxBackwardByOffset", "getParagraphDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getBidiRunDirection", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getRangeForRect", "Landroidx/compose/ui/text/TextRange;", "rect", "granularity", "Landroidx/compose/ui/text/TextGranularity;", "inclusionStrategy", "Landroidx/compose/ui/text/TextInclusionStrategy;", "getRangeForRect-8-6BmAI", "(Landroidx/compose/ui/geometry/Rect;ILandroidx/compose/ui/text/TextInclusionStrategy;)J", "getBoundingBox", "fillBoundingBoxes", "", "range", "array", "", "arrayStart", "fillBoundingBoxes-8ffj60Q", "(J[FI)V", "getWordBoundary", "getWordBoundary--jx7JFs", "(I)J", "paint", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "color", "Landroidx/compose/ui/graphics/Color;", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "paint-LG529CI", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "brush", "Landroidx/compose/ui/graphics/Brush;", "alpha", "paint-hn5TExg", "(Landroidx/compose/ui/graphics/Canvas;Landroidx/compose/ui/graphics/Brush;FLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "checkOffsetIsValid", "ui-text"})
public final class SkiaParagraph
implements Paragraph {
    private final SkiaParagraphIntrinsics paragraphIntrinsics;
    private final int maxLines;
    private final int overflow;
    private final long constraints;
    private final ParagraphLayouter layouter;
    private org.jetbrains.skia.paragraph.Paragraph paragraph;
    private LineMetrics[] _lineMetrics;
    public static final int $stable = 8;

    private SkiaParagraph(SkiaParagraphIntrinsics skiaParagraphIntrinsics, int n, int n2, long l) {
        int n3;
        ParagraphLayouter paragraphLayouter;
        Intrinsics.checkNotNullParameter((Object)skiaParagraphIntrinsics, (String)"");
        this.paragraphIntrinsics = skiaParagraphIntrinsics;
        this.maxLines = n;
        this.overflow = n2;
        this.constraints = l;
        ParagraphLayouter paragraphLayouter2 = paragraphLayouter = this.paragraphIntrinsics.layouter();
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        paragraphLayouter2.setParagraphStyle(this.maxLines, this.getEllipsis());
        skiaParagraph.layouter = paragraphLayouter;
        this.paragraph = this.layouter.layoutParagraph(this.getWidth());
        boolean bl2 = Constraints.getMinHeight-impl((long)this.constraints) == 0 && Constraints.getMinWidth-impl((long)this.constraints) == 0;
        boolean bl3 = false;
        if (!bl2) {
            bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Setting Constraints.minWidth and Constraints.minHeight is not supported, these should be the default zero values instead.");
        }
        bl2 = this.maxLines >= 1;
        bl3 = false;
        if (!bl2) {
            bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("maxLines should be greater than 0");
        }
        float f = this.getWidth();
        float f2 = this.getHeight();
        bl = false;
        float f3 = f;
        float f4 = f2;
        boolean bl4 = false;
        long l2 = Float.floatToRawIntBits(f3);
        long l3 = Float.floatToRawIntBits(f4);
        this.layouter.setBrushSize-uvyYCjk(Size.constructor-impl((long)(l2 << 32 | l3 & 0xFFFFFFFFL)));
        this.setParagraph(this.layouter.layoutParagraph(this.getWidth()));
        if (TextOverflow.equals-impl0(this.overflow, TextOverflow.Companion.getEllipsis-gIe3tQ8()) && this.paragraph.getHeight() > (float)Constraints.getMaxHeight-impl((long)this.constraints) && this.maxLines > 1 && (n3 = SkiaParagraph_skikoKt.access$numberOfLinesThatFitMaxHeight(this, Constraints.getMaxHeight-impl((long)this.constraints))) >= 0 && n3 != this.maxLines) {
            this.layouter.setParagraphStyle(RangesKt.coerceAtLeast((int)n3, (int)1), this.getEllipsis());
            this.setParagraph(this.layouter.layoutParagraph(this.getWidth()));
        }
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final long getConstraints-msEJaDk() {
        return this.constraints;
    }

    public final Font getDefaultFont$ui_text() {
        return this.layouter.getDefaultFont();
    }

    private final void setParagraph(org.jetbrains.skia.paragraph.Paragraph paragraph) {
        this.paragraph = paragraph;
        this._lineMetrics = null;
    }

    private final String getEllipsis() {
        Object[] objectArray = new TextOverflow[]{TextOverflow.box-impl(TextOverflow.Companion.getEllipsis-gIe3tQ8()), TextOverflow.box-impl(TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8()), TextOverflow.box-impl(TextOverflow.Companion.getStartEllipsis-gIe3tQ8())};
        return CollectionsKt.listOf((Object[])objectArray).contains(TextOverflow.box-impl(this.overflow)) ? "\u2026" : "";
    }

    private final String getText() {
        return this.paragraphIntrinsics.getText();
    }

    @Override
    public float getWidth() {
        return Constraints.getMaxWidth-impl((long)this.constraints);
    }

    @Override
    public float getHeight() {
        return this.paragraph.getHeight();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.firstOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics lineMetrics2 = lineMetrics;
            boolean bl = false;
            f = (float)lineMetrics2.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLastBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.lastOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics lineMetrics2 = lineMetrics;
            boolean bl = false;
            f = (float)lineMetrics2.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.paragraph.didExceedMaxLines();
    }

    @Override
    public int getLineCount() {
        return Intrinsics.areEqual((Object)this.getText(), (Object)"") || this.paragraph.getLineNumber() < 1 ? 1 : this.paragraph.getLineNumber();
    }

    @Override
    public List<Rect> getPlaceholderRects() {
        TextBox[] textBoxArray = this.paragraph.getRectsForPlaceholders();
        boolean bl = false;
        TextBox[] textBoxArray2 = textBoxArray;
        Collection collection = new ArrayList(textBoxArray.length);
        boolean bl2 = false;
        int n = textBoxArray2.length;
        for (int k = 0; k < n; ++k) {
            TextBox textBox;
            TextBox textBox2 = textBox = textBoxArray2[k];
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(Rects_skikoKt.toComposeRect((org.jetbrains.skia.Rect)textBox2.getRect()));
        }
        return (List)collection;
    }

    @Override
    public androidx.compose.ui.graphics.Path getPathForRange(int n, int n2) {
        boolean bl = (0 <= n ? n <= n2 : false) && n2 <= this.getText().length();
        boolean bl2 = false;
        if (!bl) {
            int n3 = 0;
            InlineClassHelperKt.throwIllegalArgumentException("start(" + n + ") or end(" + n2 + ") is out of range [0.." + this.getText().length() + "], or start > end!");
        }
        TextBox[] textBoxArray = this.paragraph.getRectsForRange(n, n2, RectHeightMode.MAX, RectWidthMode.TIGHT);
        androidx.compose.ui.graphics.Path path = SkiaBackedPath_skikoKt.Path();
        for (TextBox textBox : textBoxArray) {
            Path.addRect$default((Path)SkiaBackedPath_skikoKt.asSkiaPath((androidx.compose.ui.graphics.Path)path), (org.jetbrains.skia.Rect)textBox.getRect(), null, (int)0, (int)6, null);
        }
        return path;
    }

    @Override
    public Rect getCursorRect(int n) {
        double d;
        double d2;
        SkiaParagraph skiaParagraph = this;
        int n2 = n;
        boolean bl = false;
        boolean bl2 = 0 <= n2 ? n2 <= skiaParagraph.getText().length() : false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + n2 + ") is out of bounds [0," + skiaParagraph.getText().length() + "]");
        }
        float f = this.getHorizontalPosition(n, true);
        LineMetrics lineMetrics = this.lineMetricsForOffset(n);
        Intrinsics.checkNotNull((Object)lineMetrics);
        LineMetrics lineMetrics2 = lineMetrics;
        bl = n - 1 == lineMetrics2.getStartIndex() && n == this.getText().length();
        FontMetrics fontMetrics = this.getDefaultFont$ui_text().getMetrics();
        double d3 = lineMetrics2.getAscent();
        boolean bl5 = false;
        if (bl) {
            double d4 = -((double)fontMetrics.getAscent());
            d2 = RangesKt.coerceAtMost((double)d3, (double)d4);
        } else {
            d2 = d3;
        }
        double d5 = d2;
        double d6 = lineMetrics2.getDescent();
        boolean bl6 = false;
        if (bl) {
            double d7 = fontMetrics.getDescent();
            d = RangesKt.coerceAtMost((double)d6, (double)d7);
        } else {
            d = d6;
        }
        double d8 = d;
        return new Rect(f, (float)(lineMetrics2.getBaseline() - d5), f, (float)(lineMetrics2.getBaseline() + d8));
    }

    @Override
    public float getLineLeft(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        return lineMetrics != null ? (float)lineMetrics.getLeft() : 0.0f;
    }

    @Override
    public float getLineRight(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        return lineMetrics != null ? (float)lineMetrics.getRight() : 0.0f;
    }

    @Override
    public float getLineTop(int n) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            LineMetrics lineMetrics2 = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(lineMetrics2.getBaseline() - lineMetrics2.getAscent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLineBottom(int n) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics != null) {
            LineMetrics lineMetrics2 = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(lineMetrics2.getBaseline() + lineMetrics2.getDescent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final float getLineAscent$ui_text(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        return -(lineMetrics != null ? (float)lineMetrics.getAscent() : 0.0f);
    }

    @Override
    public float getLineBaseline(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        return lineMetrics != null ? (float)lineMetrics.getBaseline() : 0.0f;
    }

    public final float getLineDescent$ui_text(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        return lineMetrics != null ? (float)lineMetrics.getDescent() : 0.0f;
    }

    private final LineMetrics lineMetricsForOffset(int n) {
        Object object;
        boolean bl = 0 <= n ? n <= this.getText().length() : false;
        if (bl) {
            Object[] objectArray = this.getLineMetrics();
            boolean bl2 = false;
            if (objectArray.length == 0) {
                object = null;
            } else {
                int n2 = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])objectArray), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(n){
                    final /* synthetic */ int $offset$inlined;
                    {
                        this.$offset$inlined = n;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final Integer invoke(Object object) {
                        LineMetrics lineMetrics = (LineMetrics)object;
                        boolean bl = false;
                        return this.$offset$inlined < lineMetrics.getEndIncludingNewline() ? 1 : -1;
                    }
                }), (int)3, null);
                object = objectArray[RangesKt.coerceAtMost((int)(-n2 - 1), (int)ArraysKt.getLastIndex((Object[])objectArray))];
            }
        } else {
            object = null;
        }
        return object;
    }

    @Override
    public float getLineHeight(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        return lineMetrics != null ? (float)lineMetrics.getHeight() : 0.0f;
    }

    @Override
    public float getLineWidth(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        return lineMetrics != null ? (float)lineMetrics.getWidth() : 0.0f;
    }

    @Override
    public int getLineStart(int n) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        return lineMetrics != null ? lineMetrics.getStartIndex() : 0;
    }

    @Override
    public int getLineEnd(int n, boolean bl) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)n);
        if (lineMetrics == null) {
            return 0;
        }
        LineMetrics lineMetrics2 = lineMetrics;
        return bl ? (n > 0 && lineMetrics2.getStartIndex() < this.getLineMetrics()[n - 1].getEndIndex() ? lineMetrics2.getEndIndex() : (lineMetrics2.getStartIndex() < this.getText().length() && this.getText().charAt(lineMetrics2.getStartIndex()) == '\n' ? lineMetrics2.getStartIndex() : lineMetrics2.getEndExcludingWhitespaces())) : lineMetrics2.getEndIndex();
    }

    @Override
    public boolean isLineEllipsized(int n) {
        return false;
    }

    @Override
    public int getLineForOffset(int n) {
        int n2;
        if (n < 0) {
            n2 = 0;
        } else if (n > this.getText().length()) {
            n2 = this.getLineCount() - 1;
        } else {
            LineMetrics lineMetrics = this.lineMetricsForOffset(n);
            Intrinsics.checkNotNull((Object)lineMetrics);
            n2 = lineMetrics.getLineNumber();
        }
        return n2;
    }

    @Override
    public int getLineForVerticalPosition(float f) {
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(f);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    private final LineMetrics getLineMetricsForVerticalPosition(float f) {
        Object object;
        Object[] objectArray = this.getLineMetrics();
        boolean bl = false;
        if (objectArray.length == 0) {
            object = null;
        } else {
            int n = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])objectArray), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(f){
                final /* synthetic */ float $vertical$inlined;
                {
                    this.$vertical$inlined = f;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Integer invoke(Object object) {
                    LineMetrics lineMetrics = (LineMetrics)object;
                    boolean bl = false;
                    return (double)this.$vertical$inlined < lineMetrics.getBaseline() + lineMetrics.getDescent() ? 1 : -1;
                }
            }), (int)3, null);
            object = objectArray[RangesKt.coerceAtMost((int)(-n - 1), (int)ArraysKt.getLastIndex((Object[])objectArray))];
        }
        return object;
    }

    @Override
    public float getHorizontalPosition(int n, boolean bl) {
        float f;
        TextBox textBox = SkiaParagraph.getBoxBackwardByOffset$default(this, n, 0, 2, null);
        TextBox textBox2 = this.getBoxForwardByOffset(n);
        boolean bl2 = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        boolean bl3 = !bl2;
        if (textBox == null && textBox2 == null) {
            f = this.getAlignedStartingPosition(bl2);
        } else if (textBox == null) {
            TextBox textBox3 = textBox2;
            Intrinsics.checkNotNull((Object)textBox3);
            f = androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox3, true);
        } else {
            f = textBox2 == null ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(textBox, false, 1, null) : (textBox2.getDirection() == textBox.getDirection() ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox2, true) : (bl3 && textBox.getDirection() == Direction.LTR ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox2, true) : (bl2 && textBox.getDirection() == Direction.RTL ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox2, true) : (bl ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(textBox, false, 1, null) : androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox2, true)))));
        }
        return f;
    }

    private final float getAlignedStartingPosition(boolean bl) {
        int n = this.layouter.getTextStyle().getTextAlign-e0LSkKk();
        return TextAlign.equals-impl0(n, TextAlign.Companion.getLeft-e0LSkKk()) ? 0.0f : (TextAlign.equals-impl0(n, TextAlign.Companion.getRight-e0LSkKk()) ? this.getWidth() : (TextAlign.equals-impl0(n, TextAlign.Companion.getCenter-e0LSkKk()) ? this.getWidth() / (float)2 : (TextAlign.equals-impl0(n, TextAlign.Companion.getStart-e0LSkKk()) ? (bl ? this.getWidth() : 0.0f) : (TextAlign.equals-impl0(n, TextAlign.Companion.getEnd-e0LSkKk()) ? (bl ? 0.0f : this.getWidth()) : 0.0f))));
    }

    private final LineMetrics[] getLineMetrics() {
        LineMetrics[] lineMetricsArray = this._lineMetrics;
        if (this._lineMetrics == null) {
            LineMetrics[] lineMetricsArray2;
            LineMetrics[] lineMetricsArray3 = lineMetricsArray2 = this.receiveLineMetrics();
            boolean bl = false;
            this._lineMetrics = lineMetricsArray3;
            lineMetricsArray = lineMetricsArray2;
        }
        LineMetrics[] lineMetricsArray4 = lineMetricsArray;
        return lineMetricsArray4;
    }

    private final LineMetrics[] receiveLineMetrics() {
        FontMetrics fontMetrics;
        LineMetrics[] lineMetricsArray;
        if (((CharSequence)this.getText()).length() == 0) {
            lineMetricsArray = this.layouter.emptyLineMetrics$ui_text(this.paragraph);
        } else {
            fontMetrics = this.paragraph.getLineMetrics();
            if (((LineMetrics[])fontMetrics).length == 0) {
                boolean bl = false;
                lineMetricsArray = this.layouter.emptyLineMetrics$ui_text(this.paragraph);
            } else {
                lineMetricsArray = fontMetrics;
            }
        }
        LineMetrics[] lineMetricsArray2 = lineMetricsArray;
        fontMetrics = this.getDefaultFont$ui_text().getMetrics();
        lineMetricsArray2[0] = SkiaParagraph_skikoKt.access$trimFirstAscent(lineMetricsArray2[0], fontMetrics, this.layouter.getTextStyle());
        lineMetricsArray2[lineMetricsArray2.length - 1] = SkiaParagraph_skikoKt.access$trimLastDescent(lineMetricsArray2[lineMetricsArray2.length - 1], fontMetrics, this.layouter.getTextStyle());
        return lineMetricsArray2;
    }

    private final TextBox getBoxForwardByOffset(int n) {
        if (!(0 <= n ? n <= this.getText().length() : false)) {
            return null;
        }
        for (int k = n + 1; k <= this.getText().length(); ++k) {
            TextBox textBox = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(n, k, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (textBox == null) continue;
            return textBox;
        }
        return null;
    }

    private final TextBox getBoxBackwardByOffset(int n, int n2) {
        boolean bl;
        if (!(0 <= n ? n <= this.getText().length() : false)) {
            return null;
        }
        boolean bl2 = bl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        for (int k = n - 1; k >= 0; --k) {
            TextBox textBox = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(k, n2, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (textBox == null) {
                continue;
            }
            if (this.getText().charAt(k) == '\n') {
                TextBox textBox2;
                if (!bl) {
                    float f = textBox.getRect().getBottom() + textBox.getRect().getBottom() - textBox.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(0.0f, textBox.getRect().getBottom(), 0.0f, f);
                    return new TextBox(rect, textBox.getDirection());
                }
                if (k == StringsKt.getLastIndex((CharSequence)this.getText())) {
                    float f = textBox.getRect().getBottom() + textBox.getRect().getBottom() - textBox.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(this.getWidth(), textBox.getRect().getBottom(), this.getWidth(), f);
                    textBox2 = new TextBox(rect, textBox.getDirection());
                } else {
                    TextBox textBox3 = (TextBox)ArraysKt.first((Object[])this.paragraph.getRectsForRange(n, n + 1, RectHeightMode.STRUT, RectWidthMode.TIGHT));
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(textBox3.getRect().getLeft(), textBox3.getRect().getTop(), textBox3.getRect().getLeft(), textBox3.getRect().getBottom());
                    textBox2 = new TextBox(rect, textBox3.getDirection());
                }
                return textBox2;
            }
            return textBox;
        }
        return null;
    }

    static /* synthetic */ TextBox getBoxBackwardByOffset$default(SkiaParagraph skiaParagraph, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return skiaParagraph.getBoxBackwardByOffset(n, n2);
    }

    @Override
    public ResolvedTextDirection getParagraphDirection(int n) {
        return this.paragraphIntrinsics.getTextDirection();
    }

    @Override
    public ResolvedTextDirection getBidiRunDirection(int n) {
        ResolvedTextDirection resolvedTextDirection;
        TextBox textBox = this.getBoxForwardByOffset(n);
        Object object = textBox != null ? textBox.getDirection() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                resolvedTextDirection = ResolvedTextDirection.Rtl;
                break;
            }
            case 2: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            case -1: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolvedTextDirection;
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long l) {
        boolean bl;
        float f;
        TextBox textBox;
        TextBox textBox2;
        boolean bl2;
        long l2 = l;
        int n = 0;
        long l3 = l2;
        boolean bl3 = false;
        int n2 = (int)(l3 >> 32);
        int n3 = 0;
        float f2 = Float.intBitsToFloat(n2);
        l2 = l;
        n = 0;
        l3 = l2;
        bl3 = false;
        n2 = (int)(l3 & 0xFFFFFFFFL);
        n3 = 0;
        int n4 = this.paragraph.getGlyphPositionAtCoordinate(f2, Float.intBitsToFloat(n2)).getPosition();
        int n5 = n4;
        boolean bl4 = 0 <= n5 ? n5 < this.getText().length() : false;
        if (bl4 && (bl2 = CharHelpers_jvmKt.isNonSpacingMark(CharHelpers_skikoKt.codePointAt(this.getText(), n5)))) {
            n = CharHelpers_skikoKt.findPrecedingBreak(this.getText(), n5);
            int n6 = CharHelpers_skikoKt.findFollowingBreak(this.getText(), n5);
            if (n != n5 && n6 != n5) {
                n5 = n6;
            }
        }
        long l4 = l;
        bl3 = false;
        long l5 = l4;
        boolean bl5 = false;
        int n7 = (int)(l5 & 0xFFFFFFFFL);
        boolean bl6 = false;
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(Float.intBitsToFloat(n7));
        if (lineMetrics == null) {
            return n5;
        }
        LineMetrics lineMetrics2 = lineMetrics;
        n = lineMetrics2.getStartIndex() < lineMetrics2.getEndIndex() ? 1 : 0;
        l4 = l;
        bl3 = false;
        l5 = l4;
        bl5 = false;
        n7 = (int)(l5 >> 32);
        bl6 = false;
        if ((double)Float.intBitsToFloat(n7) > lineMetrics2.getLeft()) {
            l4 = l;
            bl3 = false;
            l5 = l4;
            bl5 = false;
            n7 = (int)(l5 >> 32);
            bl6 = false;
            if ((double)Float.intBitsToFloat(n7) < lineMetrics2.getRight()) {
                return n5;
            }
        }
        float f3 = (textBox2 = (textBox = n != 0 ? this.paragraph.getRectsForRange(lineMetrics2.getStartIndex(), lineMetrics2.isHardBreak() ? lineMetrics2.getEndIndex() : lineMetrics2.getEndIndex() - 1, RectHeightMode.STRUT, RectWidthMode.TIGHT) : null)) != null && (textBox2 = (TextBox[])ArraysKt.firstOrNull(textBox2)) != null && (textBox2 = textBox2.getRect()) != null ? textBox2.getLeft() : (float)lineMetrics2.getLeft();
        TextBox textBox3 = textBox;
        float f4 = f = textBox3 != null && (textBox3 = (TextBox)ArraysKt.lastOrNull((Object[])textBox3)) != null && (textBox3 = textBox3.getRect()) != null ? textBox3.getRight() : (float)lineMetrics2.getRight();
        if (f3 == f) {
            return n5;
        }
        boolean bl7 = n != 0 && lineMetrics2.getEndExcludingWhitespaces() > 0 ? ((n3 = lineMetrics2.getEndExcludingWhitespaces() - 1) >= 0 && n3 < this.getText().length() ? CharHelpers_jvmKt.isNonSpacingMark(CharHelpers_skikoKt.codePointAt(this.getText(), n3)) : false) : (bl = false);
        if (bl) {
            return n5;
        }
        n3 = n5;
        long l6 = l;
        bl6 = false;
        long l7 = l6;
        boolean bl8 = false;
        int n8 = (int)(l7 >> 32);
        boolean bl9 = false;
        if (Float.intBitsToFloat(n8) <= f3) {
            l6 = l;
            bl6 = false;
            l7 = l6;
            bl8 = false;
            n8 = (int)(l7 & 0xFFFFFFFFL);
            bl9 = false;
            n3 = this.paragraph.getGlyphPositionAtCoordinate(f3 + 1.0f, Float.intBitsToFloat(n8)).getPosition();
        } else {
            l6 = l;
            bl6 = false;
            l7 = l6;
            bl8 = false;
            n8 = (int)(l7 >> 32);
            bl9 = false;
            if (Float.intBitsToFloat(n8) >= f) {
                boolean bl10;
                l6 = l;
                bl6 = false;
                l7 = l6;
                bl8 = false;
                n8 = (int)(l7 & 0xFFFFFFFFL);
                bl9 = false;
                n3 = this.paragraph.getGlyphPositionAtCoordinate(f - 1.0f, Float.intBitsToFloat(n8)).getPosition();
                boolean bl11 = bl10 = (0 <= n3 ? n3 < ((CharSequence)this.getText()).length() : false) ? CharHelpers_jvmKt.isNeutralDirection(CharHelpers_skikoKt.codePointAt(this.getText(), n3)) : false;
                if (!bl10) {
                    TextBox textBox4 = SkiaParagraph.getBoxBackwardByOffset$default(this, n3, 0, 2, null);
                    if ((textBox4 != null ? textBox4.getDirection() : null) == Direction.RTL) {
                        --n3;
                    }
                }
            }
        }
        return n3;
    }

    @Override
    public long getRangeForRect-8-6BmAI(Rect rect, int n, TextInclusionStrategy textInclusionStrategy) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"");
        Intrinsics.checkNotNullParameter((Object)textInclusionStrategy, (String)"");
        return TextRange.Companion.getZero-d9O1mEE();
    }

    @Override
    public Rect getBoundingBox(int n) {
        TextBox textBox;
        boolean bl = 0 <= n ? n < ((CharSequence)this.getText()).length() : false;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + n + ") is out of bounds [0," + this.getText().length() + ")");
        }
        if ((textBox = this.getBoxForwardByOffset(n)) == null) {
            TextBox textBox2 = this.getBoxBackwardByOffset(n, this.getText().length());
            textBox = textBox2;
            Intrinsics.checkNotNull((Object)textBox2);
        }
        TextBox textBox3 = textBox;
        return Rects_skikoKt.toComposeRect((org.jetbrains.skia.Rect)textBox3.getRect());
    }

    @Override
    public void fillBoundingBoxes-8ffj60Q(long l, float[] fArray, int n) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        System.out.println((Object)"Compose Multiplatform doesn't support fillBoundingBoxes` yet. Follow https://youtrack.jetbrains.com/issue/CMP-720");
    }

    @Override
    public long getWordBoundary--jx7JFs(int n) {
        SkiaParagraph skiaParagraph = this;
        int n2 = n;
        boolean bl = false;
        boolean bl2 = 0 <= n2 ? n2 <= skiaParagraph.getText().length() : false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + n2 + ") is out of bounds [0," + skiaParagraph.getText().length() + "]");
        }
        if (n < this.getText().length() && CharsKt.isWhitespace((char)this.getText().charAt(n)) || n == this.getText().length()) {
            return n > 0 && !CharsKt.isWhitespace((char)this.getText().charAt(n - 1)) ? SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(n - 1)) : TextRangeKt.TextRange(n, n);
        }
        return SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(n));
    }

    @Override
    public void paint-RPmYEkk(Canvas canvas, long l, Shadow shadow, TextDecoration textDecoration) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        paragraphLayouter.setColor-8_81llA(l);
        paragraphLayouter.setTextStyle(shadow, textDecoration);
        skiaParagraph.setParagraph(paragraphLayouter.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    @Override
    public void paint-LG529CI(Canvas canvas, long l, Shadow shadow, TextDecoration textDecoration, DrawStyle drawStyle, int n) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        paragraphLayouter.setColor-8_81llA(l);
        paragraphLayouter.setTextStyle(shadow, textDecoration);
        paragraphLayouter.setDrawStyle(drawStyle);
        paragraphLayouter.setBlendMode-s9anfk8(n);
        skiaParagraph.setParagraph(paragraphLayouter.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    @Override
    public void paint-hn5TExg(Canvas canvas, Brush brush, float f, Shadow shadow, TextDecoration textDecoration, DrawStyle drawStyle, int n) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        boolean bl2 = false;
        float f4 = f2;
        float f5 = f3;
        boolean bl3 = false;
        long l = Float.floatToRawIntBits(f4);
        long l2 = Float.floatToRawIntBits(f5);
        paragraphLayouter.setBrush-12SF9DM(brush, Size.constructor-impl((long)(l << 32 | l2 & 0xFFFFFFFFL)), f);
        paragraphLayouter.setTextStyle(shadow, textDecoration);
        paragraphLayouter.setDrawStyle(drawStyle);
        paragraphLayouter.setBlendMode-s9anfk8(n);
        skiaParagraph.setParagraph(paragraphLayouter.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    private final void checkOffsetIsValid(int n) {
        boolean bl = false;
        boolean bl2 = 0 <= n ? n <= this.getText().length() : false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + n + ") is out of bounds [0," + this.getText().length() + "]");
        }
    }

    public /* synthetic */ SkiaParagraph(SkiaParagraphIntrinsics skiaParagraphIntrinsics, int n, int n2, long l, DefaultConstructorMarker defaultConstructorMarker) {
        this(skiaParagraphIntrinsics, n, n2, l);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.RTL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.LTR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

