/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lio/ktor/network/sockets/SocketOptionsPlatformCapabilities;", "", "<init>", "()V", "Ljava/nio/channels/SocketChannel;", "channel", "", "setReusePort", "(Ljava/nio/channels/SocketChannel;)V", "Ljava/nio/channels/ServerSocketChannel;", "(Ljava/nio/channels/ServerSocketChannel;)V", "Ljava/nio/channels/DatagramChannel;", "(Ljava/nio/channels/DatagramChannel;)V", "", "name", "socketOption", "(Ljava/lang/String;)Ljava/lang/Object;", "", "Ljava/lang/reflect/Field;", "standardSocketOptions", "Ljava/util/Map;", "Ljava/lang/reflect/Method;", "channelSetOption", "Ljava/lang/reflect/Method;", "serverChannelSetOption", "datagramSetOption", "ktor-network"})
public final class SocketOptionsPlatformCapabilities {
    public static final SocketOptionsPlatformCapabilities INSTANCE;
    private static final Map<String, Field> standardSocketOptions;
    private static final Method channelSetOption;
    private static final Method serverChannelSetOption;
    private static final Method datagramSetOption;

    private SocketOptionsPlatformCapabilities() {
    }

    public final void setReusePort(SocketChannel socketChannel) {
        Intrinsics.checkNotNullParameter((Object)socketChannel, (String)"");
        Object object = this.socketOption("SO_REUSEPORT");
        Method method = channelSetOption;
        Intrinsics.checkNotNull((Object)method);
        Object[] objectArray = new Object[]{object, true};
        method.invoke((Object)socketChannel, objectArray);
    }

    public final void setReusePort(ServerSocketChannel serverSocketChannel) {
        Intrinsics.checkNotNullParameter((Object)serverSocketChannel, (String)"");
        Object object = this.socketOption("SO_REUSEPORT");
        Method method = serverChannelSetOption;
        Intrinsics.checkNotNull((Object)method);
        Object[] objectArray = new Object[]{object, true};
        method.invoke((Object)serverSocketChannel, objectArray);
    }

    public final void setReusePort(DatagramChannel datagramChannel) {
        Intrinsics.checkNotNullParameter((Object)datagramChannel, (String)"");
        Object object = this.socketOption("SO_REUSEPORT");
        Method method = datagramSetOption;
        Intrinsics.checkNotNull((Object)method);
        Object[] objectArray = new Object[]{object, true};
        method.invoke((Object)datagramChannel, objectArray);
    }

    private final Object socketOption(String string) {
        Object object = standardSocketOptions.get(string);
        if (object == null || (object = ((Field)object).get(null)) == null) {
            throw new IOException("Socket option " + string + " is not supported");
        }
        return object;
    }

    static {
        Object[] objectArray;
        Object object;
        int n2;
        Object object2;
        GenericDeclaration genericDeclaration;
        INSTANCE = new SocketOptionsPlatformCapabilities();
        try {
            Map map;
            genericDeclaration = Class.forName("java.net.StandardSocketOptions");
            if (genericDeclaration != null && (object2 = genericDeclaration.getFields()) != null) {
                int n3;
                Field field;
                Field[] fieldArray = object2;
                boolean bl = false;
                Field[] fieldArray2 = fieldArray;
                Collection collection = new ArrayList();
                boolean bl2 = false;
                n2 = fieldArray2.length;
                for (int k = 0; k < n2; ++k) {
                    Field object32;
                    field = object32 = fieldArray2[k];
                    boolean field2 = false;
                    n3 = field.getModifiers();
                    boolean bl3 = false;
                    boolean bl4 = Modifier.isStatic(n3) && Modifier.isFinal(n3) && Modifier.isPublic(n3);
                    if (!bl4) continue;
                    collection.add(object32);
                }
                Iterable iterable = (List)collection;
                int n4 = 0;
                int n5 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
                object = iterable;
                Map map2 = new LinkedHashMap(n5);
                n2 = 0;
                Iterator bl7 = object.iterator();
                while (bl7.hasNext()) {
                    Field field2 = field = bl7.next();
                    Map map3 = map2;
                    n3 = 0;
                    String string = field2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    map3.put(string, field);
                }
                map = map2;
            } else {
                map = MapsKt.emptyMap();
            }
            genericDeclaration = map;
        }
        catch (Throwable throwable) {
            genericDeclaration = MapsKt.emptyMap();
        }
        standardSocketOptions = genericDeclaration;
        try {
            Object object3;
            block15: {
                genericDeclaration = Class.forName("java.net.SocketOption");
                object2 = Class.forName("java.nio.channels.SocketChannel");
                Method[] methodArray = ((Class)object2).getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"");
                objectArray = methodArray;
                boolean bl = false;
                for (Object object5 : objectArray) {
                    object = (Method)object5;
                    boolean bl6 = false;
                    n2 = ((Method)object).getModifiers();
                    boolean bl10 = false;
                    boolean bl5 = Modifier.isPublic(n2) && !Modifier.isStatic(n2);
                    if (!(bl5 && Intrinsics.areEqual((Object)((Method)object).getName(), (Object)"setOption") && ((Method)object).getParameterTypes().length == 2 && Intrinsics.areEqual(((Method)object).getReturnType(), (Object)object2) && Intrinsics.areEqual(((Method)object).getParameterTypes()[0], genericDeclaration) && Intrinsics.areEqual(((Method)object).getParameterTypes()[1], Object.class))) continue;
                    object3 = object5;
                    break block15;
                }
                object3 = null;
            }
            genericDeclaration = (Method)object3;
        }
        catch (Throwable throwable) {
            genericDeclaration = null;
        }
        channelSetOption = genericDeclaration;
        try {
            Object object4;
            block16: {
                genericDeclaration = Class.forName("java.net.SocketOption");
                object2 = Class.forName("java.nio.channels.ServerSocketChannel");
                Method[] methodArray = ((Class)object2).getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"");
                objectArray = methodArray;
                boolean bl = false;
                for (Object object7 : objectArray) {
                    object = (Method)object7;
                    boolean bl9 = false;
                    n2 = ((Method)object).getModifiers();
                    boolean bl13 = false;
                    boolean bl6 = Modifier.isPublic(n2) && !Modifier.isStatic(n2);
                    if (!(bl6 && Intrinsics.areEqual((Object)((Method)object).getName(), (Object)"setOption") && ((Method)object).getParameterTypes().length == 2 && Intrinsics.areEqual(((Method)object).getReturnType(), (Object)object2) && Intrinsics.areEqual(((Method)object).getParameterTypes()[0], genericDeclaration) && Intrinsics.areEqual(((Method)object).getParameterTypes()[1], Object.class))) continue;
                    object4 = object7;
                    break block16;
                }
                object4 = null;
            }
            genericDeclaration = (Method)object4;
        }
        catch (Throwable throwable) {
            genericDeclaration = null;
        }
        serverChannelSetOption = genericDeclaration;
        try {
            Object object5;
            block17: {
                genericDeclaration = Class.forName("java.net.SocketOption");
                object2 = Class.forName("java.nio.channels.DatagramChannel");
                Method[] methodArray = ((Class)object2).getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"");
                objectArray = methodArray;
                boolean bl = false;
                for (Object object9 : objectArray) {
                    object = (Method)object9;
                    boolean bl12 = false;
                    n2 = ((Method)object).getModifiers();
                    boolean bl7 = false;
                    boolean bl8 = Modifier.isPublic(n2) && !Modifier.isStatic(n2);
                    if (!(bl8 && Intrinsics.areEqual((Object)((Method)object).getName(), (Object)"setOption") && ((Method)object).getParameterTypes().length == 2 && Intrinsics.areEqual(((Method)object).getReturnType(), (Object)object2) && Intrinsics.areEqual(((Method)object).getParameterTypes()[0], genericDeclaration) && Intrinsics.areEqual(((Method)object).getParameterTypes()[1], Object.class))) continue;
                    object5 = object9;
                    break block17;
                }
                object5 = null;
            }
            genericDeclaration = (Method)object5;
        }
        catch (Throwable throwable) {
            genericDeclaration = null;
        }
        datagramSetOption = genericDeclaration;
    }
}

